<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 留言评论
class MessageAction extends SunnyiAction{
    public function add(){
    	if(sunnyiC("TOKEN_ON")&&!M()->autoCheckToken($_POST))
		{
			$this->error(L("TOKEN_ERROR"));
		}
		//开始验证是否仅开放给会员
		if(sunnyiC("MESSAGE_USER_ONLY")&&intval($_SESSION['user_id'])==0)
		{
			$this->assign("jumpUrl",U("User/login"));
			$this->error(L("PLEASE_LOGIN"));	
		}
    	if(sunnyiC("VERIFY_ON")==1)
		{
			if($_SESSION['verify'] != md5($_POST['verify'])) {
				$this->error(L('VERIFY_ERROR'));
			}
		}
		//字段验证
    	if($_REQUEST['title']=='')
		{
			$this->error(L("TITLE_EMPTY"));
		}
       		if($_REQUEST['user_name']=='')
		{
			$this->error(L("USER_NAME_EMPTY"));
		}
       	if($_REQUEST['user_email']=='')
		{
			$this->error(L("USER_EMAIL_EMPTY"));
		}
       	if($_REQUEST['content']=='')
		{
			$this->error(L("CONTENT_EMPTY"));
		}
		if($_REQUEST['rec_module']=='')
		{
			$this->error(L("INVALID_OPERATION"));
		}
		if(!preg_match("/\w+@\w+\.\w{2,3}\b/i",$_REQUEST['user_email']))
		{
			$this->error(L("EMAIL_FORMAT_ERROR"));
		}
		if($this->check_ip_operation(get_client_ip(),"Message",sunnyiC("MESSAGE_INTEVAL")))
    	{
    		$data['title'] = $_REQUEST['title'];
    		$data['content'] = $_REQUEST['content'];
    		$data['pid'] = intval($_REQUEST['pid']);
    		$data['reply_type'] = $data['pid']==0?0:1;   		
    		$data['status'] = sunnyiC("MESSAGE_AUTO_CHECK");
    		$data['create_time'] = gmtTime();
    		$data['user_id'] = intval($_REQUEST['user_id']);
    		$data['user_name']	=	$_REQUEST['user_name'];
    		$data['user_email']	=  $_REQUEST['user_email'];
    		$data['rec_module'] = $_REQUEST['rec_module'];
    		$data['rec_id'] = intval($_REQUEST['rec_id']);
    		$data['score']	= intval($_REQUEST['score']);
    		$rs = D("Message")->add($data);
    		if($rs)
    		{
    			if($data['status'])
    			{
    				$this->success(L("MESSAGE_SUCCESS"));
    			}
    			else 
    			{
    				$this->success(L("WAIT_FOR_CHECK"));
    			}
    		}
    		else 
    		{
    			$this->error(L("MESSAGE_ERROR"));
    		}
    	}
    	else
    	{
    		$this->error(L("MESSAGE_TOO_QUICK"));
    	}
    }
    
    public function index()
    {
    		//初始化分页
	    	$page = intval($_REQUEST[C("VAR_PAGE")]);
	    	if($page==0)
	    	$page = 1;
	    	
	    	$result = D("Message")->getMessageList('Message',0,$page);
	    	$this->assign("message_list",$result['message_list']);
	    	//分页
			$page = new Page($result['message_total'],C("PAGE_LISTROWS"));   //初始化分页对象 		
			$p  =  $page->show();
	        $this->assign('pages',$p);
	        //end 分页  

	         $navs = array('name'=>L("MESSAGE_BOARD"),'url'=>U("Message/index"));
    		//输出当前页seo内容
	    	$data = array(
	    		'navs' => array(
	    			$navs,
	    		),
	    		'keyword'=>	"",
	    		'content'=>	"",
	    	);
	    	$this->assignSeo($data);  
	    	
	    	$this->display("Page:message_index");	
    }
}
?>