<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 积分商品
class ScoreGoodsAction extends SunnyiAction{
	public function index()
	{
		//输出显示方式
		$list_type = intval(Session::get("list_type"));
		$this->assign("list_type",$list_type);	
		
		//初始化分页
    	$page = intval($_REQUEST[C("VAR_PAGE")]);
    	if($page==0)
    	$page = 1;
    	$this->assign("page",$page);
    	
		//排序
    	$sort = '';
    	if($_REQUEST['sort_field'])
    	{
    		$sort = $_REQUEST['sort_field'];  
    		$this->assign("sort_field",$_REQUEST['sort_field']);
    	}
    	if($_REQUEST['sort_type'])
    	{
    		$sort.=" ".$_REQUEST['sort_type']; 	
    		$this->assign("sort_type",$_REQUEST['sort_type']);
    	}
    	
    	$this->assign("page_title",L("SCORE_GOODS"));
    	
    	//查询当前页商品数据
    	$goods_result = D("ScoreGoods")->searchGoodsList($page,$sort);
    	
    	//分页
		$page = new Page($goods_result['goods_total'],sunnyiC("GOODS_PAGE_LISTROWS"));   //初始化分页对象 		
		$p  =  $page->show();
        $this->assign('pages',$p);
        //end 分页  
    	
    	//输出分类下的商品列表
    	$this->assign("goods_list",$goods_result['goods_list']);
    	
		//输出当前页seo内容
		$navs = array('name'=>L("SCORE_GOODS"),'url'=>U("ScoreGoods/index"));
    	$data = array(
    		'navs' => array(
    			$navs,
    		),
    		
    		'keyword'=>	$cate_info['seokeyword_'.FANWE_LANG_ID]!=''?$cate_info['seokeyword_'.FANWE_LANG_ID]:$cate_info['name_'.FANWE_LANG_ID].",".$cate_info['seokeyword_'.FANWE_LANG_ID],
    		'content'=>	$cate_info['seocontent_'.FANWE_LANG_ID]!=''?$cate_info['seocontent_'.FANWE_LANG_ID]:$cate_info['name_'.FANWE_LANG_ID].",".$cate_info['seokeyword_'.FANWE_LANG_ID],
    	);
    	$this->assignSeo($data);    	
    	$this->display("Page:score_goods_index");
	}
	
	public function show()
	{
		$goods_id = intval($_REQUEST['id']);
  
    	if(intval($goods_id)!=0)
    	{
    		$goods_item  = D("ScoreGoods")->getGoodsItem($goods_id);
    		$spec_list = D("GoodsSpec")->getGoodsSpecList($goods_id);
    		//有规格清空商品相关数据
    		if($spec_list)
    		{
    			//$goods_item['sn'] = '';
    			$goods_item['weight_format'] = '';    			
    		}
    		$this->assign("goods_info",$goods_item);
    		
    		//输出当前商品的规格配置表
    		$this->assign("spec_list",$spec_list);
    		    		
    		$cate_navs = array('name'=>L("SCORE_GOODS"),'url'=>U("ScoreGoods/index"));
    		$goods_navs = array('name'=>$goods_item['name_'.FANWE_LANG_ID],'url'=>U("ScoreGoods/show",array('id'=>$score_goods_id)));
    		//输出当前页seo内容
	    	$data = array(
	    		'navs' => array(
	    			$cate_navs,
	    			$goods_navs,
	    		),
	    		'keyword'=> $goods_item['seokeyword_'.FANWE_LANG_ID]!=''?$goods_item['seokeyword_'.FANWE_LANG_ID]:$goods_item['name_'.FANWE_LANG_ID],
	    		'content'=>	$goods_item['seocontent_'.FANWE_LANG_ID]!=''?$goods_item['seocontent_'.FANWE_LANG_ID]:$goods_item['name_'.FANWE_LANG_ID],
	    	);
	    	$this->assignSeo($data);  

	    	//上一款/下一款
			$now = gmtTime();
	    	$sql = "select goods.id as goods_id from ".C("DB_PREFIX")."promote_child as promote_child ".
			   "left join ".C("DB_PREFIX")."promote as promote on promote_child.promote_id = promote.id ".
			   "left join ".C("DB_PREFIX")."goods as goods on goods.id = promote_child.rec_id ".
			   "where promote_child.module_name = 'Goods' ".
			   "and promote.promote_begin_time<=".$now." ".
			   "and promote.promote_end_time>=".$now." ".
			   "and promote.promote_type_id = 8 ".
			   "and promote.is_card = 0 ".
			   "and promote.status = 1 ".
			   "and goods.status = 1 ".
	    	   "and goods.id > ".$goods_id." ".
			   "order by goods.id asc ";
	    	$next_id = D()->query($sql);
			$next_id = $next_id[0]['goods_id'];
			
			$sql = "select goods.id as goods_id from ".C("DB_PREFIX")."promote_child as promote_child ".
			   "left join ".C("DB_PREFIX")."promote as promote on promote_child.promote_id = promote.id ".
			   "left join ".C("DB_PREFIX")."goods as goods on goods.id = promote_child.rec_id ".
			   "where promote_child.module_name = 'Goods' ".
			   "and promote.promote_begin_time<=".$now." ".
			   "and promote.promote_end_time>=".$now." ".
			   "and promote.promote_type_id = 8 ".
			   "and promote.is_card = 0 ".
			   "and promote.status = 1 ".
			   "and goods.status = 1 ".
	    	   "and goods.id < ".$goods_id." ".
			   "order by goods.id desc ";
	    	$prev_id = D()->query($sql);
			$prev_id = $prev_id[0]['goods_id'];
			

    		$this->assign("next_item",D("ScoreGoods")->getGoodsItem($next_id));
    		$this->assign("prev_item",D("ScoreGoods")->getGoodsItem($prev_id));
    	    
    		
    	}
    	else 
    	{
    		$this->error(L("NO_GOODS"));
    	}
    	
    	$this->display("Page:score_goods_show");
	}
	
	
	public function getSpecItem()
    {
 
    	$goods_id = intval($_REQUEST['goods_id']);
    	$str = urldecode($_REQUEST['str']);
    	$spec_conf = array();
    	if($str!='')
    	{
    		$str_arr = explode(",",$str);
    		foreach($str_arr as $str_item)
    		{
    			$str_item = explode("_",$str_item);
    			$spec_conf[$str_item[0]] = $str_item[1];
    		}
    	}
    	$spec_item_id = intval(D("GoodsSpecItem")->getSpecItemId($spec_conf,$goods_id));
    	
    	$num = intval($_REQUEST['num']);
    	$choose_msg = D("GoodsSpecItem")->makeChooseMsg($spec_conf,$goods_id);
    	$goods['choose_msg'] = $choose_msg;
    	$goods['status'] = true;
		if($spec_item_id!=0)
		{
			$goods_info = D("GoodsSpecItem")->getGoodsSpecItem($spec_item_id);
		}
   		if(!$goods_info)
		{ 
			$msg = D("GoodsSpecItem")->makeErrorMsg($spec_conf,$goods_id);
			
    		$goods['shop_price_format'] = $msg;
	    	$goods['market_price_format'] = $msg;
	    	$goods['promote_price_format'] = $msg;
	    	$goods['weight_format'] = $msg;
	    	$goods['stock'] = $msg;
    		$goods['member_price_format'] = $msg;

	   		$goods['total_price_format']  =$msg;
	   		$goods['sn'] = D("Goods")->where("id=".$goods_id)->getField('sn');
   			$goods['total_score_format'] = $msg;
   			$goods['spec_item_id'] = 0;
   			$goods['status'] = false;
			echo json_encode($goods);
			exit;
		}
   	
    	$goods['weight'] = $goods_info['weight'];
    	$goods['weight_format'] = formatWeight($goods_info['weight'],$goods_id);
    	
    	$now = gmtTime();
    	$sql = "select goods.*,promote_child.score as promote_score from ".C("DB_PREFIX")."promote_child as promote_child ".
			   "left join ".C("DB_PREFIX")."promote as promote on promote_child.promote_id = promote.id ".
			   "left join ".C("DB_PREFIX")."goods as goods on goods.id = promote_child.rec_id ".
			   "where promote_child.module_name = 'Goods' ".
			   "and promote.promote_begin_time<=".$now." ".
			   "and promote.promote_end_time>=".$now." ".
			   "and promote.promote_type_id = 8 ".
			   "and promote.is_card = 0 ".
			   "and promote.status = 1 ".
			   "and goods.status = 1 ".
			   "and goods.id = ".$goods_id;
		
		$goods_item = D()->query($sql);
		$goods_item = $goods_item[0];
		
    	
    	$unit_score = $goods_item['promote_score'];
    			
   		$goods['total_score'] = $unit_score*$num;
   		$goods['total_score_format'] = formatScore("-".($unit_score*$num));
   		$goods['sn'] = $goods_info['sn'];
   		$goods['stock'] = $goods_info['stock'];
		$goods['spec_item_id'] = $spec_item_id;
  		echo json_encode($goods);
    }
    
	
}
?>