<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

//会员冲值
class UcInchargeAction extends UserCenterAction {
	public function index()
	{
		//初始化分页
	    	$page = intval($_REQUEST[C("VAR_PAGE")]);
	    	if($page==0)
	    	$page = 1;
	    	
	    	$result = D("UserIncharge")->getInchargeList(intval($_SESSION['user_id']),$page);

	    	$this->assign("incharge_list",$result['list']);
	    	//分页
			$page = new Page($result['total'],sunnyiC("PAGE_LISTROWS"));   //初始化分页对象 		
			$p  =  $page->show();
	        $this->assign('pages',$p);
	        //end 分页  
	        
		//输出支付方式
	    	$payment_list = D("Payment")->where("status=1 and class_name<>'Accountpay' and class_name<>'Cod'")->findAll();  
	    	foreach($payment_list as $kk=>$vv)
	    	{
	    		$currency_item = M("Currency")->getById($vv['currency']);
	    		$payment_list[$kk]['currency_type'] = $currency_item['name_'.FANWE_LANG_ID];
	    		if($vv['fee_type']==0)
	    		$payment_list[$kk]['fee_format'] = $currency_item['unit']." ".getBaseMoney($vv['fee'],$vv['currency']);
	    		else
	    		$payment_list[$kk]['fee_format'] = floatval($vv['fee'])."%";
	    	}  	
	    	$this->assign("payment_list",$payment_list);	    	
			
	        $this->display("Page:user_center_frame");
	}
	
	public function insert()
	{
		if(sunnyiC("TOKEN_ON")&&!M()->autoCheckToken($_POST))
		{
			$this->error(L("TOKEN_ERROR"));
		} 
		if(!$_POST['payment'])
		{
			$this->error(L("SELECT_PAYMENT"));
		}
		if(intval($_REQUEST['money'])<=0)
		{
			$this->error(L("MONEY_ERROR"));
		}
		
		$_POST['money'] = toDbPrice($_POST['money']);
		$data['sn'] = date('ymdhis', gmtTime()).rand_string(2,0);
		$data['user_id'] = intval($_SESSION['user_id']);
		$data['money'] = floatval($_POST['money']);
		$data['create_time'] = gmtTime();
		$data['payment'] = $_POST['payment'];
		
		$payment_info = D("Payment")->getById(intval($data['payment']));  //支付方式
		if($payment_info['fee_type']==0)
		{
			//定额
			$data['payment_fee'] = $payment_info['fee'];
		}
		else
		{
			$data['payment_fee'] = $data['money'] * $payment_info['fee']/100;
		}
		
		$data['payment_money'] = $data['money'] + $data['payment_fee'];
		
		$id = D("UserIncharge")->add($data);
		if($id)
		{
			//生成支付按钮
	   		$payment_str = D("Payment")->getPayment($id,1);
	   		$this->assign("payment_str",$payment_str);	
	   		$this->assign("order_info",L("MONEY_SN")." [&nbsp;&nbsp;<span style='color:#f30; font-weight:bold;'>".$data['sn']."</span>&nbsp;&nbsp;]");		
	   		$this->display("Page:cart_done");
		}
		else 
		{
			$this->error(L("SUBMIT_ERROR"));
		}			
	}
	
	public function modify()
	{
		$id=intval($_REQUEST['id']);
		$incharge_info = D("UserIncharge")->where("status=0 and id=".$id)->find();
		if(!$incharge_info)
		{
			$this->error(L("SUBMIT_ERROR"));
		}
	        
		$currency_item = Session::get("sunnyi_currency");
		$incharge_info['money'] = $incharge_info['money']*$currency_item['radio'];
		
		$this->assign('incharge_info',$incharge_info);
		
		//输出支付方式
	    $payment_list = D("Payment")->where("status=1 and class_name<>'Accountpay' and class_name<>'Cod'")->findAll();  
	    foreach($payment_list as $kk=>$vv)
	    {
	    		$currency_item = M("Currency")->getById($vv['currency']);
	    		$payment_list[$kk]['currency_type'] = $currency_item['name_'.FANWE_LANG_ID];
	    		if($vv['fee_type']==0)
	    		$payment_list[$kk]['fee_format'] = $currency_item['unit']." ".getBaseMoney($vv['fee'],$vv['currency']);
	    		else
	    		$payment_list[$kk]['fee_format'] = floatval($vv['fee'])."%";
	    }  
 	
	    $this->assign("payment_list",$payment_list);
	    	
	    $this->display("Page:user_center_frame");
	}
	
	
	public function update()
	{
		if(sunnyiC("TOKEN_ON")&&!M()->autoCheckToken($_POST))
		{
			$this->error(L("TOKEN_ERROR"));
		} 
		if(!$_POST['payment'])
		{
			$this->error(L("SELECT_PAYMENT"));
		}
		if(intval($_REQUEST['money'])<=0)
		{
			$this->error(L("MONEY_ERROR"));
		}
		$_POST['money'] = toDbPrice($_POST['money']);
		
		$data['id'] = intval($_POST['id']);
		$data['money'] = floatval($_POST['money']);
		$data['payment'] = intval($_POST['payment']);
		
		$payment_info = D("Payment")->getById(intval($data['payment']));  //支付方式
		if($payment_info['fee_type']==0)
		{
			//定额
			$data['payment_fee'] = $payment_info['fee'];
		}
		else
		{
			$data['payment_fee'] = $data['money'] * $payment_info['fee']/100;
		}
		
		$data['payment_money'] = $data['money'] + $data['payment_fee'];
		
		$rs = D("UserIncharge")->save($data);
		$data = D("UserIncharge")->getById($data['id']);
			//生成支付按钮
	   		$payment_str = D("Payment")->getPayment($data['id'],1);
	   		$this->assign("payment_str",$payment_str);	
	   		$this->assign("order_info",L("MONEY_SN")." [&nbsp;&nbsp;<span style='color:#f30; font-weight:bold;'>".$data['sn']."</span>&nbsp;&nbsp;]");		
	   		$this->display("Page:cart_done");
		
	}
		
}
?>