<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 会员订单
class UcOrderAction extends UserCenterAction {

	public function index()
	{
		//初始化分页
    	$page = intval($_REQUEST[C("VAR_PAGE")]);
    	if($page==0)
    	$page = 1;
    	
		$res = D("Order")->getOrderList(intval($_SESSION['user_id']),$page);
		$this->assign('order_list',$res['list']);
		
		
    	//分页
		$page = new Page($res['total'],C("PAGE_LISTROWS"));   //初始化分页对象 		
		$p  =  $page->show();
        $this->assign('pages',$p);
        
        
		$this->display("Page:user_center_frame");
	}
	
//发货单
	public function consignment()
	{
		$order_id = intval($_REQUEST['id']);
		$order_info = D("Order")->getOrderItem($order_id,intval($_SESSION['user_id']));
		if($order_info)
		{
			$this->assign("order_info",$order_info);
			//初始化分页
	    	$page = intval($_REQUEST[C("VAR_PAGE")]);
	    	if($page==0)
	    	$page = 1;
	    	
	    	$limit = (($page-1)*C("PAGE_LISTROWS")).",".($page*C("PAGE_LISTROWS"));
			$consignment_list = M("OrderConsignment")->where("order_id=".$order_id)->order("create_time desc")->limit($limit)->findAll();
			$this->assign("consignment_list",$consignment_list);
			
			//分页
			$total =  M("OrderConsignment")->where("order_id=".$order_id)->count();
			$page = new Page($total,C("PAGE_LISTROWS"));   //初始化分页对象 		
			$p  =  $page->show();
	        $this->assign('pages',$p);
	        
			$this->display("Page:user_center_frame");
		}
		else
		{
			$this->error(L("NO_ORDER"));
		}
	}
	
	//退货单
	public function reconsignment()
	{
		$order_id = intval($_REQUEST['id']);
		$order_info = D("Order")->getOrderItem($order_id,intval($_SESSION['user_id']));
		if($order_info)
		{
			$this->assign("order_info",$order_info);
			//初始化分页
	    	$page = intval($_REQUEST[C("VAR_PAGE")]);
	    	if($page==0)
	    	$page = 1;
	    	
	    	$limit = (($page-1)*C("PAGE_LISTROWS")).",".($page*C("PAGE_LISTROWS"));
			$consignment_list = M("OrderReConsignment")->where("order_id=".$order_id)->order("create_time desc")->limit($limit)->findAll();
			$this->assign("consignment_list",$consignment_list);
			
			//分页
			$total =  M("OrderReConsignment")->where("order_id=".$order_id)->count();
			$page = new Page($total,C("PAGE_LISTROWS"));   //初始化分页对象 		
			$p  =  $page->show();
	        $this->assign('pages',$p);
	        
			$this->display("Page:user_center_frame");
		}
		else
		{
			$this->error(L("NO_ORDER"));
		}
	}
	public function payOrder()
	{
		$order_id = intval($_REQUEST['id']);		
		$order = D("Order")->getById($order_id);
		$money = floatval($_REQUEST['money']);
		$money = setBaseMoney($money,$_SESSION['sunnyi_currency']['id']);

		$order_info = D("Order")->getOrderItem($order_id,intval($_SESSION['user_id']));
		if($order_info['money_status'] == 2)
		{
			$this->error(L("ALL_PAID"));
		}
		elseif($order_info['total_price_less'] < $money)
		{
			$this->error(L("TOO_MANY_MONEY"));
		}
		elseif($money<=0)
		{
			$this->error(L("AMOUNT_ERROR"));
		}
		
			
		/* 如果全部使用余额支付，检查余额是否足够 */
		
		$user_id = intval($_SESSION['user_id']);	
		$payment = D("Payment")->getById($order_info['payment']['id']);	
    	if ($payment['class_name'] == 'Accountpay'){//会员使用预存款支付
    	  if ($user_id > 0){
    	     $user = M('User')->getById ($user_id);   
       
		  	 if (($user['money'] < 0) || ($money - $user['money'] > 0.01 )){
		  	 	$this->error(L('USER_MONEY_DEFICIT'));
		  	 }
    	  }else{
    	  	$this->error( L('INVALID_USER_ID'));
    	  }
		}
		
		$navs = array('name'=>L("PAY_NOW"),'url'=>U("Cart/done"));
	        //输出当前页seo内容
	    	$data = array(
	    		'navs' => array(
	    			$navs,
	    		),
	    		'keyword'=>	'',
	    		'content'=>	'',
	    	);
	   		$this->assignSeo($data);   
	   		//生成支付按钮
	   		$payment_str = D("Payment")->getPayment($order_id,0,$money);
	   		$this->assign("payment_str",$payment_str);	   		

			
			$this->assign("order_info",L("PAY_NOW")." [&nbsp;&nbsp;".L("ORDER_SN")."：<span style='color:#f30; font-weight:bold;'>".$order['sn']."</span>&nbsp;&nbsp;]");
			
	   		$this->display("Page:cart_done");
	}
	public function view()
	{
		$order_id = intval($_REQUEST['id']);
		$order_info = D("Order")->getOrderItem($order_id,intval($_SESSION['user_id']));
		
		if($order_info)
		{
			$this->assign("order_info",$order_info);
			
			$this->assign("order_goods_list",D("Order")->getGoodsList($order_info['id']));		
			
			$this->assign("module_name",'Order');
			
			//输出订单总价
			$total_price = ($order_info['total_price']+$delivery_fee+($payment_fee));
			$this->assign('total_price',$total_price);
			//输出订单留言
			//初始化分页
	    	$page = intval($_REQUEST[C("VAR_PAGE")]);
	    	if($page==0)
	    	$page = 1;
	    	
	    	$result = D("Message")->getMessageList('Order',$order_id,$page);
	    	$this->assign("message_list",$result['message_list']);
	    	//分页
			$page = new Page($result['message_total'],sunnyiC("ARTICLE_PAGE_LISTROWS"));   //初始化分页对象 		
			$p  =  $page->show();
	        $this->assign('pages',$p);
	        //end 分页  
	        
			$this->display("Page:user_center_frame");
		}
		else
		{
			$this->error(L("NO_ORDER"));
		}
	}
	
	public function del()
	{
		$order_id = intval($_REQUEST['id']);
		$order_info = D("Order")->getById($order_id);
		
		if($order_info['money_status'] > 0 || $order_info['goods_status'] > 0 || $order_info['status'] >0)
		{
			$this->error(L("ORDER_STATUS_CANT_DELETE"));  //非未确认订单不能删除
		}
		

		$msg_list = D("Message")->where("rec_module='Order' and rec_id=".$order_id)->findAll();
		foreach($msg_list as $item)
		{
			D("Message")->where("pid=".$item['id'])->delete();
		}
		D("Message")->where("rec_module='Order' and rec_id=".$order_id)->delete();

		
		D("OrderLog")->where("order_id=".$order_id)->delete();
		D("OrderPromote")->where("order_id=".$order_id)->delete();
		D("OrderGoods")->where("order_id=".$order_id)->delete();
		D("OrderGoods")->where("order_id=".$order_id)->delete();
		D("Order")->where("id=".$order_id)->delete();
		$this->success(L("DEL_SUCCESS"));
	}
	
	public function modifyPayment()
	{
		$order_id = intval($_REQUEST['id']);
		$order_info = D("Order")->getById($order_id);
		$this->assign('order_info',$order_info);
		
		//输出支付方式
    	$payment_list = D("Payment")->where("status=1")->findAll();  
    	foreach($payment_list as $kk=>$vv)
    	{
    		$currency_item = M("Currency")->getById($vv['currency']);
    		$payment_list[$kk]['currency_type'] = $currency_item['name_'.FANWE_LANG_ID];
    		
    		if($vv['fee_type']==0)
    		$payment_list[$kk]['fee_format'] = $currency_item['unit']." ".getBaseMoney($vv['fee'],$vv['currency']);
    		else 
    		$payment_list[$kk]['fee_format'] = floatval($vv['fee'])."%";

    	}  	
    	$this->assign("payment_list",$payment_list);
		
		$this->display("Page:user_center_frame");
	}
		
	public function doModifyPayment()
	{
		$order_id = intval($_REQUEST['order_id']);
		$payment = intval($_REQUEST['payment']);
		$result = $this->order_change_payment($order_id,$payment);
		
		if($result['status'])
		{
			$this->assign("jumpUrl",U("UcOrder/view",array('id'=>$order_id)));
			$this->success(L("MODIFY_SUCCESS"));
		}
		else
		{
			$this->error($result['info']);
		}
	}
	
	//更改支持方式
	private function order_change_payment($order_id, $payment_id){
			
		$result['status'] = false;
		$result['info'] = '';
	    if ($payment_id <= 0){
			$result['info'] = L("INVALID_PAYMENT_ID");
        	return $result;
    	}
    			
		$model = D ( "Order" );
		$vo = $model->getById ( $order_id );
		
		if (empty($vo) || $vo == false){
        	$result['info'] = L("INVALID_ORDER_ID");
        	return $result;
    	}
    	
		if($vo['money_status'] == 2)
		{
			$result['info'] = L("ALL_PAID");
        	return $result;
		}	

		if($vo['status'] == 1)
		{
			$result['info'] = L("ORDER_OVER");
        	return $result;
		}		
		
		if($vo['status'] == 2)
		{
			$result['info'] = L("ORDER_CANCEL");
        	return $result;
		}			
		
		$Payment = D ( "Payment" );
		$payment = $Payment->getById($payment_id);	
		
		//dump($payment_id);
		//新的支付方式
		$vo['payment'] = $payment_id;
		//新支付手续费
		if ($payment['fee_type'] == 0){//固定费用
			$payment_fee = $payment['fee'];
		}else{//比率  
			if ($vo['order_incharge'] > 0){
				$payment_fee = ($vo['order_total_price'] - $vo['order_incharge']) * $payment['fee'] / 100;
			}else{
				//新支付手续费 =（订单总额-旧支付手续费-已经支付的金额）* 手续费比率
				$payment_fee = ($vo['order_total_price'] - $vo['payment_fee']) * $payment['fee'] / 100;
			}
		}
		if ($payment_fee < 0){
			$payment_fee = 0;
		}
		
		if ($vo['order_incharge'] > 0){
			$vo['order_total_price'] = $vo['order_total_price'] + $payment_fee;
			$vo['payment_fee'] = $vo['payment_fee'] + $payment_fee;
		}else{
			//新的订单总金额 = 订单总金额 - 旧的支付手续费 + 新的支付手续费
			$vo['order_total_price'] = $vo['order_total_price'] - $vo['payment_fee'] + $payment_fee;
			$vo['payment_fee'] = $payment_fee;
		}

		
		/* 如果全部使用余额支付，检查余额是否足够 */
		
		$user_id = intval($vo['user_id']);		
    	if ($payment['class_name'] == 'Accountpay'){//会员使用预存款支付
    	  if ($user_id > 0){

    	  }else{
    	  	$result['info'] =  L('INVALID_USER_ID');
        	return $result;
    	  }
		}

		$model->save($vo);
		
		$result['status'] = true;
	    return $result;	    
	}
}
?>