<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 兑换优惠券
class UcPromoteCardAction extends UserCenterAction {
	public function index()
	{
		//初始化分页
    	$page = intval($_REQUEST[C("VAR_PAGE")]);
    	if($page==0)
    	$page = 1;
    	
    	$group_id = intval($_SESSION['group_id']);
    	
    	$limit = (($page-1)*C("PAGE_LISTROWS")).",".(C("PAGE_LISTROWS"));
    	
    	$promote_ids_res = M("PromoteUserGroup")->where("user_group_id=".$group_id)->field("promote_id")->findAll();
    	
    	$promote_ids = array();
    	foreach($promote_ids_res as $promote_ids_item)
    	{
    		array_push($promote_ids,$promote_ids_item['promote_id']);
    	}
    	
		$now = gmtTime();
		$condition['promote_begin_time'] = array('lt',$now);
		$condition['promote_end_time'] = array('gt',$now);
		$condition['is_card'] = 1;
		$condition['status'] = 1;
		$condition['id'] = array('in',$promote_ids);
		$card_list = M("Promote")->where($condition)->limit($limit)->findAll();
		$this->assign("card_list",$card_list);
		
		
		//分页
		$total = M("Promote")->where("promote_begin_time<".$now." and promote_end_time>".$now." and is_card = 1")->count();
		$page = new Page($total,C("PAGE_LISTROWS"));   //初始化分页对象 		
		$p  =  $page->show();
        $this->assign('pages',$p);
        
		$this->display("Page:user_center_frame");
	}
	
	//兑换优惠券
	public function exchange()
	{
		$user_id = intval($_SESSION['user_id']);
		$card_id = intval($_REQUEST['card_id']);
		
		$curr_id = intval(M("PromoteCard")->max("id"))+1;
		$card_sn = buildCard($curr_id);

		$promote_item = M("Promote")->getById($card_id);
		
		if($promote_item['card_score']>M("User")->where("id=".$user_id)->getField("score"))
		{
			$res['status'] = 0;
			$res['info'] = L("NOT_ENOUGH_SCORE");
			echo json_encode($res);
			exit;
		}
		else 
		{
			$promote_card_item = array();
			$promote_card_item['promote_id'] = $promote_item['id'];
			$promote_card_item['card_code'] = $card_sn;
			$promote_card_item['card_limit'] = $promote_item['card_limit'];
			
			$card_id = M("PromoteCard")->add($promote_card_item);
			
			$promote_user_card_item = array();
			$promote_user_card_item['user_id'] = $user_id;
			$promote_user_card_item['card_id'] = $card_id;
			
			$promote_user_card_id = M("PromoteUserCard")->add($promote_user_card_item);
			
			if($promote_user_card_id&&$card_id)
			{
				user_score_log($user_id,$card_id,'PromoteCard',"-".$promote_item['card_score'],"#EXCHANGE_CARD_USE_SCORE#");
				$res['status'] = 1;
				$res['info'] = sprintf(L("EXCHANGE_SUCCESS"),$card_sn);
				echo json_encode($res);
				exit;
			}
			else
			{
				$res['status'] = 0;
				$res['info'] = '';
				echo json_encode($res);
				exit;
			}
		}
		
		
	}
	
}
?>