<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 会员
class UserAction extends SunnyiAction{
	//会员注册
	public function register()
	{
		if(sunnyiC("SHOP_REG_CLOSED")==0)
		{
		//输出当前页seo内容
    	$data = array(
    		'navs' => array(
    			array('name'=>L('USER_REGISTER'),'url'=>U("User/register"))
    		),
    		'keyword'=>	'',
    		'content'=>	'',
    	);
    	$this->assignSeo($data);
    	$this->assign("content_page",'Inc:user:register');
		$this->display("Page:user_frame");
		}
		else
		{
			$this->error(L("SHOP_REG_CLOSED"));
		}
	}
	public function doRegister()
	{
		if(sunnyiC("TOKEN_ON")&&!M()->autoCheckToken($_POST))
		{
			$this->error(L("TOKEN_ERROR"));
		}
 		$cfm_password = trim($_POST['user_pwd_confirm']);
    	$data['user_name'] = trim($_POST['user_name']);
    	$data['user_pwd'] = trim($_POST['user_pwd']);
    	$data['sex'] = trim($_POST['sex']);
    	$data['email'] = trim($_POST['email']);
		$data['fix_phone'] = trim($_POST['fix_phone']);
		$data['fax_phone'] = trim($_POST['fax_phone']);
		$data['mobile_phone'] = trim($_POST['mobile_phone']);
		$data['zip'] = trim($_POST['zip']);
		$data['address'] = trim($_POST['address']);
		$data['qq'] =  trim($_POST['qq']);
		$data['msn'] = trim($_POST['msn']);
		$data['alim'] = trim($_POST['alim']);
		$data['pwd_question'] = trim($_POST['pwd_question']);
		$data['pwd_answer'] = trim($_POST['pwd_answer']);
		
		
		//开始相关验证
		if($data['email']=='')
		{
			$this->error(L("EMAIL_EMPTY"));
		}
   		if(strlen($data['user_name'])<6)
		{
			$this->error(L("USER_TOO_SHORT"));
		}
		if(D("User")->where("user_name='".$data['user_name']."'")->count()>0)
		{
			$this->error(L("USER_NAME_EXIST"));
		}
		if(!preg_match("/\w+@\w+\.\w{2,3}\b/",$data['email']))
	   	{
	   			$this->error(L("EMAIL_FORMAT_ERROR"));
	   	}
    	if(D("User")->where("email='".$data['email']."'")->count()>0)
		{
			$this->error(L("EMAIL_EXIST"));
		}
   		if(strlen($data['user_pwd'])<6)
		{
			$this->error(L("PWD_TOO_SHORT"));
		}
		if($data['user_pwd']!=$cfm_password)
		{
			$this->error(L("PWD_CONFIRM_FAILED"));
		}
		$data['user_pwd'] = md5($data['user_pwd']);
		
		$data['score'] = sunnyiC("DEFAULT_SCORE");
    	$data['status'] = sunnyiC('USER_AUTO_REG');
    	$data['create_time']	=	gmtTime();
    	$data['update_time']	=	gmtTime();
    	$data['group_id'] = sunnyiC("DEFAULT_USER_GROUP");
    	$rs = D("User")->add($data);
    	if($rs>0)
    	{
    		$score = intval($data['score']);
			$money = floatval($data['money']);
			if($money>0)
			user_money_log($rs,$rs,'User',$money,'#USER_ADD_USER#',true);
			user_score_log($rs,$rs,'User',$score,'#USER_ADD_USER#',true);    		
    		if($data['status'])
    		{
    			//开始自动登录
    			$userinfo = D("User")->getById($rs);		
				if($userinfo['status'])
				{
					$userinfo['last_ip'] = get_client_ip();
					Session::set("user_name",$userinfo['user_name']);
					Session::set("user_id",$userinfo['id']);
					Session::set("group_id",$userinfo['group_id']);
					Session::set("user_email",$userinfo['email']);
					D("User")->save($userinfo);
				}	
    			$this->success(L("REG_SUCCESS")); 
    		}
    		else 
    		$this->success(L("REG_SUCCESS_WAIT"));
    		
    	}
    	else
    		$this->error(L("REG_FAILED")); 
	}
	
	
	//会员登录
	public function login()
	{				
		
		//输出当前页seo内容
    	$data = array(
    		'navs' => array(
    			array('name'=>L('USER_LOGIN'),'url'=>U("User/login"))
    		),
    		'keyword'=>	'',
    		'content'=>	'',
    	);
    	$this->assignSeo($data);
    	$this->assign("content_page",'Inc:user:login');
		$this->display("Page:user_frame");
		
	}
	public function doLogin()
	{
		
		if(sunnyiC("TOKEN_ON")&&!M()->autoCheckToken($_POST))
		{
			$this->error(L("TOKEN_ERROR"));
		}
		if(sunnyiC("VERIFY_ON")==1)
		{
			if($_SESSION['verify'] != md5($_POST['verify'])) {
				$this->error(L('VERIFY_ERROR'));
			}
		}
    	$data['user_name'] = trim($_POST['user_name']);
    	$data['user_pwd'] = trim($_POST['user_pwd']);
    	
		
		
		if(strlen($data['user_name'])=='')
		{
			$this->error(L("USER_NAME_EMPTY"));
		}
		if(strlen($data['user_pwd'])=='')
		{
			$this->error(L("USER_PWD_EMPTY"));
		}
		
		$data['user_pwd'] = md5($data['user_pwd']);
		
		if($userinfo = D("User")->where($data)->find())
		{
			if($userinfo['status'])
			{
				$userinfo['last_ip'] = get_client_ip();
				Session::set("user_name",$userinfo['user_name']);
				Session::set("user_id",$userinfo['id']);
				Session::set("group_id",$userinfo['group_id']);
				Session::set("user_email",$userinfo['email']);
				D("User")->save($userinfo);
				$this->assign("jumpUrl",U("Index/index"));
				$this->success(L("LOGIN_SUCCESS"));
			}
			else 
			{
				$this->error(L("USER_STATUS_FALSE"));
			}
		}
		else 
		{
			$this->error(L("LOGIN_FAILED"));
		}
    	
	}
	
	public function logout()
	{
		unset($_SESSION['user_name']);
		unset($_SESSION['user_id']);
		unset($_SESSION['group_id']);
		unset($_SESSION['user_email']);
		$this->assign("jumpUrl",U("Index/index"));
		$this->success(L("LOGOUT_SUCCESS"));
	}
 	/**
     * 用于ajax的字段验证
     *
     */
    public function checkField()
    {
    	$field_name = trim($_REQUEST['fieldName']);
    	$field_value = trim($_REQUEST['value']);    	

    	switch($field_name)
    	{
    		case "user_name": //用户名    			
    			$count = D("User")->where("user_name='".$field_value."'")->count();
    			if($count>0)
    			{
    				$msg['state'] = false;
    				$msg['msg'] = L("USER_NAME_EXIST");
    			}
    			else 
    			{
    				$msg['state'] = true;
    			}
    			break;
    		case "email": //邮件
    			$count = D("User")->where("email='".$field_value."'")->count();
    			if($count>0)
    			{
    				$msg['state'] = false;
    				$msg['msg'] = L("EMAIL_EXIST");
    			}
    			else 
    			{
    				$msg['state'] = true;
    			}
    			break;
    	}    	    	    	    	
    	echo json_encode($msg);
    }
    
    
    //取回密码
    private function reMakePassword($user_name='')
    {
    	$rand_pwd = rand_string(16,5);
    	$encode_pwd = md5($rand_pwd);
    	$rs = D("User")->where("user_name='".$user_name."' and status = 1")->setField('user_pwd',$encode_pwd);
    	if($rs)
    		return $rand_pwd;
    	else
    		return false;
    }
    public function getPassword()
    {
    	//输出当前页seo内容
    	$data = array(
    		'navs' => array(
    			array('name'=>L('GET_PASSWORD'),'url'=>U("User/getPassword"))
    		),
    		'keyword'=>	'',
    		'content'=>	'',
    	);
    	$this->assignSeo($data);
    	$this->assign("content_page",'Inc:user:get_password');
		$this->display("Page:user_frame");
    }
    public function doGetPassword()
    {
    	if(sunnyiC("TOKEN_ON")&&!M()->autoCheckToken($_POST))
		{
			$this->error(L("TOKEN_ERROR"));
		}
		$user_name = trim($_POST['user_name']);
		$user_info = D("User")->where("user_name='".$user_name."' and status=1")->find();
		if(!$user_info)
		{
			$this->error(L("USERNAME_NOT_EXIST"));
		}
		if($user_info['pwd_question']==''||$user_info['pwd_answer']=='')
		{
			$this->error(L("CANT_GET_PASSWORD"));
		}
		if(trim($_POST['pwd_answer'])!=$user_info['pwd_answer'])
		{
			$this->error(L("PWD_ANSWER_ERROR"));
		}
		
		$rand_pwd = $this->reMakePassword($user_name);
		if($rand_pwd)
		{
			if(sunnyiC("GET_PASSWORD")==1)
				$rs = D("MailTemplate")->sendPasswordMail($user_info['id'],$rand_pwd);
			if($rs)
			{
				$this->assign("waitSecond",10);
				$this->success($rs);
			}
			else 
			{
				$this->assign("waitSecond",30);
				$this->success(L("PLEASE_REMEBER_NEW_PWD")."：".$rand_pwd);
			}
		}		
    }
    public function getPwdQuestion()
    {
    	$username = trim($_REQUEST['username']);
    	if($username=='')
    	{
    		echo L("USERNAME_EMPTY");
    		exit;
    	}
    	$userinfo = D("User")->where("user_name='".$username."' and status=1")->find();
    	if($userinfo)
    	{
    		if($userinfo['pwd_question']!=''&&$userinfo['pwd_answer']!='')
    		{
    			echo $userinfo['pwd_question'];
    		}
    		else 
    		{
    			echo L("CANT_GET_PASSWORD");
    		}
    		
    	}
    	else 
    	{
    		echo L("USERNAME_NOT_EXIST");
    	}
    }
}
?>