<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 会员中心
class UserCenterAction extends SunnyiAction{
	public function __construct()
	{
		parent::__construct();
		$this->checkLogin();
		
		$module_name = MODULE_NAME;
		$action_name = $_REQUEST[C("VAR_ACTION")];
		
		//输出会员菜单
		$user_menu = array(
			array('name'=>L("USERCENTER_INDEX"), 'url'=>U("UserCenter/index"),'module'=>'UserCenter'),
			array('name'=>L("UCMODIFY_INDEX"), 'url'=>U("UcModify/index"),'module'=>'UcModify'),
			array('name'=>L("UCPASSWORD_INDEX"), 'url'=>U("UcPassword/index"),'module'=>'UcPassword'),
			array('name'=>L("UCCONSIGNEE_INDEX"), 'url'=>U("UcConsignee/index"),'module'=>'UcConsignee'),
			array('name'=>L("UCORDER_INDEX"), 'url'=>U("UcOrder/index"),'module'=>'UcOrder'),
			array('name'=>L("UCCARDLIST_INDEX"), 'url'=>U("UcCardList/index"),'module'=>'UcCardList'),
			array('name'=>L("UCPROMOTECARD_INDEX"), 'url'=>U("UcPromoteCard/index"),'module'=>'UcPromoteCard'),
			array('name'=>L("UCLOG_INDEX"), 'url'=>U("UcLog/index"),'module'=>'UcLog'),
			array('name'=>L("UCINCHARGE_INDEX"), 'url'=>U("UcIncharge/index"),'module'=>'UcIncharge'),
			array('name'=>L("UCUNCHARGE_INDEX"), 'url'=>U("UcUncharge/index"),'module'=>'UcUncharge'),
			array('name'=>L("UCMESSAGE_INDEX"), 'url'=>U("UcMessage/index"),'module'=>'UcMessage'),
			array('name'=>L("USER_LOGOUT"), 'url'=>U("User/logout"),'module'=>'User'),
		);
		
		foreach($user_menu as $k=>$v)
		{
			$current_module = $v['module'];
			if(strtolower($current_module)==strtolower($module_name))
			{
				$user_menu[$k]['act'] = 1;
			}
		}
		$this->assign("user_menu",$user_menu);
		
		//输出当前页seo内容
		$rec_id = intval($_REQUEST['id']);
		if($rec_id>0)
		$url_array = array('id'=>$rec_id);
		
		$navs = array('name'=>L(strtoupper($module_name."_".$action_name)),'url'=>U($module_name."/".$action_name,$url_array));

    	$data = array(
    		'navs' => array(
    			$navs,
    		),
    		'keyword'=>	'',
    		'content'=>	'',
    	);
    	$this->assignSeo($data);  
    	
    	//输出当前页标题
    	$this->assign("page_title",L(strtoupper($module_name."_".$action_name)));
    	
    	//输出会员中心的内容页
    	$this->assign("uc_page","Inc:user_center:".strtolower($module_name)."_".strtolower($action_name)); 
	}
	
	//用于验证登录
	protected function checkLogin()
	{
		$is_ajax = intval($_REQUEST['is_ajax']);
		if(intval($_SESSION['user_id'])==0)
		{
			$this->error(L("PLEASE_LOGIN"),$is_ajax);
		}
	}
	
	//会员中心首页
	public function index()
	{
		//输出会员信息及上次登录状态
		$user_info = D("User")->where("id=".intval($_SESSION['user_id']))->field("id,email,money,score,user_name,nickname,create_time,update_time,last_ip,group_id")->find();
		$user_info['create_time_format'] = toDate($user_info['create_time']);
		$user_info['update_time_format'] = toDate($user_info['update_time']);
		$user_group = D("UserGroup")->where('id='.$user_info['group_id'])->find();
		$user_group['discount'] = floatval($user_group['discount']);
		$this->assign("user_info",$user_info);
		$this->assign("user_group",$user_group);
		$this->assign("user_score",$user_info['score']." ".L("SCORE_UNIT"));
		
		if(D("MailAddressList")->where("mail_address='".$user_info['email']."'")->count()>0)
		{
			$this->assign("mail_exist",1);
		}
		else 
		{
			$this->assign("mail_exist",0);
		}
		$this->display("Page:user_center_frame");
	}
	
	//订阅
	public function subScribe()
	{
		$id = intval($_REQUEST['id']);
		$user_info = D("User")->where("id=".$id)->field("id,email")->find();
		$data['mail_address'] = $user_info['email'];
		$data['status'] = 1;
		$data['user_id'] = $user_info['id'];
		if(D("MailAddressList")->add($data))
		{
			$this->success(L("SUBSCRIBE_SUCCESS"));
		}
		else
		{
			$this->success(L("SUBSCRIBE_FAILED"));
		}		
	}
	
	//退订
	public function unSubScribe()
	{
		$id = intval($_REQUEST['id']);
		$user_info = D("User")->where("id=".$id)->field("id,email")->find();

		if(D("MailAddressList")->where("mail_address='".$user_info['email']."'")->delete())
		{
			$this->success(L("SUBSCRIBEBACK_SUCCESS"));
		}
		else
		{
			$this->success(L("SUBSCRIBEBACK_FAILED"));
		}		
	}
}
?>