<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

//文章分类
class ArticleCateModel extends MultiLangModel  {
	/**
	 * 查询文章分类列表，返回文章分类列表集合，包含url
	 */
	public function getArticleCateList($condition='',$order='sort desc')
	{
		$curr_lang_id = D("LangConf")->where("lang_name ='".FANWE_LANG_SET."'")->getField('id');		
		$list = $this->where($condition)->order($order)->findAll();

		foreach($list as $k=>$v)
		{
			if(sunnyiC("URL_ROUTE")==1)
			$list[$k]['url'] = U("articlecate/".$v['id']);
			elseif(sunnyiC("URL_ROUTE")==2)
			{
				$arr = explode(" ",$v['name_'.FANWE_LANG_ID]);
				$url = '';
				$py = new Pinyin();
				foreach($arr as $idx => $ar)
				{
					$ar = $py->complie($ar);
					$prefix = "";
					$prefix = preg_replace("/\d/","",$ar);
					$prefix = preg_replace("/[^a-zA-Z-]/","",$prefix);
					$url.=$prefix.C("URL_PATHINFO_DEPR");
				}
				$url=strtolower($url);
				$list[$k]['url'] = 'x'.C("URL_PATHINFO_DEPR").$url.$v['id'].C("URL_HTML_SUFFIX"); 
			}
			else
			$list[$k]['url'] = U("Article/index",array('id'=>$v['id']));			
			$list[$k]['short'] = msubstr($v['name_'.$curr_lang_id],0,sunnyiC("ARTICLE_SHORT_NAME"));
		}
		return $list;
	}
	
	/**
	 * 获取单个文章分类
	 */
	public function getArticleCateItem($condition='')
	{
		$curr_lang_id = D("LangConf")->where("lang_name ='".FANWE_LANG_SET."'")->getField('id');		
		$item = $this->where($condition)->find();
		if($item)
		{
			if(sunnyiC("URL_ROUTE")==1)
			$item['url'] = U("articlecate/".$item['id']);
			elseif(sunnyiC("URL_ROUTE")==2)
			{
				$arr = explode(" ",$item['name_'.FANWE_LANG_ID]);
				$url = '';
				$py=new Pinyin();
				foreach($arr as $idx => $ar)
				{
					$ar = $py->complie($ar);
					$prefix = "";
					$prefix = preg_replace("/\d/","",$ar);
					$prefix = preg_replace("/[^a-zA-Z-]/","",$prefix);
					$url.=$prefix.C("URL_PATHINFO_DEPR");
				}
				$url=strtolower($url);
				$item['url'] = 'x'.C("URL_PATHINFO_DEPR").$url.$item['id'].C("URL_HTML_SUFFIX"); 
			}
			else
			$item['url'] = U("Article/index",array('id'=>$item['id']));			
			$item['short'] = msubstr($item['name_'.$curr_lang_id],0,sunnyiC("ARTICLE_SHORT_NAME"));
		}
		return $item;
	}
	
	/**
	 * 查询指定类型的文章
	 */
	public function getTypeArticleList($type=0,$limit=10)
	{
		$condition['status'] = 1;
		$condition['type'] = $type;
		return $this->getArticleList($condition,$limit,'sort desc,update_time desc');
	}
}
?>