<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

//文章
class ArticleModel extends MultiLangModel  {
	/**
	 * 查询文章列表，返回文件列表集合，包含url
	 */
	public function getArticleList($condition='',$limit=10,$order='sort desc')
	{
		$curr_lang_id = D("LangConf")->where("lang_name ='".FANWE_LANG_SET."'")->getField('id');		
		$list = $this->where($condition)->order($order)->limit($limit)->findAll();
		
		foreach($list as $k=>$v)
		{
			if(sunnyiC("URL_ROUTE")==1)
			$list[$k]['url'] = U("article/".$v['id']);
			elseif(sunnyiC("URL_ROUTE")==2)
			{
				$arr = explode(" ",$v['name_'.FANWE_LANG_ID]);
				$url = '';
				$py = new Pinyin();
				foreach($arr as $idx => $ar)
				{
					$ar = $py->complie($ar);
					$prefix = "";
					$prefix = preg_replace("/\d/","",$ar);
					$prefix = preg_replace("/[^a-zA-Z-]/","",$prefix);
					$url.=$prefix.C("URL_PATHINFO_DEPR");
				}
				$url=strtolower($url);
				$list[$k]['url'] = 'w'.C("URL_PATHINFO_DEPR").$url.$v['id'].C("URL_HTML_SUFFIX"); 
			}
			else
			$list[$k]['url'] = U("Article/show",array('id'=>$v['id']));			
			$list[$k]['short'] = msubstr($v['name_'.$curr_lang_id],0,sunnyiC("ARTICLE_SHORT_NAME"));
			$list[$k]['author'] = $v['author']==''?L("FANWE"):$v['author'];
			$list[$k]['update_time_format']  = toDate($v['update_time']);
			$list[$k]['create_time_format']  = toDate($v['create_time']);
			
			//开始输出商品积分			
			$list[$k]['score'] = number_format(D("Message")->where("status=1 and rec_module='Article' and rec_id=".$v['id'])->avg("score"),1);
		}		
		return $list;
	}
	
	/**
	 * 获取单篇文章
	 */
	public function getArticleItem($condition='')
	{
		$curr_lang_id = D("LangConf")->where("lang_name ='".FANWE_LANG_SET."'")->getField('id');		
		$item = $this->where($condition)->find();
		if($item)
		{
			if(sunnyiC("URL_ROUTE")==1)
			$item['url'] = U("article/".$item['id']);
			elseif(sunnyiC("URL_ROUTE")==2)
			{
				$arr = explode(" ",$item['name_'.FANWE_LANG_ID]);
				$url = '';
				$py = new Pinyin();
				foreach($arr as $idx => $ar)
				{
					$ar = $py->complie($ar);
					$prefix = "";
					$prefix = preg_replace("/\d/","",$ar);
					$prefix = preg_replace("/[^a-zA-Z-]/","",$prefix);
					$url.=$prefix.C("URL_PATHINFO_DEPR");
				}
				$url=strtolower($url);
				$item['url'] = 'w'.C("URL_PATHINFO_DEPR").$url.$item['id'].C("URL_HTML_SUFFIX"); 
			}
			else
			$item['url'] = U("Article/show",array('id'=>$item['id']));			
			$item['short'] = msubstr($item['name_'.$curr_lang_id],0,sunnyiC("ARTICLE_SHORT_NAME"));
			$item['update_time_format']  = toDate($item['update_time']);
			$item['create_time_format']  = toDate($item['create_time']);
			$item['author'] = $v['author']==''?L("FANWE"):$item['author'];
			//开始输出商品积分			
			$item['score'] = number_format(D("Message")->where("status=1 and rec_module='Article' and rec_id=".$item['id'])->avg("score"),1);
			$item['review'] = D("Message")->where("status=1 and rec_module='Article' and rec_id=".$item['id'])->count();
		}
		return $item;
	}
	
	/**
	 * 查询指定类型的文章
	 */
	public function getTypeArticleList($type=0,$limit=10)
	{
		$condition['status'] = 1;
		$condition['type'] = $type;
		return $this->getArticleList($condition,$limit,'sort desc,update_time desc');
	}
	
	/**
	 * 用于搜索文章列表的通用方法
	 *
	 * @param integer $cate_id 			分类ID
	 * @param integer $type            	类型
	 * @param string $keywords			关键词
	 * @param int $page					当前页
	 * @param string $sort				排序
	 */
	public function searchArticleList($cate_id=0, $type=0, $keywords='', $page=1, $sort='sort desc')
	{
		$condition['status'] = 1;
		//分类条件
		if($cate_id>0)
		{
			$childIds = D("ArticleCate")->getChildIds($cate_id);
			$childIds[] = $cate_id;
			$condition['cate_id'] = array('in',$childIds);
		}
		//类型条件
		$condition['type'] = $type;

		
		
		$lang_env_id = FANWE_LANG_ID;
		//关键词
		if($keywords!='')
		{
			$keywords = urldecode($keywords);
			$keywords_arr = explode(" ",$keywords);
			$condition_or['name_'.$lang_env_id] = array();
			$condition_or['content_'.$lang_env_id] = array();
			
			foreach($keywords_arr as $keyword_item)
			{
				array_push($condition_or['name_'.$lang_env_id],array('like',"%".$keyword_item."%"));
				array_push($condition_or['content_'.$lang_env_id],array('like',"%".$keyword_item."%"));
				
			}
				array_push($condition_or['name_'.$lang_env_id],'or');
				array_push($condition_or['content_'.$lang_env_id],'or');
				
				$condition_or['_logic'] = 'or';
				$condition['_complex'] = $condition_or;
		}
		
		//开始处理分页
		$page_size = $page;
		$page_count = sunnyiC("ARTICLE_PAGE_LISTROWS");
		$limit = ($page_size-1)*$page_count.",".$page_count;
		
		if($sort=='')
		{
			$sort = 'sort desc';
		}
		
		$result['article_list'] = $this->getArticleList($condition,$limit,$sort);
		
		$result['article_total']	= $this->where($condition)->count();
		return $result;
	}
}
?>