<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

//商品属性
class GoodsAttrModel extends MultiLangModel  {
	/**
	 * 获取指定商品ID的属性集合
	 * 返回集合结构
	 * array(
	 * 		attr_id => array(
	 * 		'attr_info'=>attr_info,
	 * 		'attr_value'=>value_list = array('value'..., 'url'.....)
	 * 		)
	 * )
	 *
	 * @param array $condition
	 * @return array
	 */
	public function getGoodsAttrList($condition='')
	{
		$list = $this->where($condition)->findAll();
		$result = array();
		if($list)
		{
			foreach($list as $k=>$v)
			{
				$vv = $v['attr_value_'.FANWE_LANG_ID];		
				$attr_type = D("GoodsTypeAttr")->where("id=".$v['attr_id'])->getField("type");	
				
				$value_item['value'] = $vv;
				$value_item['url'] = U("Goods/pick",array('attr_id'=>$v['attr_id'],'attr_value'=>urlencode($vv)));
				$v['value_list'][] = $value_item;
				
				$result[$v['attr_id']]['attr_value'][] = $v;
			}
			foreach($result as $k=>$v)
			{
				$result[$k]['attr_info'] = D("GoodsTypeAttr")->getById($k);
			}
		}
		return $result;
	}
}
?>