<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 商品规格款号
class GoodsSpecItemModel extends MultiLangModel implements CartItemInterface  {
	/**
	 * 获取指定规格款号的数据，包括相关的商品数据
	 *
	 * @param integer $id  //规格款号ID
	 * @return array
	 */	
	public function getGoodsSpecItem($id)
	{
		$spec_info = $this->getById($id);
		$goods_info = D("Goods")->getGoodsItem("id=".$spec_info['goods_id']);
		if($spec_info)
		{
			//组合规格信息至商品信息中
			$goods_info['sn'] = $spec_info['sn'];
			$goods_info['stock'] = $spec_info['stock'];
			$goods_info['shop_price'] = $spec_info['shop_price'];
			$goods_info['weight'] = $spec_info['weight'];
			
			//开始处理会员价
			if($_SESSION['user_id']&&$_SESSION['user_id']>0)
			{
				$user_group = D("UserGroup")->where("id=".$_SESSION['group_id'])->find();				
				$user_discount = floatval($user_group['discount'])==0?1:floatval($user_group['discount']);
				$define_price = floatval(D("UserGroupPrice")->where("goods_id=".$spec_info['goods_id']." and user_group_id=".$user_group['id']." and spec_item_id=".$id)->getField("user_price"));
				if($define_price>0)
				{
					$goods_info['member_price']	=	$define_price;
					$goods_info['member_price_format']	=	formatPrice($define_price);
				}
				else 
				{
					$goods_info['member_price']	=	$goods_info['shop_price']*$user_discount;
					$goods_info['member_price_format']	=	formatPrice($goods_info['member_price']);
				}
			}
			
			$spec_info['spec_conf'] = unserialize($spec_info['spec_conf']);
			foreach($spec_info['spec_conf'] as $k=>$v)
			{
				$spec_info['spec_conf'][$k] = D("GoodsSpec")->getById($v);
			}
			
			$goods_info['spec_conf'] = $spec_info['spec_conf'];
		}
		return $goods_info;
	}

	
	//用于购物车提取的方法
	public function getCartItem($id)
	{
		$spec_info = $this->getById($id);
		$goods_info = D("Goods")->getGoodsItem("id=".$spec_info['goods_id']);
		//组合规格信息至商品信息中
		$goods_info['sn'] = $spec_info['sn'];
		$goods_info['stock'] = $spec_info['stock'];
		$goods_info['shop_price'] = $spec_info['shop_price'];
		$goods_info['weight'] = $spec_info['weight'];
		$goods_info['id'] = $spec_info['id'];
		$goods_info['goods_id'] = $spec_info['goods_id'];
		//开始处理会员价
		if($_SESSION['user_id']&&$_SESSION['user_id']>0)
		{
			$user_group = D("UserGroup")->where("id=".$_SESSION['group_id'])->find();				
			$user_discount = floatval($user_group['discount'])==0?1:floatval($user_group['discount']);
			$define_price = floatval(D("UserGroupPrice")->where("goods_id=".$spec_info['goods_id']." and user_group_id=".$user_group['id']." and spec_item_id=".$id)->getField("user_price"));
			if($define_price>0)
			{
				$goods_info['member_price']	=	$define_price;
				$goods_info['member_price_format']	=	formatPrice($define_price);
			}
			else 
			{
				$goods_info['member_price']	=	$goods_info['shop_price']*$user_discount;
				$goods_info['member_price_format']	=	formatPrice($goods_info['member_price']);
			}
		}
		
		$now = gmtTime();
		if($goods_info['promote_begin_time']<$now&&$goods_info['promote_end_time']>$now)
    	$goods_info['data_unit_price'] = $goods_info['promote_price'];
    	elseif(intval($_SESSION['user_id'])>0)
    	$goods_info['data_unit_price'] = $goods_info['member_price'];
    	else 
    	$goods_info['data_unit_price'] = $goods_info['shop_price'];
    				
    	$goods_info['name'] = $goods_info['name_'.FANWE_LANG_ID];
    	$goods_info['data_weight'] = $goods_info['weight'];
	   					
		$spec_conf_str = '';
		if($spec_info['spec1_id']!=0)
		$spec_conf_str.=D("GoodsSpec")->where("id=".$spec_info['spec1_id'])->getField("spec_name_".FANWE_LANG_ID).",";
						
		if($spec_info['spec2_id']!=0)
		$spec_conf_str.=D("GoodsSpec")->where("id=".$spec_info['spec2_id'])->getField("spec_name_".FANWE_LANG_ID).",";

		if($spec_conf_str!='')
		$spec_conf_str = substr($spec_conf_str,0,-1);
		
		if($spec_conf_str != '')
		{
			$goods_info['name'].="(".$spec_conf_str.")";
			
		}		

		return $goods_info;
	}
	
	/**
	 * 查询组合的规格款号ID
	 *
	 * @param array $spec_conf  //规格的组合ID
	 * @param integer $goods_id	//商品ID
	 */
	public function getSpecItemId($spec_conf,$goods_id)
	{
		$condition = array();
		$idx = 1;
		foreach($spec_conf as $k=>$spec_item)
		{
			$condition['spec'.$idx.'_type_id'] = $k;
			$condition['spec'.$idx.'_id'] = $spec_item;
			$idx++;
		}
		$condition['goods_id'] = $goods_id;
		$spec_item_id = $this->where($condition)->getField("id");	
		if(!$spec_item_id)
		{
			$condition = array();
			$idx = 2;
			foreach($spec_conf as $k=>$spec_item)
			{
				$condition['spec'.$idx.'_type_id'] = $k;
				$condition['spec'.$idx.'_id'] = $spec_item;
				$idx--;
			}
			$condition['goods_id'] = $goods_id;
			$spec_item_id = $this->where($condition)->getField("id");		
		}	
		return $spec_item_id;
	}
	
	/**
	 * 查询出错误的信息提示
	 */
	public function makeErrorMsg($spec_conf,$goods_id)
	{
		$spec_type = array();
		foreach($spec_conf as $k=>$v)
		{
			if($v==0)
			{
				$spec_type[] = $k;
			}
		}

		if(count($spec_type)==0&&count($spec_conf)!=count($spec_type))
		{
			//所有规格已选择，表示不存在商品规格
			return L("NOT_SPEC_ITEM");
		}
		else
		{
			$msg = L("PLEASE_SELECT");
			foreach($spec_type as $k=>$v)
			{
				$msg.=D("SpecType")->where("id=".$v)->getField("name_".FANWE_LANG_ID).",";
			}
			$msg = substr($msg,0,-1);
			return $msg;
		}
	}
	
	/**
	 * 查询已选规格的信息提示
	 */
	public function makeChooseMsg($spec_conf,$goods_id)
	{
		$spec_type = array();
		$spec_choose_val = array();
		foreach($spec_conf as $k=>$v)
		{
			if($v==0)
			{
				$spec_type[] = $k;
			}
			else
			{
				$spec_choose_val[] = D("GoodsSpec")->where("id=".$v)->getField("spec_name_".FANWE_LANG_ID);
			}
		}

		
			if(count($spec_choose_val)>0)
			{
				$msg = L("YOU_SELECT")."&nbsp;&nbsp; ";
				foreach($spec_choose_val as $c_val)
				{
					$msg.=$c_val.",";
				}
				$msg = substr($msg,0,-1);
				$msg .= "&nbsp;&nbsp; ";
			}
			else
			{
				$msg = '';
			}
			if(count($spec_type)>0)
			{
				$msg .= L("PLEASE_SELECT");
				foreach($spec_type as $k=>$v)
				{
					$msg.=D("SpecType")->where("id=".$v)->getField("name_".FANWE_LANG_ID).",";
				}
				$msg = substr($msg,0,-1);
			}
			return $msg;
		
	}

	public function getOrderGoodsItem($rec_id)
	{
		$spec_info = $this->getById($rec_id);
		
		$goods_info = D("Goods")->getGoodsItem("id=".$spec_info['goods_id']);
		
		if($goods_info)
		{
			$data['small_img'] = $goods_info['small_img'];
			$data['url'] = $goods_info['url'];
		}
		
		
		return $data;
	}
	
}
?>