<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

//订单
class OrderModel extends MultiLangModel  {
	public function getOrderList($user_id,$page=1)
	{
		$limit = (($page-1)*C("PAGE_LISTROWS")).",".(C("PAGE_LISTROWS"));
		$list = $this->where("user_id=".$user_id)->order("create_time desc,update_time desc")->limit($limit)->findAll();
		foreach($list as $k=>$v)
		{	

			$list[$k]['total_price_format'] = formatPrice($v['order_total_price']);	
			$list[$k]['order_incharge_format'] = formatPrice($v['order_incharge']);
			
			$list[$k]['create_time_format'] = toDate($v['create_time']);
			$list[$k]['update_time_format'] = toDate($v['update_time']);
		}
	
		$result['list'] = $list;
		$result['total'] = $this->where('user_id='.$user_id)->count();

		return $result;
	}
	
	public function getOrderItem($order_id,$user_id)
	{
		$item = $this->where("user_id=".$user_id." and id=".$order_id)->find();
		if($item)
		{			
			$item['total_price_format'] = formatPrice($item['total_price']);			
			$item['create_time_format'] = toDate($item['create_time']);
			$item['update_time_format'] = toDate($item['update_time']);
			$item['region_lv1_info'] = D("RegionConf")->getById($item['region_lv1']);
			$item['region_lv2_info'] = D("RegionConf")->getById($item['region_lv2']);
			$item['region_lv3_info'] = D("RegionConf")->getById($item['region_lv3']);
			$item['region_lv4_info'] = D("RegionConf")->getById($item['region_lv4']);				
			$item['total_price_format'] = formatPrice($item['total_price']);
			$item['order_total_price_format'] = formatPrice($item['order_total_price']);
			$item['delivery_fee_format'] = formatPrice($item['delivery_fee']);
			$item['payment_fee_format'] = formatPrice($item['payment_fee']);
			$item['protect_fee_format'] = formatPrice($item['protect_fee']);
			$item['tax_money_format'] = formatPrice($item['tax_money']);
			$item['promote_money_format'] = formatPrice($item['promote_money']);
			$item['delivery'] = D("Delivery")->getById($item['delivery']);			
			$item['order_incharge_format'] = formatPrice($item['order_incharge']);
			$item['order_less_format'] = formatPrice($item['order_total_price'] - $item['order_incharge']);
			$item['total_price_pay_format'] = formatMoney(($item['order_total_price'] - $item['order_incharge']),D("Payment")->where("id=".$item['payment'])->getField("currency"));
		 	$item['total_price_less_format'] = formatPrice($item['order_total_price'] - $item['order_incharge']);
		 	$item['total_price_less'] = ($item['order_total_price'] - $item['order_incharge']);
			$item['payment'] = D("Payment")->getById($item['payment']);
		}
		return $item;
	}
	
	public function getGoodsList($order_id)
	{
		$list = D("OrderGoods")->where("order_id=".$order_id)->findAll();
		foreach($list as $k=>$v)
		{
			$order_goods = D($v['rec_module'])->getOrderGoodsItem($v['rec_id']);
			$list[$k]['url'] = $order_goods['url'];
			$list[$k]['small_img'] = $order_goods['small_img'];
			$list[$k]['data_price_format'] = formatPrice($v['data_price']);
			$list[$k]['data_score_format'] = formatScore($v['data_score']);
			$list[$k]['data_total_price_format'] = formatPrice($v['data_total_price']);
			$list[$k]['data_total_score_format'] = formatScore($v['data_total_score']);
			
		}
		return $list;
	}
}
?>