<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------


class PaymentModel extends MultiLangModel  {
	//获取订单的支付接口
	public function getPayment($order_id,$user_money = 0,$amount=0)
	{
		if($user_money==1)
		{
			//会员充值
			$incharge_info = D("UserIncharge")->getById($order_id);
			$payment_info = $this->getById($incharge_info['payment']);
			$currency_info = D("Currency")->getById($payment_info['currency']);
			
			//生成支付日志
			if($payment_info['online_pay']==1)
			{
				$payment_log_data = array();
				$payment_log_data['rec_id'] = $incharge_info['id'];
				$payment_log_data['payment_id'] = $payment_info['id'];
				$payment_log_data['currency_id'] = $payment_info['currency'];
				$payment_log_data['rec_module'] = 'UserIncharge';			
				$payment_log_id = M("PaymentLog")->add($payment_log_data);
			}
			else
			{
				$payment_log_id = 0;
			}
			
			$money = $incharge_info['money'];
			if($payment_info['fee_type'] == 0)
			{
				//定额手续费
				$money = $money + $payment_info['fee'];
			}
			else 
			{
				$money = $money + ($money * $payment_info['fee'] / 100);
			}
			$money = $money*$currency_info['radio'];
			$payment_id = $payment_info['id'];
			$currency_id = $currency_info['id'];
			
			$payment_class = $payment_info['class_name']."Payment";
			$payment_model = new $payment_class;
			
			$code =  $payment_model->getPaymentCode($payment_log_id, $money, $payment_id, $currency_id);
			return $code;
		}
		else 
		{
			//默认的订单支付接口获取
			$order_info = D("Order")->getById($order_id);
					
			//完成订单信息的获取			
			$payment_info = $this->getById($order_info['payment']);
			$currency_info = D("Currency")->getById($payment_info['currency']);
		
			//生成支付日志
			if($payment_info['online_pay']==1)
			{
				$payment_log_data = array();
				$payment_log_data['rec_id'] = $order_info['id'];
				$payment_log_data['payment_id'] = $payment_info['id'];
				$payment_log_data['currency_id'] = $payment_info['currency'];
				$payment_log_data['rec_module'] = 'Order';			
				$payment_log_id = M("PaymentLog")->add($payment_log_data);
			}
			else
			{
				$payment_log_id = 0;
			}
			
			if($amount==0)
			{
				$money = ($order_info['order_total_price'] - $order_info['order_incharge']) * $currency_info['radio'];
			}
			else
			{
				$money = $amount * $currency_info['radio'];
			}
			$payment_id = $payment_info['id'];
			$currency_id = $currency_info['id'];
			
			$payment_class = $payment_info['class_name']."Payment";
			
			$payment_model = new $payment_class;
				
			$code =  $payment_model->getPaymentCode($payment_log_id, $money, $payment_id, $currency_id);
			return $code;
		}
	}
	
	

}
?>