<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 积分商品
class ScoreGoodsModel extends MultiLangModel implements CartItemInterface  {
	
	public function searchGoodsList($page,$sort)
	{
		//开始处理分页
		$page_size = $page;
		$page_count = sunnyiC("GOODS_PAGE_LISTROWS");
		$limit = ($page_size-1)*$page_count.",".$page_count;
		
		if($sort=='')
		{
			$sort = 'sort desc';
		}
		
		$now = gmtTime();
		$sql = "select goods.*,promote_child.score as promote_score from ".C("DB_PREFIX")."promote_child as promote_child ".
			   "left join ".C("DB_PREFIX")."promote as promote on promote_child.promote_id = promote.id ".
			   "left join ".C("DB_PREFIX")."goods as goods on goods.id = promote_child.rec_id ".
			   "where promote_child.module_name = 'Goods' ".
			   "and promote.promote_begin_time<=".$now." ".
			   "and promote.promote_end_time>=".$now." ".
			   "and promote.promote_type_id = 8 ".
			   "and promote.is_card = 0 ".
			   "and promote.status = 1 ".
			   "and goods.status = 1 ".
			   "order by ".$sort." ".
			   "limit ".$limit;

		$list = D()->query($sql);
		if($list)
		{
			foreach ($list as $k=>$v)
			{
				$goods_data = D("Goods")->getGoodsItem("id=".$v['id']);
				foreach($goods_data as $kk=>$vv)
				{
					if($kk!='id'&&$kk!='url'&&$kk!='score'&&$kk!='sort'&&$kk!='status')
					$list[$k][$kk] = $vv;
				}
				$list[$k]['url'] = U("ScoreGoods/show",array("id"=>$v['id']));
				$list[$k]['score_format'] = formatScore("-".$v['promote_score']);
			}
			
			$result['goods_list'] = $list;
			$sql_total = "select count(*) as total from ".C("DB_PREFIX")."promote_child as promote_child ".
			   "left join ".C("DB_PREFIX")."promote as promote on promote_child.promote_id = promote.id ".
			   "left join ".C("DB_PREFIX")."goods as goods on goods.id = promote_child.rec_id ".
			   "where promote_child.module_name = 'Goods' ".
			   "and promote.promote_begin_time<=".$now." ".
			   "and promote.promote_end_time>=".$now." ".
			   "and promote.promote_type_id = 8 ".
			   "and promote.is_card = 0 ".
			   "and promote.status = 1 ".
			   "and goods.status = 1 ";
			$total = D()->query($sql_total);
			$total = $total[0]['total'];
			$result['goods_total']	= $total;
		}
		return $result;
	}
	//用于购物车提取的方法
	public function getCartItem($id)
	{
		$spec_info = D("GoodsSpecItem")->getById($id);
		$goods_info = D("Goods")->getGoodsItem("id=".$spec_info['goods_id']);
		$now = gmtTime();
		$sql = "select goods.*,promote_child.score as promote_score from ".C("DB_PREFIX")."promote_child as promote_child ".
			   "left join ".C("DB_PREFIX")."promote as promote on promote_child.promote_id = promote.id ".
			   "left join ".C("DB_PREFIX")."goods as goods on goods.id = promote_child.rec_id ".
			   "where promote_child.module_name = 'Goods' ".
			   "and promote.promote_begin_time<=".$now." ".
			   "and promote.promote_end_time>=".$now." ".
			   "and promote.promote_type_id = 8 ".
			   "and promote.is_card = 0 ".
			   "and promote.status = 1 ".
			   "and goods.status = 1 ".
			   "and goods.id = ".$goods_info['id'];
		
		$score_goods_info = D()->query($sql);
		$score_goods_info = $score_goods_info[0];
		
		
		//组合规格信息至商品信息中
		$goods_info['sn'] = $spec_info['sn'];
		$goods_info['stock'] = $spec_info['stock'];
		$goods_info['weight'] = $spec_info['weight'];
		$goods_info['id'] = $spec_info['id'];
		$goods_info['goods_id'] = $spec_info['goods_id'];
		$goods_info['score'] = "-".$score_goods_info['promote_score'];   	
		
		$goods_info['url'] = U("ScoreGoods/show",array("id"=>$goods_info['goods_id']));
		$goods_info['name'] = $goods_info['name_'.FANWE_LANG_ID];
    	$goods_info['data_weight'] = $goods_info['weight'];
	   					
		$spec_conf_str = '';
		if($spec_info['spec1_id']!=0)
		$spec_conf_str.=D("GoodsSpec")->where("id=".$spec_info['spec1_id'])->getField("spec_name_".FANWE_LANG_ID).",";
						
		if($spec_info['spec2_id']!=0)
		$spec_conf_str.=D("GoodsSpec")->where("id=".$spec_info['spec2_id'])->getField("spec_name_".FANWE_LANG_ID).",";

		if($spec_conf_str!='')
		$spec_conf_str = substr($spec_conf_str,0,-1);
		
		if($spec_conf_str != '')
		{
			$goods_info['name'].="(".$spec_conf_str.")";
		}		
		
		return $goods_info;
	}
	
	public function getGoodsItem($goods_id)
	{
		$now = gmtTime();
		$sql = "select goods.*,promote_child.score as promote_score from ".C("DB_PREFIX")."promote_child as promote_child ".
			   "left join ".C("DB_PREFIX")."promote as promote on promote_child.promote_id = promote.id ".
			   "left join ".C("DB_PREFIX")."goods as goods on goods.id = promote_child.rec_id ".
			   "where promote_child.module_name = 'Goods' ".
			   "and promote.promote_begin_time<=".$now." ".
			   "and promote.promote_end_time>=".$now." ".
			   "and promote.promote_type_id = 8 ".
			   "and promote.is_card = 0 ".
			   "and promote.status = 1 ".
			   "and goods.status = 1 ".
			   "and goods.id = ".$goods_id;
		
		$goods_item = D()->query($sql);
		$goods_item = $goods_item[0];

		if($goods_item)
		{
			$origin_goods_item = D("Goods")->getGoodsItem("id=".$goods_item['id']." and status=1",true);
			foreach($origin_goods_item as $kk=>$vv)
			{
				$goods_item[$kk] = $vv;
			}
			$goods_item['score_format'] = formatScore("-".$goods_item['promote_score']);
			$goods_item['url'] = U("ScoreGoods/show",array("id"=>$goods_item['id']));
		}
		return $goods_item;
	}
		

	public function getOrderGoodsItem($rec_id)
	{
		$spec_info = D("GoodsSpecItem")->getById($rec_id);
		
		$goods_info = D("Goods")->getGoodsItem("id=".$spec_info['goods_id']);
		
		if($goods_info)
		{
			$data['small_img'] = $goods_info['small_img'];
			$data['url'] = $goods_info['url'];
		}
		
		
		return $data;
	}
}
?>