<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 支付宝模型
class AlipayPayment extends Think implements Payment  {

	public function getPaymentCode($payment_log_id, $money, $payment_id, $currency_id)
	{
		$currency = D("Currency")->getById($currency_id);
		$payment_info = D("Payment")->getById($payment_id);
		$payment_info['config'] = unserialize($payment_info['config']);
		$agent = 'C4335319945672464113';
		
		C("URL_MODEL",0);
		$data_return_url = "http://".$_SERVER['SERVER_NAME'].U("Payment/response",array('payment_name'=>'Alipay'));
		$data_notify_url = "http://".$_SERVER['SERVER_NAME'].U("Payment/response",array('payment_name'=>'Alipay'));
		$cancel_return = "http://".$_SERVER['SERVER_NAME'].U("Payment/cancel",array('payment_name'=>'Alipay'));
		$cancel_return = '';
		

		$real_method = $payment_info['config']['alipay_service'];

        switch ($real_method){
            case '0':
                $service = 'trade_create_by_buyer';
                break;
            case '1':
                $service = 'create_partner_trade_by_buyer';
                break;
            case '2':
                $service = 'create_direct_pay_by_user';
                break;
        }	
        
		$payment_log = M("PaymentLog")->getById($payment_log_id);
		$data_sn = D($payment_log['rec_module'])->where("id=".$payment_log['rec_id'])->getField("sn");  //数据的单号
        
        $parameter = array(
            'agent'             => $agent,
            'service'           => $service,
            'partner'           => $payment_info['config']['alipay_partner'],
            //'partner'           => ALIPAY_ID,
            '_input_charset'    => 'utf-8',
            'notify_url'        => $data_notify_url,
            'return_url'        => $data_return_url,
            /* 业务参数 */
            'subject'           => $data_sn,
            'out_trade_no'      => $payment_log_id,
            'price'             => $money,
            'quantity'          => 1,
            'payment_type'      => 1,
            /* 物流参数 */
            'logistics_type'    => 'EXPRESS',
            'logistics_fee'     => 0,
            'logistics_payment' => 'BUYER_PAY_AFTER_RECEIVE',
            /* 买卖双方信息 */
            'seller_email'      => $payment_info['config']['alipay_account']
        );
        
        ksort($parameter);
        reset($parameter);

        $param = '';
        $sign  = '';

        foreach ($parameter AS $key => $val)
        {
        	$param .= "$key=" .urlencode($val). "&";
            $sign  .= "$key=$val&";
        }

        $param = substr($param, 0, -1);
        $sign  = substr($sign, 0, -1). $payment_info['config']['alipay_key'];
        $def_url = '<div style="text-align:center"><input type="button" onclick="window.open(\'https://www.alipay.com/cooperate/gateway.do?'.$param. '&sign='.md5($sign).'&sign_type=MD5\')" value="' .L("ALIPAY_PAYMENT_BUTTON"). '" /></div>';
		$def_url.="<br />".L("TOTAL_PRICE").":".$currency['unit']." ".number_format($money,2);
        return $def_url;
	}
	
	public function dealResult($get,$post,$request)
	{	
		if (!empty($post))
        {
            foreach($post as $key => $data)
            {
                $get[$key] = $data;
            }
        }
        
		$return_res = array(
			'info'=>'',
			'status'=>false,
		);
		$payment   =  D("Payment")->where("class_name='Alipay'")->find();   
		$currency_radio = D("Currency")->where("id=".$payment['currency'])->getField("radio");
    	$payment['config'] = unserialize($payment['config']);
    	$seller_email = rawurldecode($get['seller_email']);
    	
    	
    	
        /* 检查数字签名是否正确 */
        ksort($get);
        reset($get);

	
        foreach ($get AS $key=>$val)
        {
            if ($key != 'sign' && $key != 'sign_type' && $key != 'code' && $key!='payment_name')
            {
                $sign .= "$key=$val&";
            }
        }

        $sign = substr($sign, 0, -1) . $payment['config']['alipay_key'];
		if (md5($sign) != $get['sign'])
        {
            $return_res['info'] = L("VALID_ERROR");
            return $return_res; 
        }
		
        //初始化处理订单函数的参数
    	$payment_log_id = $get['out_trade_no'];
    	$money = $get['total_fee'];
    	$payment_id = $payment['id'];
    	$currency_id = $payment['currency'];           
    	
        return order_paid($payment_log_id,$money,$payment_id,$currency_id);         
	}
}
?>