<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------


/**
 * sunnyi 前台标签库，用于多语言的数据展示
 */
import('TagLib');
class TagLibSunnyi extends TagLib
{//类定义开始
  	public function _initialize() {
        $this->xml = dirname(__FILE__).'/Tags/sunnyi.xml';
    }
   
    
    /**
     * 用于显示多语言字段的相应字段值
     * <sunnyi:lang value="$vo.name" />
     *
     * @param unknown_type $attr
     * @return unknown
     */
    public function _lang($attr)
    {
    	$lang_name = $_SESSION['sunnyi_lang'];
    	$lang_item = D("LangConf")->where("lang_name='".$lang_name."'")->find();  //查询出当前语言环境值    	
        $tag  = $this->parseXmlAttr($attr,'lang');
        $var = explode("|",$tag['value']);
        $var_name =$var[0];
        if($var[1])
        $var_function = $var[1];
        if($var_function)
        $parseStr = C('TMPL_L_DELIM').$var_name."_".$lang_item['id']."|".$var_function.C('TMPL_R_DELIM'); 
        else
        $parseStr = C('TMPL_L_DELIM').$var_name."_".$lang_item['id'].C('TMPL_R_DELIM'); 
        return $parseStr;
    }
    
	/**
     * 用于动态布局的标签
     * 适用于以下动态布局
     * 1. 指定分类下的商品调用
     * 2. 指定文章下的商品调用
     * 3. 指定类型下的商品调用
     * 4. 指定类型下的文章调用
     */
    public function _layout($attr)
    { 	
        $tag  = $this->parseXmlAttr($attr,'layout');
        $module = $tag['module'];   	 //操作的模块
        $rec_id = $tag['rec_id'];   	 //操作的ID
        $rec_type = $tag['rec_type'];    //操作的类型
        $rec_value = $tag['rec_value'];  //操作的值        
        
        $item_limit = intval($tag['item_limit']);		//元素个数
        $group_limit = intval($tag['group_limit']);		//分组个数
        
        $file = $tag['file'];
        $advid = intval($tag['advid']);
        
        
        $list_data = array();        
        switch(strtolower($module))
        {
        	case 'goods':
        		if(strtolower($rec_type) == 'rec_cate')
        		{
	        		$child_cates = D("GoodsCate")->getGoodsCateList('(pid='.$rec_id.' and status=1) or (id='.$rec_id.' and status=1)','pid asc, sort desc',$group_limit); //子目录        		
	        		foreach($child_cates as $k=>$cate)
	        		{
	        			$child_ids = D("GoodsCate")->getChildIds($cate['id']); //获取所有子分类ID
	        			$child_ids[] = $cate['id'];
	        			
	        			$condition['cate_id'] = array('in',$child_ids);
	        			$condition['status'] = 1;
	        			$child_cates[$k]['goods_list'] = D('Goods')->getGoodsList($condition,$item_limit,'sort desc');
	        		}
	        		$list_data['item'] = D("GoodsCate")->getGoodsCateItem('id='.$rec_id);
	        		$list_data['list'] = $child_cates;
        		}
        		if(strtolower($rec_type) == 'rec_field')
        		{
        			$all_cate['short'] = L("ALL");
			    	$rec_model = parse_name($rec_value,1);
			    	$rec_model = strtolower(substr($rec_model,0,1)).substr($rec_model,1);
			    	$all_cate['url'] = U("Goods/".$rec_model);
			    	$condition = array();
			    	$condition[$rec_value] = 1;
			    	$condition['status'] = 1;
			    	$all_cate['goods_list'] = D("Goods")->getGoodsList($condition,$item_limit,'sort desc');
			    	
			    	$res[] = $all_cate;
			    	$rec_cate = D("GoodsCate")->getGoodsCateList($condition,'sort desc',$group_limit);
			    	foreach($rec_cate as $k=>$v)
			    	{
			    		$childIds = D("GoodsCate")->getChildIds($v['id']);
			    		$childIds[] = $v['id'];
			    		$condition = array();
			    		$condition[$rec_value] = 1;
			    		$condition['status'] = 1;
			    		$condition['cate_id'] = array('in',$childIds);
			    		$v['goods_list'] = D("Goods")->getGoodsList($condition,$item_limit,'sort desc');
			    		$res[] = $v;
			    	}
			    	$list_data = $res;
        		}
        		if(strtolower($rec_type) == 'rec_promote')
        		{
        			$now = time();
			    	$condition['promote_begin_time'] = array('lt',$now);
			    	$condition['promote_end_time'] = array('gt',$now);
			    	$condition['status'] = 1;
			    	$condition['is_inquiry'] = 0;
			    	$list_data = D("Goods")->getGoodsList($condition,$item_limit,'sort desc');
        		}
        		
        		$top_sale = D("Goods")->getTopSale(5,$rec_id);
        		break;

        	case 'article':
     			if(strtolower($rec_type) == 'rec_cate')
     			{
	        		$child_ids = D("ArticleCate")->getChildIds($rec_id); //获取所有子分类ID
	        		$child_ids[] = $rec_id;
	        		$condition['cate_id'] = array('in',$child_ids);
	        		$condition['status'] = 1;   		
	        		$list_data['item'] = D("ArticleCate")->getArticleCateItem('id='.$rec_id);
	        		$list_data['list'] = D('Article')->getArticleList($condition,$item_limit,'sort desc');  
     			}
     			if(strtolower($rec_type) == 'rec_type_article')
     			{
     				$list_data['name'] = L("ARTICLE_TYPE_".$rec_value);
     				$list_data['list'] = D("Article")->getTypeArticleList($rec_value,$item_limit);
     			}
        		break;     		
        }
		
		$list_data_code = var_export($list_data,true); //还原数组代码	
		
		$top_sale_code = var_export($top_sale,true);	

		
		$parseStr = "<?php \$rec_list = $list_data_code; \$adv = $advid; \$cate_top_sale = $top_sale_code;  ?>";
        $parseStr .= "<include file='$file' />"; 
        return $parseStr;
    }
    
	/**
     * 用于显示配送方式的库
     * <sunnyi:consignee consignee_id="1" file="Inc:consignee_item" />
     */
    public function _consignee($attr)
    { 	
        $tag  = $this->parseXmlAttr($attr,'consignee');
        $consignee_id = $tag['consignee_id'];
		$file = $tag['file'];

		$parseStr = "<?php \$consignee_item = D('UserConsignee')->getConsigneeItem($consignee_id); ?>";
        $parseStr.="<?php \$region_lv1_list=D('RegionConf')->where('pid=0')->findAll(); ?>";
        $parseStr.="<?php \$pid = D('RegionConf')->where(\"id=\".\$consignee_item['region_lv2'])->getField('pid'); ?>";
		$parseStr.="<?php \$region_lv2_list=D('RegionConf')->where('pid='.\$pid)->findAll(); ?>";
		$parseStr.="<?php \$pid = D('RegionConf')->where(\"id=\".\$consignee_item['region_lv3'])->getField('pid'); ?>";
		$parseStr.="<?php \$region_lv3_list=D('RegionConf')->where('pid='.\$pid)->findAll(); ?>";
		$parseStr.="<?php \$pid = D('RegionConf')->where(\"id=\".\$consignee_item['region_lv4'])->getField('pid'); ?>";
		$parseStr.="<?php \$region_lv4_list=D('RegionConf')->where('pid='.\$pid)->findAll(); ?>";
	
		
		
		$parseStr .= "<include file='$file' />"; 
        return $parseStr;
    }
 
}//类定义结束
?>