-- phpMyAdmin SQL Dump
-- version 2.11.7
-- http://www.phpmyadmin.net
--
-- 主机: localhost
-- 生成日期: 2011 年 10 月 11 日 14:19
-- 服务器版本: 5.0.51
-- PHP 版本: 5.2.6

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

--
-- 数据库: `thinktuan_open`
--

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_active`
--

DROP TABLE IF EXISTS `thinktuan_active`;
CREATE TABLE IF NOT EXISTS `thinktuan_active` (
  `id` int(11) NOT NULL auto_increment,
  `f_name` varchar(255) default NULL,
  `f_logo` char(255) default NULL,
  `f_type` char(11) default NULL COMMENT '型类',
  `f_date_begin` date default NULL,
  `f_date_end` date default NULL,
  `f_active_date` char(255) default NULL,
  `f_active_times` char(255) default NULL,
  `f_enroll_num` int(11) default '0' COMMENT '报名人数',
  `f_active_memo` text,
  `f_active_address` varchar(255) default NULL,
  `f_status` smallint(6) default '0' COMMENT '0为征召中，1为已经截止',
  `f_sort` smallint(6) default '0',
  `f_active_phone` char(255) default NULL,
  `f_active_qq` int(11) default NULL,
  `f_area_id` int(11) default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_active_enroll`
--

DROP TABLE IF EXISTS `thinktuan_active_enroll`;
CREATE TABLE IF NOT EXISTS `thinktuan_active_enroll` (
  `id` int(11) NOT NULL auto_increment,
  `f_member_id` int(11) default NULL,
  `f_name` char(255) default NULL,
  `f_phone` char(50) default NULL,
  `f_email` char(255) default NULL,
  `f_qq` char(255) default NULL,
  `f_address` char(255) default NULL,
  `f_enroll_num` smallint(6) default NULL,
  `f_active_id` int(11) default NULL,
  `f_know_way` varchar(255) default NULL,
  `f_status` smallint(6) default '0' COMMENT '0默认为正常',
  `f_memo` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_active_shop`
--

DROP TABLE IF EXISTS `thinktuan_active_shop`;
CREATE TABLE IF NOT EXISTS `thinktuan_active_shop` (
  `id` int(11) NOT NULL auto_increment,
  `f_shop_id` int(11) default NULL,
  `f_active_id` int(11) default NULL,
  `f_sort` smallint(6) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=39 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_auth_module`
--

DROP TABLE IF EXISTS `thinktuan_auth_module`;
CREATE TABLE IF NOT EXISTS `thinktuan_auth_module` (
  `id` int(11) NOT NULL auto_increment,
  `f_code` varchar(7) default NULL,
  `f_name` varchar(50) default NULL,
  `f_url` varchar(50) default NULL,
  `f_module` varchar(255) default NULL,
  `f_action` varchar(255) default NULL,
  `f_status` smallint(6) default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=166 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_auth_role`
--

DROP TABLE IF EXISTS `thinktuan_auth_role`;
CREATE TABLE IF NOT EXISTS `thinktuan_auth_role` (
  `id` int(11) NOT NULL auto_increment,
  `f_name` varchar(255) default NULL,
  `f_status` smallint(6) default '0',
  `f_mold_id` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_auth_user`
--

DROP TABLE IF EXISTS `thinktuan_auth_user`;
CREATE TABLE IF NOT EXISTS `thinktuan_auth_user` (
  `id` int(11) NOT NULL auto_increment,
  `f_usercode` varchar(20) default NULL,
  `f_username` varchar(50) default NULL,
  `f_password` varchar(255) default NULL,
  `f_add_time` datetime default NULL,
  `f_time_login` datetime default NULL,
  `f_login_number` int(11) default NULL,
  `f_status` smallint(6) default '0' COMMENT '0 为正常\r\n            -1 为停用',
  `f_role_id` varchar(5) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_award`
--

DROP TABLE IF EXISTS `thinktuan_award`;
CREATE TABLE IF NOT EXISTS `thinktuan_award` (
  `id` int(11) NOT NULL auto_increment,
  `f_name` varchar(255) default NULL,
  `f_date_begin` date default NULL,
  `f_date_end` date default NULL,
  `f_award_times` char(255) default NULL COMMENT '开奖时间',
  `f_status` int(11) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_award_detail`
--

DROP TABLE IF EXISTS `thinktuan_award_detail`;
CREATE TABLE IF NOT EXISTS `thinktuan_award_detail` (
  `id` int(11) NOT NULL auto_increment,
  `f_award_id` int(11) default NULL,
  `f_award_pre1` varchar(255) default NULL COMMENT '段号1前缀',
  `f_award_pre2` varchar(255) default NULL COMMENT '段号2前缀',
  `f_award_code1` varchar(255) default NULL COMMENT '成生的第一个号码',
  `f_award_code2` varchar(255) default NULL COMMENT '第二个号码',
  `f_award_code` varchar(255) default NULL COMMENT '终最参与抽奖的号码',
  `f_shop_id` int(11) default '0',
  `f_member_id` int(11) default '0',
  `f_status` smallint(6) default '0' COMMENT '0为未启用 1为激活 3为中奖',
  `f_using_times` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=101 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_bill_cash`
--

DROP TABLE IF EXISTS `thinktuan_bill_cash`;
CREATE TABLE IF NOT EXISTS `thinktuan_bill_cash` (
  `id` int(11) NOT NULL auto_increment,
  `f_bill_order_code` varchar(255) default NULL,
  `f_datetime` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `f_subject` smallint(6) default '0' COMMENT '0 代表订单进款（支付）默认\r\n            1 代表订单出款（退款）',
  `f_money` decimal(10,2) default NULL,
  `f_member_id` int(11) default NULL,
  `f_user_id` int(11) default NULL,
  `f_memo` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=36 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_bill_detail`
--

DROP TABLE IF EXISTS `thinktuan_bill_detail`;
CREATE TABLE IF NOT EXISTS `thinktuan_bill_detail` (
  `id` int(11) NOT NULL auto_increment,
  `f_bill_order_id` int(11) default NULL,
  `f_group_buy_id` int(11) default NULL,
  `f_count` int(11) default '1',
  `f_price` decimal(10,2) default NULL,
  `f_bill_order_code` varchar(20) default NULL,
  `f_comment_status` smallint(6) default '0' COMMENT '新加字段， 这是评论状态 \r\n\r\n0为未评论\r\n1为已经论',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=255 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_bill_order`
--

DROP TABLE IF EXISTS `thinktuan_bill_order`;
CREATE TABLE IF NOT EXISTS `thinktuan_bill_order` (
  `id` int(11) NOT NULL auto_increment,
  `f_bill_order_code` varchar(20) default NULL,
  `f_member_id` int(11) default NULL,
  `f_datetime` timestamp NULL default CURRENT_TIMESTAMP,
  `f_status` smallint(6) default '0' COMMENT '0 代表未结付\r\n            1 代表已结付\r\n            2 代表可发购买码\r\n            3 代表已经购买\r\n            -1 代表该购买卷被冻结',
  `f_user_id` int(11) default NULL,
  `f_count` int(11) default NULL,
  `f_pay_way` varchar(20) default '0',
  `f_comment` varchar(255) default NULL,
  `f_buy_time` datetime default NULL,
  `f_delay_date` datetime default NULL,
  `f_post_way` smallint(6) default '0',
  `f_recipient` varchar(255) default NULL COMMENT '收货人名字',
  `f_address` varchar(255) default NULL COMMENT '地址',
  `f_phone` varchar(255) default NULL COMMENT '手机',
  `f_city_id` varchar(6) default NULL COMMENT '区地',
  `f_zip` varchar(255) default NULL COMMENT '邮编',
  `f_tel` varchar(255) default NULL COMMENT '座机',
  `f_money` decimal(10,2) default '0.00',
  `f_money_agency` decimal(10,2) default '0.00' COMMENT '代金券',
  `f_money_balance` decimal(10,2) default '0.00',
  `f_money_reality` decimal(10,2) default '0.00',
  `f_money_post` decimal(10,2) default '0.00',
  `f_money_bill` decimal(10,2) default '0.00',
  `f_address_id` int(11) default '0',
  `f_bill_package_id` int(11) default '0',
  `f_post_id` smallint(6) default '0' COMMENT '订单对应运费模版',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=282 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_bill_package`
--

DROP TABLE IF EXISTS `thinktuan_bill_package`;
CREATE TABLE IF NOT EXISTS `thinktuan_bill_package` (
  `id` int(11) NOT NULL auto_increment,
  `f_post_way` smallint(11) default NULL,
  `f_status` smallint(6) default '0',
  `f_send_time` datetime default NULL,
  `f_datetime` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `f_member_id` int(11) default NULL,
  `f_user_id` int(11) default NULL,
  `f_recipient` varchar(255) default NULL,
  `f_address` varchar(255) default NULL,
  `f_phone` varchar(255) default NULL,
  `f_city_id` varchar(6) default NULL,
  `f_zip` varchar(255) default NULL,
  `f_tel` varchar(255) default NULL,
  `f_memo` varchar(255) default NULL,
  `f_package_code` varchar(50) default NULL,
  `f_post_company` varchar(255) default NULL,
  `f_bill_order_array` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=21 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_bill_refund`
--

DROP TABLE IF EXISTS `thinktuan_bill_refund`;
CREATE TABLE IF NOT EXISTS `thinktuan_bill_refund` (
  `id` int(11) NOT NULL auto_increment,
  `f_bill_order_code` varchar(20) default NULL COMMENT '订单ID',
  `f_reason` varchar(255) default NULL COMMENT '退货理由',
  `f_money` decimal(10,2) default NULL COMMENT '订单金额',
  `f_money_reality` decimal(10,2) default NULL COMMENT '实际退货金额',
  `f_status` smallint(6) default '0' COMMENT '0 代表未结付\r\n            1 代表已结付',
  `f_time_apply` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '打款日期',
  `f_time_return` datetime default NULL,
  `f_pay_way` varchar(50) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_group_buy`
--

DROP TABLE IF EXISTS `thinktuan_group_buy`;
CREATE TABLE IF NOT EXISTS `thinktuan_group_buy` (
  `id` int(11) NOT NULL auto_increment,
  `f_area_id` smallint(6) default '0',
  `f_buy_way` varchar(7) default NULL,
  `f_post_free` smallint(6) default '0',
  `f_sort` smallint(6) default '0',
  `f_post_way` smallint(6) default '0' COMMENT '0 代表消费卷\r\n            1 代表邮递',
  `f_trade` varchar(7) default NULL,
  `f_trade_extend` varchar(7) default NULL,
  `f_title` varchar(255) default NULL,
  `f_title_short` varchar(255) default NULL,
  `f_date_begin` date default NULL,
  `f_date_end` date default NULL,
  `f_serial_num` smallint(6) default '0',
  `f_status` smallint(6) default '0' COMMENT '0 代表信息已发布，待确认\r\n            1 代表已经审核正在发布\r\n            2 代表认购结束\r\n            3\r\n            ',
  `f_summary` varchar(500) default NULL,
  `f_logo` varchar(255) default NULL,
  `f_content` text,
  `f_shop_id` int(11) default NULL,
  `f_people_min` int(11) default NULL,
  `f_people_max` int(11) default NULL,
  `f_price` decimal(10,1) default NULL,
  `f_price_now` decimal(10,1) default NULL,
  `f_discount` decimal(10,1) default NULL,
  `f_save_on` decimal(10,1) default NULL,
  `f_buyer_num` int(11) default '0',
  `f_success_time` datetime default NULL,
  `f_memo` varchar(255) default NULL,
  `f_specialty` varchar(255) default NULL,
  `f_them_say` varchar(255) default NULL,
  `f_we_say` varchar(255) default NULL,
  `f_group_type` smallint(6) default NULL COMMENT '0 代表团购项目\r\n            1 代表热销商品',
  `f_max_buy` int(11) default '0',
  `f_expense_date` date default NULL,
  `f_picture1` varchar(255) default NULL,
  `f_picture2` varchar(255) default NULL,
  `f_return_money` decimal(10,2) default '0.00',
  `f_product_type` varchar(7) default NULL,
  `f_if_agency` smallint(6) default '0',
  `f_to_point` smallint(6) default NULL COMMENT '转换积分',
  `f_buyer_init` int(11) default '0',
  `f_notify_sms` smallint(6) default '0',
  `f_volume_id` smallint(6) default NULL,
  `f_enable_sms` smallint(6) default NULL,
  `f_code_no` varchar(50) default NULL,
  `f_seo_key` varchar(255) default NULL,
  `f_seo_memo` varchar(255) default NULL,
  `f_award_id` int(11) NOT NULL,
  `f_post_id` smallint(6) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_member`
--

DROP TABLE IF EXISTS `thinktuan_member`;
CREATE TABLE IF NOT EXISTS `thinktuan_member` (
  `id` int(11) NOT NULL auto_increment,
  `f_usercode` varchar(50) default NULL,
  `f_email` varchar(255) default NULL,
  `f_username` varchar(255) default NULL,
  `f_password` varchar(50) default NULL COMMENT '此处应该存最长16位密码的md5编码',
  `f_point` decimal(10,2) default '0.00',
  `f_status` smallint(6) default '0' COMMENT '0为普通状态\r\n            -1 为停用状态\r\n            ',
  `f_area_id` int(6) default NULL,
  `f_recommend` int(11) NOT NULL default '0' COMMENT '关联自己\r\n            默认为0',
  `f_balance` decimal(10,2) default '0.00',
  `f_login_ip` varchar(255) default NULL,
  `f_if_subscribe` smallint(6) default '0' COMMENT '0 代表未订阅\r\n            1 代表已订阅\r\n            ',
  `f_phone` varchar(50) default NULL,
  `f_register_time` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `f_type` smallint(6) default '0',
  `f_mem_group_id` int(11) default NULL,
  `f_retrieve_num` char(255) default '0' COMMENT '密码找回需要的字段',
  `f_bound_num` char(255) default NULL COMMENT '改修密码时候生成的验证码',
  `f_bound_status` smallint(6) default '0' COMMENT '0是未绑定 1是已绑定',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=32 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_mem_address`
--

DROP TABLE IF EXISTS `thinktuan_mem_address`;
CREATE TABLE IF NOT EXISTS `thinktuan_mem_address` (
  `id` int(11) NOT NULL auto_increment,
  `f_member_id` int(11) default NULL,
  `f_recipient` varchar(50) default NULL,
  `f_city_id` varchar(6) default NULL,
  `f_address` varchar(255) default NULL,
  `f_zip` varchar(10) default NULL,
  `f_tel` varchar(30) default NULL,
  `f_phone` varchar(30) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_mem_cart`
--

DROP TABLE IF EXISTS `thinktuan_mem_cart`;
CREATE TABLE IF NOT EXISTS `thinktuan_mem_cart` (
  `id` int(11) NOT NULL auto_increment,
  `f_group_buy_id` int(11) default NULL,
  `f_count` int(11) default '1',
  `f_member_id` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_mem_cash`
--

DROP TABLE IF EXISTS `thinktuan_mem_cash`;
CREATE TABLE IF NOT EXISTS `thinktuan_mem_cash` (
  `id` int(11) NOT NULL auto_increment,
  `f_money` decimal(10,2) default NULL,
  `f_type` smallint(6) default NULL COMMENT '0 代表从账户里出钱\r\n            1代表从往账户里进钱',
  `f_subject` varchar(255) default NULL,
  `f_datetime` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `f_member_id` int(11) default NULL,
  `f_user_id` int(11) default NULL,
  `f_current_balance` decimal(10,0) default NULL,
  `f_memo` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=164 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_mem_comment`
--

DROP TABLE IF EXISTS `thinktuan_mem_comment`;
CREATE TABLE IF NOT EXISTS `thinktuan_mem_comment` (
  `id` int(11) NOT NULL auto_increment,
  `f_member_id` int(11) default NULL,
  `f_group_buy_id` int(11) default NULL,
  `f_comment` varchar(255) default NULL,
  `f_datetime` datetime default NULL,
  `f_status` smallint(6) default '0',
  `f_reply` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_mem_deduct`
--

DROP TABLE IF EXISTS `thinktuan_mem_deduct`;
CREATE TABLE IF NOT EXISTS `thinktuan_mem_deduct` (
  `id` int(11) NOT NULL auto_increment,
  `f_member_id` int(11) default NULL,
  `f_bill_order_code` varchar(20) default NULL,
  `f_return_money` decimal(10,2) default NULL,
  `f_status` smallint(6) default '0',
  `f_return_time` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `f_receiver` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=148 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_mem_point`
--

DROP TABLE IF EXISTS `thinktuan_mem_point`;
CREATE TABLE IF NOT EXISTS `thinktuan_mem_point` (
  `id` int(11) NOT NULL auto_increment,
  `f_member_id` int(11) default NULL,
  `f_number` decimal(10,2) default NULL,
  `f_datetime` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `f_bill_order_id` int(11) default NULL,
  `f_count` int(11) default NULL,
  `f_type` smallint(6) default '0',
  `f_memo` varchar(255) default '消费累加积分',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=192 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_mem_recharge`
--

DROP TABLE IF EXISTS `thinktuan_mem_recharge`;
CREATE TABLE IF NOT EXISTS `thinktuan_mem_recharge` (
  `id` int(11) NOT NULL auto_increment,
  `f_code` varchar(255) default NULL COMMENT '充值单号',
  `f_money` decimal(10,0) default NULL COMMENT '充值金额',
  `f_time` timestamp NULL default CURRENT_TIMESTAMP COMMENT '充值时间',
  `f_member_id` int(11) default NULL,
  `f_status` int(11) default '0' COMMENT '状态：0已完成 1未完成',
  `f_type` smallint(6) default '1' COMMENT '0提现，1充值',
  `f_user` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_mem_volume`
--

DROP TABLE IF EXISTS `thinktuan_mem_volume`;
CREATE TABLE IF NOT EXISTS `thinktuan_mem_volume` (
  `id` int(11) NOT NULL auto_increment,
  `f_sequence` varchar(255) default NULL,
  `f_password` varchar(255) default NULL,
  `f_volume_id` int(11) default NULL COMMENT '使用卷ID',
  `f_member_id` int(11) default NULL COMMENT '会员ID',
  `f_status` int(11) default '0' COMMENT '团购卷使用状态 ： 0 未使用 1 已使用',
  `f_bill_order_code` varchar(20) default NULL COMMENT '使用订单号',
  `f_use_time` datetime default NULL,
  `f_provide_time` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=28 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_mem_voucher`
--

DROP TABLE IF EXISTS `thinktuan_mem_voucher`;
CREATE TABLE IF NOT EXISTS `thinktuan_mem_voucher` (
  `id` int(11) NOT NULL auto_increment,
  `f_bill_detail_id` int(11) default NULL,
  `f_bill_order_code` varchar(20) default NULL,
  `f_group_buy_id` int(11) default NULL,
  `f_member_id` int(11) default '0',
  `f_status` smallint(4) default NULL,
  `f_send_count` smallint(6) default '0',
  `f_buy_password` varchar(30) default NULL,
  `f_buy_id` varchar(30) default NULL,
  `f_buy_time` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `f_end_time` date default NULL,
  `f_count` smallint(6) default '0',
  `f_use_time` datetime default NULL COMMENT '费消时间',
  `f_shop_id` int(11) default NULL,
  `f_phone` varchar(20) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=90 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_post`
--

DROP TABLE IF EXISTS `thinktuan_post`;
CREATE TABLE IF NOT EXISTS `thinktuan_post` (
  `id` int(11) NOT NULL,
  `f_post_name` varchar(30) default NULL COMMENT '快递名称',
  `f_post_cost` float default NULL COMMENT '费用',
  `f_memo` varchar(255) default NULL COMMENT '送货方介绍 （填写相应的配送范围 以及注意事项）',
  `f_sort` smallint(6) default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_post_company`
--

DROP TABLE IF EXISTS `thinktuan_post_company`;
CREATE TABLE IF NOT EXISTS `thinktuan_post_company` (
  `id` int(11) NOT NULL auto_increment,
  `f_company` varchar(255) default NULL,
  `f_memo` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_post_detail`
--

DROP TABLE IF EXISTS `thinktuan_post_detail`;
CREATE TABLE IF NOT EXISTS `thinktuan_post_detail` (
  `id` int(11) NOT NULL auto_increment,
  `f_send_way` int(11) default NULL,
  `f_city_list` varchar(255) default NULL,
  `f_price` int(10) default NULL,
  `f_level` smallint(6) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=28 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_post_free`
--

DROP TABLE IF EXISTS `thinktuan_post_free`;
CREATE TABLE IF NOT EXISTS `thinktuan_post_free` (
  `id` int(11) NOT NULL auto_increment,
  `f_code` smallint(6) default NULL,
  `f_name` varchar(255) default NULL,
  `f_sort` smallint(6) default '0',
  `f_status` smallint(6) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_recharge_detail`
--

DROP TABLE IF EXISTS `thinktuan_recharge_detail`;
CREATE TABLE IF NOT EXISTS `thinktuan_recharge_detail` (
  `id` int(11) NOT NULL auto_increment,
  `f_recharge_volume_id` int(11) default NULL,
  `f_recharge_value` int(11) default NULL,
  `f_key` varchar(20) default NULL,
  `f_password` varchar(20) default NULL,
  `f_status` smallint(6) default '0' COMMENT '为0 的时候为未激活  1为激活',
  `f_active_time` datetime default NULL,
  `f_member_id` int(11) default NULL,
  `f_end_time` date default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=536 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_recharge_volume`
--

DROP TABLE IF EXISTS `thinktuan_recharge_volume`;
CREATE TABLE IF NOT EXISTS `thinktuan_recharge_volume` (
  `id` int(11) NOT NULL auto_increment,
  `f_recharge_value` int(11) default NULL,
  `f_name` varchar(255) default NULL,
  `f_logo` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_service_feedback`
--

DROP TABLE IF EXISTS `thinktuan_service_feedback`;
CREATE TABLE IF NOT EXISTS `thinktuan_service_feedback` (
  `id` int(11) NOT NULL auto_increment,
  `f_content` varchar(300) default NULL,
  `f_phone` varchar(50) default NULL,
  `f_call` varchar(30) default NULL,
  `f_status` smallint(6) default NULL COMMENT '0默认为0即尚未回复，1为已经查看且回复\r\n            ',
  `f_datetime` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_service_question`
--

DROP TABLE IF EXISTS `thinktuan_service_question`;
CREATE TABLE IF NOT EXISTS `thinktuan_service_question` (
  `id` int(11) NOT NULL auto_increment,
  `f_content` varchar(255) default NULL,
  `f_member_id` int(11) default NULL,
  `f_status` smallint(6) default '0' COMMENT '0为没有回复 不显示只有后台管理员可以看到\r\n1为已经回复 可以显示',
  `f_return` varchar(255) default NULL,
  `f_datetime` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=48 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_service_subject`
--

DROP TABLE IF EXISTS `thinktuan_service_subject`;
CREATE TABLE IF NOT EXISTS `thinktuan_service_subject` (
  `id` int(11) NOT NULL auto_increment,
  `f_survey_id` int(11) default NULL,
  `f_subject` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_service_survey`
--

DROP TABLE IF EXISTS `thinktuan_service_survey`;
CREATE TABLE IF NOT EXISTS `thinktuan_service_survey` (
  `id` int(11) NOT NULL auto_increment,
  `f_age` smallint(6) default '0',
  `f_sex` smallint(6) default '0',
  `f_how_know` varchar(255) default NULL,
  `f_member_id` int(11) default '0',
  `f_datetime` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_service_taste`
--

DROP TABLE IF EXISTS `thinktuan_service_taste`;
CREATE TABLE IF NOT EXISTS `thinktuan_service_taste` (
  `id` int(11) NOT NULL auto_increment,
  `f_content` varchar(255) default NULL,
  `f_member_id` varchar(255) default NULL,
  `f_datetime` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=25 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_shop`
--

DROP TABLE IF EXISTS `thinktuan_shop`;
CREATE TABLE IF NOT EXISTS `thinktuan_shop` (
  `id` int(11) NOT NULL auto_increment,
  `f_name` varchar(255) default NULL,
  `f_city_id` varchar(6) default NULL,
  `f_area_id` int(11) default NULL,
  `f_url` varchar(255) default NULL,
  `f_phone` varchar(255) default NULL,
  `f_address` varchar(255) default NULL,
  `f_line` varchar(255) default NULL,
  `f_map` varchar(255) default NULL,
  `f_map_url` varchar(255) default NULL,
  `f_memo` varchar(255) default NULL,
  `f_usercode` varchar(50) default NULL,
  `f_password` varchar(20) default NULL,
  `f_trade` char(5) default NULL,
  `f_linkman` varchar(50) default NULL,
  `f_logo` varchar(255) default NULL,
  `f_sort` int(11) default NULL,
  `f_recom` smallint(6) default '0' COMMENT '否是推荐 默认为0 不推荐 1为推荐',
  `f_we_say` text,
  `f_they_say` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_shop_apply`
--

DROP TABLE IF EXISTS `thinktuan_shop_apply`;
CREATE TABLE IF NOT EXISTS `thinktuan_shop_apply` (
  `id` int(11) NOT NULL auto_increment,
  `f_call` varchar(20) default NULL,
  `f_phone` varchar(50) default NULL,
  `f_contact` varchar(50) default NULL,
  `f_area_id` int(11) default NULL,
  `f_shop_name` varchar(255) default NULL,
  `f_trade_code` varchar(7) default NULL,
  `f_content` varchar(255) default NULL,
  `f_datetime` timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=71 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_shop_comment`
--

DROP TABLE IF EXISTS `thinktuan_shop_comment`;
CREATE TABLE IF NOT EXISTS `thinktuan_shop_comment` (
  `id` int(11) NOT NULL auto_increment,
  `f_shop_id` int(11) default NULL,
  `f_member_id` int(11) default NULL,
  `f_content` text,
  `f_times` datetime default NULL,
  `f_status` smallint(6) default NULL,
  `f_level` varchar(255) default NULL COMMENT '等级',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_shop_coupon`
--

DROP TABLE IF EXISTS `thinktuan_shop_coupon`;
CREATE TABLE IF NOT EXISTS `thinktuan_shop_coupon` (
  `id` int(11) NOT NULL auto_increment,
  `f_shop_id` int(11) default NULL COMMENT '家商ID',
  `f_city_id` int(11) default NULL COMMENT '城市ID',
  `f_business_area` int(11) default NULL COMMENT '圈商id',
  `f_name` varchar(255) default NULL COMMENT '优惠券名字',
  `f_date_end` date default NULL COMMENT '有效期',
  `f_picture` varchar(255) default NULL COMMENT '惠券优图片',
  `f_picture_print` varchar(255) default NULL,
  `f_down_count` int(11) default '0' COMMENT '载下次数',
  `f_type` char(255) default NULL,
  `f_sort` int(11) default NULL COMMENT '序排',
  `f_data_start` date default NULL COMMENT '发布时间',
  `f_status` smallint(6) default '0' COMMENT '优惠券状态 默认是0未开始  1是已开始',
  `f_memo` varchar(255) default NULL COMMENT '惠券优说明',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_shop_coupon_sendsms`
--

DROP TABLE IF EXISTS `thinktuan_shop_coupon_sendsms`;
CREATE TABLE IF NOT EXISTS `thinktuan_shop_coupon_sendsms` (
  `id` int(11) NOT NULL auto_increment,
  `f_shop_coupon_id` int(11) default NULL,
  `f_member_id` int(11) default NULL,
  `f_phone` varchar(255) default NULL,
  `f_send_time` date default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_ad`
--

DROP TABLE IF EXISTS `thinktuan_sys_ad`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_ad` (
  `id` int(11) NOT NULL auto_increment,
  `f_name` varchar(50) default NULL COMMENT '广告名',
  `f_type` varchar(20) default NULL COMMENT '类型',
  `f_position` int(11) default NULL COMMENT '位置',
  `f_address` varchar(255) default NULL COMMENT '地址',
  `f_code` varchar(255) default NULL COMMENT '代码或文件',
  `f_memo` varchar(255) default NULL COMMENT '描述',
  `f_picture` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_ad_position`
--

DROP TABLE IF EXISTS `thinktuan_sys_ad_position`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_ad_position` (
  `id` int(11) NOT NULL auto_increment,
  `f_name` varchar(50) default NULL,
  `f_width` int(11) default '0',
  `f_height` int(11) default '0',
  `f_template` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_applyfor`
--

DROP TABLE IF EXISTS `thinktuan_sys_applyfor`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_applyfor` (
  `id` int(11) NOT NULL auto_increment,
  `f_title` varchar(255) default NULL COMMENT '标题',
  `f_content` varchar(255) default NULL COMMENT '原因',
  `f_type` smallint(6) default NULL COMMENT '0 退款 1 退货',
  `f_member_id` int(11) default NULL,
  `f_phone` int(11) default NULL COMMENT '联系方式',
  `f_order_id` varchar(255) default NULL COMMENT '订单号',
  `f_datetime` timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_area`
--

DROP TABLE IF EXISTS `thinktuan_sys_area`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_area` (
  `id` int(11) NOT NULL auto_increment,
  `f_name` varchar(255) default NULL,
  `f_level` smallint(6) default '2',
  `f_memo` varchar(255) default NULL,
  `f_status` smallint(6) default '0' COMMENT '0:通过 1未通过',
  `f_sort` smallint(6) default NULL,
  `f_father_id` int(11) default '0' COMMENT '存父ID',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_canton`
--

DROP TABLE IF EXISTS `thinktuan_sys_canton`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_canton` (
  `id` int(11) NOT NULL auto_increment,
  `f_city_id` varchar(6) NOT NULL,
  `f_city_name` varchar(50) default NULL,
  `f_status` smallint(6) default '0' COMMENT '0 代表普通状态\r\n            1 代表对应可选团购城市',
  `f_province_name` varchar(50) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=487 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_friends`
--

DROP TABLE IF EXISTS `thinktuan_sys_friends`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_friends` (
  `id` int(11) NOT NULL auto_increment,
  `f_name` char(255) NOT NULL COMMENT '站网标题',
  `f_url` varchar(255) NOT NULL COMMENT '网站地址',
  `f_type` smallint(6) NOT NULL COMMENT '1为文字链接\r\n2为图片链接',
  `f_sort` int(11) NOT NULL COMMENT '排序',
  `f_images_address` varchar(255) default NULL COMMENT '图片的绝对地址',
  `f_images` varchar(255) default NULL COMMENT '上传的图片',
  `f_status` smallint(6) NOT NULL default '1' COMMENT '1是未审核 2 是审核',
  `f_seo` char(255) default NULL COMMENT '友链的关键词',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=18 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_group`
--

DROP TABLE IF EXISTS `thinktuan_sys_group`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_group` (
  `id` int(11) NOT NULL auto_increment,
  `f_name` varchar(255) default NULL,
  `f_start_point` int(11) default NULL,
  `f_end_point` int(11) default NULL,
  `f_discount` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_log`
--

DROP TABLE IF EXISTS `thinktuan_sys_log`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_log` (
  `id` int(11) NOT NULL auto_increment,
  `f_title` varchar(255) default NULL,
  `f_content` text,
  `f_type` smallint(6) default NULL COMMENT '0 代表日志 1 代表异常',
  `f_datetime` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=45 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_menu`
--

DROP TABLE IF EXISTS `thinktuan_sys_menu`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_menu` (
  `id` int(11) NOT NULL auto_increment,
  `f_name` varchar(255) default NULL COMMENT '菜单名称',
  `f_url` varchar(255) default NULL COMMENT '菜单url地址',
  `f_sort` int(11) default NULL COMMENT '排序',
  `f_type` varchar(11) default '主菜单列表' COMMENT '类型',
  `f_status` int(11) default '0' COMMENT '0 启用 1禁用',
  `f_father_id` int(11) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_news`
--

DROP TABLE IF EXISTS `thinktuan_sys_news`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_news` (
  `id` int(11) NOT NULL auto_increment,
  `f_title` varchar(255) default NULL,
  `f_section` varchar(5) default NULL,
  `f_content` text,
  `f_user_id` int(11) default NULL,
  `f_datetime` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `f_status` smallint(6) default '0',
  `f_memo` varchar(255) default NULL,
  `f_seo_key` varchar(255) default NULL,
  `f_seo_memo` varchar(255) default NULL,
  `f_outlink` varchar(255) default NULL,
  `f_url_alias` varchar(255) default NULL,
  `f_sort` smallint(6) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=44 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_pay`
--

DROP TABLE IF EXISTS `thinktuan_sys_pay`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_pay` (
  `id` int(11) NOT NULL auto_increment,
  `f_name` varchar(255) default NULL COMMENT '名称',
  `f_username` varchar(255) default NULL COMMENT '账号',
  `f_other_name` varchar(255) default NULL COMMENT '别名',
  `f_par1` varchar(255) default NULL COMMENT 'key',
  `f_par2` varchar(255) default NULL,
  `f_par3` varchar(255) default NULL,
  `f_par4` varchar(255) default NULL,
  `f_status` smallint(6) default NULL COMMENT '状态\r\n1为可用\r\n0为不可用',
  `f_memo` text COMMENT '说名',
  `f_memo_par` text,
  `f_picture` varchar(255) default NULL COMMENT '序程目录',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_setting`
--

DROP TABLE IF EXISTS `thinktuan_sys_setting`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_setting` (
  `id` int(11) NOT NULL auto_increment,
  `f_sys_name` varchar(255) default NULL,
  `f_sys_title` varchar(255) default NULL,
  `f_sys_seo_key` varchar(255) default NULL,
  `f_sys_seo_memo` varchar(255) default NULL,
  `f_sys_logo` varchar(255) default NULL,
  `f_sys_foot_logo` varchar(255) default NULL,
  `f_sys_voucher` varchar(255) default NULL,
  `f_sys_msn` varchar(255) default NULL,
  `f_sys_qq1` int(11) default NULL,
  `f_sys_qq2` int(11) default NULL,
  `f_sys_phone` varchar(255) default NULL,
  `f_sys_foot_content` varchar(255) default NULL,
  `f_sys_shop_way` int(11) default NULL,
  `f_sys_statistics` varchar(255) default NULL,
  `f_sys_icp` varchar(255) default NULL,
  `f_sys_url` varchar(255) default NULL,
  `f_sys_buy_more` smallint(6) default '0' COMMENT '0代表普通，1代表多团模式',
  `f_sys_area_id` int(11) default '1' COMMENT '默认地区',
  `f_mem_email_confirm` smallint(6) default '0',
  `f_mem_register_enable` smallint(6) default NULL,
  `f_mem_phone_confirm` smallint(6) default NULL,
  `f_mem_register_point` varchar(255) default NULL,
  `f_mem_group_id` int(11) default NULL,
  `f_mem_deduct_money` varchar(255) default NULL,
  `f_mem_volume` int(11) default NULL,
  `f_mem_auto` int(11) default NULL,
  `f_mem_recharge` int(11) default NULL,
  `f_mem_deduct_time` datetime default NULL,
  `f_mem_ip` varchar(255) default NULL,
  `f_pro_prefix` varchar(255) default NULL,
  `f_pro_watemark_status` int(11) default NULL,
  `f_pro_big_width` int(11) default NULL,
  `f_pro_big_heigth` int(11) default NULL,
  `f_pro_small_width` int(11) default NULL,
  `f_pro_small_height` int(11) default NULL,
  `f_pro_watemark_logo` varchar(255) default NULL,
  `f_pro_watemark_location` int(11) default NULL,
  `f_smtp_status` int(11) default NULL,
  `f_smtp_server` varchar(255) default NULL,
  `f_smtp_port` varchar(255) default NULL,
  `f_smtp_user` varchar(255) default NULL,
  `f_smtp_password` varchar(255) default NULL,
  `f_smtp_email` varchar(255) default NULL,
  `f_smtp_ssl` int(11) default NULL,
  `f_smtp_encrypt` int(11) default NULL,
  `f_smtp_receive_info` int(11) default NULL,
  `f_smtp_send_info` int(11) default NULL,
  `f_send_receice_info` int(11) default NULL,
  `f_send_status` int(11) default NULL,
  `f_send_issue_info` int(11) default NULL,
  `f_send_info` int(11) default NULL,
  `f_send_subscription` int(11) default NULL,
  `f_send_mend_num` int(11) default NULL,
  `f_send_group_buy` varchar(11) default NULL,
  `f_sms_name` varchar(255) default NULL,
  `f_sms_user` varchar(255) default NULL,
  `f_sms_password` varchar(255) default NULL,
  `f_sms_url` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_template`
--

DROP TABLE IF EXISTS `thinktuan_sys_template`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_template` (
  `id` int(11) NOT NULL auto_increment,
  `f_title` varchar(255) default NULL,
  `f_content` text,
  `f_type` varchar(7) default NULL,
  `f_status` smallint(6) default NULL COMMENT '1,可用\r\n0.不可用',
  `f_key` varchar(50) default 'null' COMMENT '模块对应的常量',
  `f_memo` text COMMENT '明说',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=46 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_sys_wordbook`
--

DROP TABLE IF EXISTS `thinktuan_sys_wordbook`;
CREATE TABLE IF NOT EXISTS `thinktuan_sys_wordbook` (
  `id` int(11) NOT NULL auto_increment,
  `f_code` varchar(5) default NULL,
  `f_name` varchar(50) default NULL,
  `f_sort` smallint(6) default '0',
  `f_status` smallint(6) default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='涉及会员级别、资金来往类别\r\n' AUTO_INCREMENT=57 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_task_email`
--

DROP TABLE IF EXISTS `thinktuan_task_email`;
CREATE TABLE IF NOT EXISTS `thinktuan_task_email` (
  `id` int(11) NOT NULL auto_increment,
  `f_type` smallint(6) default '0' COMMENT '0 为自定义发送，1为发送团单内容',
  `f_count` int(11) default '0' COMMENT '需要发送数',
  `f_count_send` int(11) default '0',
  `f_count_success` int(11) default '0',
  `f_count_fail` int(11) default '0',
  `f_group_buy_id` int(11) default NULL,
  `f_content` text,
  `f_title` varchar(255) default NULL,
  `f_name` varchar(255) default NULL,
  `f_sender` varchar(255) default NULL,
  `f_sendtime` datetime default NULL,
  `f_user_id` int(11) default NULL,
  `f_status` smallint(6) default '0' COMMENT '0为发送',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_task_email_detail`
--

DROP TABLE IF EXISTS `thinktuan_task_email_detail`;
CREATE TABLE IF NOT EXISTS `thinktuan_task_email_detail` (
  `id` int(11) NOT NULL auto_increment,
  `f_task_email_id` int(11) default NULL,
  `f_address` varchar(255) default NULL,
  `f_sendtime` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `f_status` smallint(6) default '0' COMMENT '0为尚未发送，-1为失败，1为成功',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=51 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_task_subscribe`
--

DROP TABLE IF EXISTS `thinktuan_task_subscribe`;
CREATE TABLE IF NOT EXISTS `thinktuan_task_subscribe` (
  `id` int(11) NOT NULL auto_increment,
  `f_address` varchar(255) default NULL,
  `f_type` smallint(6) default NULL COMMENT '0代表短信  1代表邮件\r\n            ',
  `f_datetime` timestamp NULL default NULL,
  `f_area_id` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

-- --------------------------------------------------------

--
-- 表的结构 `thinktuan_volume`
--

DROP TABLE IF EXISTS `thinktuan_volume`;
CREATE TABLE IF NOT EXISTS `thinktuan_volume` (
  `id` int(11) NOT NULL auto_increment,
  `f_name` varchar(50) default NULL COMMENT '代金卷 名称',
  `f_money` decimal(10,2) default NULL COMMENT '额金',
  `f_start_time` datetime default NULL COMMENT '开始时间',
  `f_end_time` datetime default NULL COMMENT '结束时间',
  `f_number` int(11) default '0' COMMENT '发放数量',
  `f_type` int(11) default '1' COMMENT '代金卷类型',
  `f_use_num` int(11) default '1' COMMENT '可用次数',
  `f_status` int(11) default '0' COMMENT '状态：0启用 1禁用',
  `f_issue` int(11) default NULL COMMENT '发放模式  0 管理员发放 1 积分兑换',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=23 ;
