<?php 
import('@.PayHandle._basePay' );
class MyPay extends _basePay
{
	public $payName="Tenpay" ;			// 当前的支付平台名称
	public $parameter;					// 参数列表

	public $bargainor_id;				// 财付通商家id
	public $key;						// 财付通商家密钥

	public function __construct()
	{		
		// 获得支付宝的商家参数
		$mydb = M("sys_pay");
		$this->parameter = $mydb->where("f_name='".$this->payName."'")->find();
		
		parent::__construct();
	} 
	
	// 生成支付url
	public function buildPayUrl($subject,$billOrderCode,$body="",$price="1")
	{
		$subject = iconv( "UTF-8", "GBK",$subject);	//商品名称，必填
		$body = iconv( "UTF-8", "GBK",$body);		//商品名称，必填
		
		$mydb = M("sys_pay");						// 获得支付宝的商家参数
		$result = $mydb->where("f_name='".$this->payName."'")->find();
		// echo $mydb->getlastsql();dump($result);exit;

		/* 商户号 */
		$bargainor_id=$this->parameter[f_par1]; 

		/* 密钥 */
		$key=$this->parameter[f_par2]; 
		/* 返回处理地址 */
		
		$return_url = $this->url."/openApi/payForTenpay/payWay/".$this->$payName; //异步返回地址
		//echo $return_url  ;
		//date_default_timezone_set(PRC);
		$strDate = date("Ymd");
		$strTime = date("His");

		//4位随机数
		$randNum = rand(1000, 9999);

		//10位序列号,可以自行调整。
		$strReq = $strTime . $randNum;

		/* 商家订单号,长度若超过32位，取前32位。财付通只记录商家订单号，不保证唯一。 */
		$sp_billno = $strReq;

		/* 财付通交易单号，规则为：10位商户号+8位时间（YYYYmmdd)+10位流水号 */
		$transaction_id = $bargainor_id . $strDate . $strReq;

		/* 商品价格（包含运费），以分为单位 */
		$total_fee = $price*100;		// 此处应该将价格*100！！

		/* 商品名称 */
		$desc = $body;

		/* 创建支付请求对象 */
		import('@.PayHandle.Tenpay.PayRequestHandler' );						//导入官方类文件
		$reqHandler = new PayRequestHandler();
		$reqHandler->init();
		$reqHandler->setKey($key);

		//----------------------------------------
		//设置支付参数
		//----------------------------------------
		$reqHandler->setParameter("bargainor_id", $bargainor_id);			//商户号
		$reqHandler->setParameter("sp_billno", $billOrderCode);				//商户订单号
		$reqHandler->setParameter("transaction_id", $transaction_id);		//财付通交易单号
		$reqHandler->setParameter("total_fee", $total_fee);					//商品总金额,以分为单位
		$reqHandler->setParameter("return_url", $return_url);				//返回处理地址
		$reqHandler->setParameter("desc", $desc);							//商品名称
		$reqHandler->setParameter("bank_type", $_REQUEST[bank_type]);		//商品名称
		$reqHandler->setParameter("spbill_create_ip", $_SERVER['REMOTE_ADDR']);
		//请求的URL
		$result = $reqHandler->getRequestURL();

	
		return $result;		//生成支付字符串			
	}
	
	// 此方法用来检查从支付平台过来的信息
	public  function checkPayStatus($_REQUEST)
	{			

		/* 密钥 */
		$key = $this->parameter[f_par2];			// 商家id

		/* 创建支付应答对象 */
		$resHandler = new PayResponseHandler();
		$resHandler->setKey($key);

		//判断签名
		if($resHandler->isTenpaySign()) {			
			//交易单号
			$transaction_id = $resHandler->getParameter("transaction_id");
			
			//金额,以分为单位
			$total_fee = $resHandler->getParameter("total_fee");
			
			//支付结果
			$pay_result = $resHandler->getParameter("pay_result");
			
			if( "0" == $pay_result ) {
			
				//------------------------------
				//处理业务开始
				//------------------------------
				
				//注意交易单不要重复处理
				//注意判断返回金额
				
				//------------------------------
				//处理业务完毕
				//------------------------------	
				
				//调用doShow, 打印meta值跟js代码,告诉财付通处理成功,并在用户浏览器显示$show页面.
				$show = "http://localhost/tenpay/show.php";
				$resHandler->doShow($show);
			
			} else {
				//当做不成功处理
				echo "<br/>" . "支付失败" . "<br/>";
			}
			
		} else {
			echo "<br/>" . "认证签名失败" . "<br/>";
		}
	}
	

	
}

?>