<?php

class keke_db {
	private $_db_provider;
	private $_dbtype;
	public $_mydb;
	private static $dbs = array ();
	public static function &get_instance($dbtype = "mysql") {
		static $obj = null;
		! is_object ( $obj ) && $obj = new keke_db ( $dbtype );
		return $obj;
	}
	function __construct($dbtype = "mysql") {
		if (is_object ( self::$dbs [$dbtype] )) {
			$this->_mydb = self::$dbs [$dbtype];
		} else {
			$this->_mydb = $this->create ( $dbtype );
		}
	}
	
	public function create($dbtype) {
		if (is_object ( self::$dbs [$dbtype] )) {
			return self::$dbs [$dbtype];
		} else {
			
			switch ($dbtype) {
				case "odbc" :
					$this->_dbtype = $dbtype;
					if (empty ( self::$dbs [$dbtype] )) {
						kekezu::keke_require_once ( S_ROOT . '/base/db_factory/odbc_driver.php' );
						return self::$dbs [$dbtype] = new odbc_driver ();
					} else {
						return self::$dbs [$dbtype];
					}
					break;
				case "pdo_sqlite" :
					$this->_dbtype = "pdo_sqlite";
					kekezu::keke_require_once ( S_ROOT . '/base/db_factory/sqlite_driver.php' );
					break;
				default :
					$this->_dbtype = $dbtype;
					if (empty ( self::$dbs [$dbtype] )) {
						kekezu::keke_require_once ( S_ROOT . '/base/db_factory/mysql_driver.php' );
						return self::$dbs [$dbtype] = new mysql_drver ();
					} else {
						return self::$dbs [$dbtype];
					}
					
					break;
			}
		}
	
	}
	
	/**
	 * ͨò滻ݷ
	 *
	 * @param string $tablename
	 * @param array $insertsqlarr  
	 * @param int $returnid
	 * @param boolean $replace
	 * @return int lastinsert_id
	 */
	public function inserttable($tablename, $insertsqlarr, $returnid = 0, $replace = false) {
		return $this->_mydb->insert ( $tablename, $insertsqlarr, $returnid, $replace );
	}
	/**
	 * ͨݸ·
	 *
	 * @param string $tablename
	 * @param array $setsqlarr
	 * @param array $wheresqlarr
	 * @return int $affectrows
	 */
	public function updatetable($tablename, $setsqlarr, $wheresqlarr) {
		return $this->_mydb->update ( $tablename, $setsqlarr, $wheresqlarr );
	}
	/**
	 * ִsql
	 *
	 * @param string $sql
	 * @return ִӰ
	 */
	public function execute($sql) {
		$res = $this->_mydb->execute ( $sql );
		return $res ? $res : 0;
	}
	public function get_query_num() {
		return $this->_mydb->get_query_num ();
	}
	public function select($fileds = '*', $table, $where = '', $order = '', $group = '', $limit = '', $pk = '') {
		return $this->_mydb->select ( $fileds, $table, $where, $order, $group, $limit, $pk );
	}
	public function getCount($sql, $row = 0, $filed = null) {
		return $this->_mydb->getCount ( $sql, $row, $filed );
	}
	public function get_one($sql) {
		return $this->_mydb->get_one_row ( $sql );
	}
	public function query($sql, $is_unbuffer = 0) {
		return $this->_mydb->query ( $sql, $is_unbuffer );
	}
	public function __destruct() {
		$this->_mydb->close ();
	}

}
class db_factory {
	
	private static $db_obj = null;
	
	public static function init($dbtype = 'mysql') {
		$db_obj = &keke_db::get_instance ( $dbtype );
		return self::$db_obj = $db_obj;
	}
	public static function execute($sql) {
		self::init ();
		return self::$db_obj->execute ( $sql );
	
	}
	public static function query($sql, $is_cache = 0, $cache_time = 0, $is_unbuffer = 0) {
		$id = TABLEPRE . substr ( md5 ( $sql ), 0, 6 );
		if ($is_cache) {
			$keke_cache = new keke_cache_class ( CACHE_TYPE );
			$result = $keke_cache->get ( $id );
			if ($result === null || $result === false) {
				self::init ();
				$result = self::$db_obj->query ( $sql, $is_unbuffer );
				if (is_null ( $cache_time ) || intval ( $cache_time ) > 0) {
					empty ( $result ) and $result = array ();
					$keke_cache->set ( $id, $result, $cache_time );
				}
				return $result;
			} else {
				return $result;
			}
		} else {
			$db = self::init ();
			return $db->query ( $sql, $is_unbuffer );
		}
	
	}
	public static function inserttable($tablename, $insertsqlarr, $returnid = 1, $replace = false) {
		$db = self::init ();
		$result = $db->inserttable ( $tablename, $insertsqlarr, $returnid, $replace );
		return $result == 0 ? true : $result;
	}
	public static function updatetable($tablename, $setsqlarr, $wheresqlarr) {
		$db = self::init ();
		return $db->updatetable ( $tablename, $setsqlarr, $wheresqlarr );
	}
	public static function create($dbtype = "mysql") {
		return self::init ( $dbtype );
	}
	/**
	 * һһά
	 * @param string $sql
	 */
	public static function get_one($sql) {
		$db = self::init ();
		return $db->get_one ( $sql );
	}
	/**
	 * ָеֵֶָûûָĬȡһеĵһֶ
	 * @param string $sql
	 * @param int $row   
	 * @param string $filed  ֶ
	 */
	public static function get_count($sql, $row = 0, $filed = null) {
		$db = self::init ();
		return $db->getCount ( $sql, $row, $filed );
	}
}

?>