/*----------------------------------------------------------------------------|
|  Subject:       JavaScript validation API,Form auto Validation API
|  Version:       1.0
|  Author:        Sunarrow
|  Created:       2007-11-8
|  LastModified:  2008-1-20
|  Download:      http://code.google.com/p/cwin/downloads/list
|  License:       Apache License 2.0
|-----------------------------------------------------------------------------|
|  Email:sunkeei@yahoo.com
|-----------------------------------------------------------------------------|
|1.ֶ֤
|      ǩvalidElement(element).
|      ܣ֤ʧܣfalseʾҳϢ
|      ˵element:HTMLԪأҳϵô˷ʱʹ 'this'á
|                limit:֤磺'type:float;required:true;decLen:2'
|                      limitԿ: type,required,len,between,decLen,
|                                         equals,general
|                      ˵:
|						 type:string,int,digit,float,email,ip,url,date,datetime,time
|                             tel,fax,mobileCn,idCard,signName,name,postcodeCn
|                             default: string.
|                        required:ѡֵtruefalse.default:false.
|                        len:ַ,ֵΪ "6-20",ʾ620֮䡣Ҳ
|                             Ϊ"-20"ʾ20
|						 between:ֵЧ,ֵ֮䡣Ϊ "10-100"ʾ
|                                С1000֮䣬ҲΪ"-100",ʾС100
|                        decLen:;ȳ.ϾȽԶ.
|                        equals:ǷҪԪȡȷϵȳ.
|                        general:Ƿһַַ.Default:true.
|                msgArea:ʾϢSPANDIVIDΪգ
|                        global_error_msg_area SPANDIVҲΪգ
|                        alert ЩϢ
|                msg:ϢΪ""ĬϵĴϢ.
|2.Զ֤:
|      ǩcheckForm(form,isCheckAll)
|      isCheckAll:ǷеԪأΪFalse,֤ڵһʱ˳򣬻֤еԪ
|      ܣ֤Ҫֶ֤.ʧܷfalse.ʾϢ.
|      ʹҪ֤ԪҪ limit ԣԶҪ֤Ԫء
|ʾ:ҪѴϢʾĳһĵطԶһIDΪ global_error_msg_area DIVSPAN
|   ֤ĬַԼ general:false ȡ
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
|  Subject:       JavaScript validation API
|֤API
|֤б
|
|judgeDigit(arguments...) :жǷ
|ֵ÷ʽ:
|1.һ,жǷΪ,Ȳ10λ
|2.,ڶΪ '>'()  '<'(С),3ΪҪȽϵ
|3.ڶΪжϴĵһֵǷм.(߽)
|
|judgeFloat(arguments...):
|һôжǷΪ
|ôڶΪ޶
|ôڶΪСֵǽΪֵ
|
|isDigit(str):Ƿ
|
|isSignName(arguments...)
|ֵ÷ʽ
|һ(ĬΪ2--32λ)жϱʶǵ¼
|жϱʶǵ¼ĸͷ,ɴ֡"_""." ִ
|
|޶С(ڶ)󳤶()
|
|isRealName(str) :жǷʵ
|isTel(str) :绰:⣬ɺ"-".Уͨ绰⣬"-"ոֿ
|isMobileCN(s) :й½ֻ,1315ͷʹʱݱ仯޸,
|isPostalCodeCN(s):йʱ
|isEmail(s) :E-mail
|isURL(s) :URL
|isIP(s):IP-32
|isHtmlTag(s):HTML Tag
|isIDNumber15(s):֤15λ
|isIDNumber18(s):֤18λ
|isChineseString(s):ַ
|isDoubleByteString(s):˫ֽ
|hasHESpace(s):ǷβոTRUE
|isQQ(s):QQ
|isFloat(s):ǷǸ
|isLeapYear(y):Ƿ
|isDateYMD(s):ڣyyyy-mm-dd  yyyy/mm/dd,֧1600Ժ(֤)
|isDateDMY(s):ڣdd-mm-yyyy  dd/mm/yyyy,֧1600Ժ(֤)
|isDateMDY(s):ڣmm/dd/yyyy  mm-dd-yyyy,֧1600Ժ(֤)
|isDateTimeYMD(s):ڣyyyy/mm/dd hh:mm:ss  yyyy-mm-dd hh:mm:ss,֧1600Ժ(֤)
|
|containsSpecialChar()
|Ƿַ(ַĸ,»,͵,ո,@#$% ˫ֽ),true
|
|·ĵ÷:
|1.һƳ
|2.ڶʾСȣʾ󳤶
|
|isDigitString():
|isLetter():ĸ
|isUpperLetter():дĸ
|isLowerLetter():Сдĸ
|isLetterNumString():ĸ
|isLNUString() :֣ĸ»ַ
|
|:IE6.0Firefox2.0²ͨ
|License:Apache license2.0.ʹô˴ʱlicenseϢ.
\*-----------------------------------------------------------------------------------------*/
var global_formjs_valid_flag = false;		//ȫֵǷı
var error_msg_span = null; //ʾSPANDIV
/***
* Ԫ
* @param form 
* @param checkAll ǷԪ(Ϊfalseڵһ־ͻ˳)򽫼Ԫ
* **/
function checkForm(form,checkAll){
	error_msg_span = document.getElementById("global_error_msg_area");
	//clear err msg
	if (error_msg_span != undefined && error_msg_span != null) {
		error_msg_span.innerHTML = "";
	}
 	var eles = form.elements;
	var hasError = false;
    //бԪ
 	for(var i=0;i<eles.length;i++){
        //ȡԪdeclare
		var limit = eles[i].getAttribute("limit");
		if(limit != null && limit != ""){
			if(checkAll){
				validElement(eles[i]);
				if(!global_formjs_valid_flag){
					hasError = true;
				}
			}else{
				if(!validElement(eles[i])){
					eles[i].focus();
					return false;
				}
			}
		}
	}
	return !hasError;
}
/**
*ִ󷵻FALSE
*/
function validElement(ele){
	error_msg_span = document.getElementById("global_error_msg_area");
	//Լ
	var limit = ele.getAttribute("limit");
	if(limit == null || trim(limit) == "") return;
	limit = trim(limit);
	var msgSpan = ele.getAttribute("msgArea");
	if(msgSpan != null) msgSpan = trim(msgSpan);
	var errMsg = ele.getAttribute("msg");
	if(errMsg != null) errMsg = trim(errMsg);
	//ȫֱ
	global_formjs_valid_flag = false;
	//preparing----
	var form = ele.form;
	var formName = form.name;
	//alert(ele.form.name);
	if(msgSpan != null || msgSpan != ""){
		msgSpan = document.getElementById(msgSpan);
		if(msgSpan == null){
			msgSpan = error_msg_span;
		}
	}else{
		msgSpan = error_msg_span;
	}

	if(msgSpan != undefined && msgSpan != null){
		msgSpan.innerHTML = "";
	}
	//ôϢ
	var setErrMessage = function(ele,error_msg){
		errMsg = (errMsg == null || errMsg == "") ? ele.name+" input error:" + error_msg : errMsg;
		if(msgSpan !=undefined  && msgSpan != null){
			msgSpan.innerHTML = "";
			msgSpan.innerHTML = errMsg;
		}else{
			alert(errMsg);
		}
		return false;
	};
	// prepared....
	//Ϣ
	//limitϢȡҪϢ֮ -- Ƿ
	var vtype = "string";			//ֵ
	var required = false;	//Ƿ
	var general = false;		//Ƿһַ(ַ)
	var lims = limit.split(";");		//б
	for(var ii = 0;ii<lims.length;ii++){
		if(lims[ii].indexOf(":")>0){
			var alim = lims[ii].split(":");
			if(alim[0] == 'type'){
				vtype = alim[1];
			}else if(alim[0] == 'required'){
				required = alim[1] == "true";
			}else if(alim[0] == 'general' && alim[1] == 'false'){
				general = false;
			}
		}else{
			alert("Element config error!")
			return false;
		}
	}
	//ֵ
	var valu = ele.value;
	//ǷΪ
	var isNull = (valu == undefined) || (valu == "");
	//ж -- Ϊնʵǿգ򷵻
	if(required && isNull){
		return setErrMessage(ele," can't be null.");
	}else if(!isNull){
		//=============================ͼ========================//
		//=============================ͼ========================//
		//
		switch(vtype){
            //
			case "int":
				if(!isDigit(valu)){
					return setErrMessage(ele," must be int.");
				}
				break;
			case "digit":
				if(!isDigitString(valu)){
					return setErrMessage(ele," must be digit.");
				}
				break;
			case "float":
				if(!isFloat(valu)){
					return setErrMessage(ele," must be float.");
				}
				break;
			case "date":
				if(!isDateYMD(valu)){
					return setErrMessage(ele," must be date.");
				}
				break;
			case "datetime":
				if(!isDateTimeYMD(valu)){
					return setErrMessage(ele," must be datetime.");
				}
				break;
			case "time":
				if(!isTime(valu)){
					return setErrMessage(ele," must be time.");
				}
				break;
			case "tel":
			case "fax":
				if(!isTel(valu)){
					return setErrMessage(ele," must be tel or fax number.");
				}
				break;
			case "mobileCn":
				if(!isMobileCN(valu)){
					return setErrMessage(ele," must be Chinese");
				}
				break;
			case "ip":
				if(!isIP(valu)){
					return setErrMessage(ele," must be IP.");
				}
				break;
			case "url":
				if(!isURL(valu)){
					return setErrMessage(ele," must be URL.");
				}
				break;
			case "idCard":
				if(!(isIDNumber15(valu) || isIDNumber18(valu))){
					return setErrMessage(ele," must be Chinese IDCard number.");
				}
				break;
			case "email":
				if(!isEmail(valu)){
					return setErrMessage(ele," must be Email address.");
				}
				break;
			case "signName":
				if(!isSignName(valu)){
					return setErrMessage(ele," must be sign name:character,number,underline,point.The first char must be character.");
				}
                break;
            case "name":
				if(!isRealName(valu)){
					return setErrMessage(ele," must be real name:Double byte character or single byte character. or space,point.");
				}
				break;
			case "postcodeCn":
				if(!isPostalCodeCN(valu)){
					return setErrMessage(ele," must be valid postcode.");
				}
				break;
			case "string":
				break;
			default:
				alert("Ԫ" + ele.name + "ֵ:" + vtype);
				return false;
		}
		//=============================ͼ========================//
		//============================Ƽ=======================//
		if(lims != null){
			for(var i = 0;i<lims.length;i++){
				var lim = lims[i].split(":");
				if(lim.length != 2){
					alert("attrribute limit config error.");
					return false;
				}
				if(lim[0] == "len"){	//ȼ飬ʲôͣ˳Ⱦͼ
					var lenDesc = lim[1];
					//alert(lim[1]);
					if(lenDesc.indexOf("-") > -1){
						var als = lenDesc.split("-");
						if(als.length == 2){
							if(als[0] == ""){
								if(valu.length > parseInt(als[1])){
									return setErrMessage(ele," can't more than " + als[1]);
								}
							}else if(als[1] == ""){
								if(valu.length < parseInt(als[0])){
									return setErrMessage(ele," can't less than " + als[0]);
								}
							}else if(valu.length < parseInt(als[0]) || valu.length > parseInt(als[1])){
								return setErrMessage(ele," must between " + als[0] + " and " + als[1]);
							}
						}else{
							alert("Element" + ele.name + " config error.");
							return false;
						}
					}else{
						if(valu.length != parseInt(lenDesc)){
							return setErrMessage(ele," the length must be " + lenDesc);
						}
					}
				//޶ֵ,intfloat
				}else if(lim[0] == "between" && lim[1].indexOf("-") > -1 && (vtype=="float" || vtype=="int")){
					var ls = lim[1].split("-");
					var fv = parseFloat(valu);
					//û
					if(ls[0] == ""){
						if(fv > parseFloat(ls[1])){
							return setErrMessage(ele," can't more than " + ls[1]);
						}
					}else if(ls[1] == ""){	//û
						if(fv < parseFloat(ls[0])){
							return setErrMessage(ele," can't less than " + ls[0]);
						}
					}else{
						if(fv < parseFloat(ls[0]) || fv > parseFloat(ls[1])){
							return setErrMessage(ele," must between " + ls[0] + " and " + ls[1]);
						}
					}
				}else if(lim[0] == "decLen" && vtype=="float"){	//
					if((valu.length - valu.indexOf(".")) > parseInt(lim[1])){
						//ת
						var precision = Math.pow(10, parseInt(lim[1]) || 0);
						ele.value = Math.round(parseFloat(valu) * precision) / precision;
					}
				}else if(lim[0] == "equals"){
					//ǷҪȵԪֵ
					var oevalue = eval("document." + formName + "." + lim[1] + ".value");
					if(oevalue != valu){
						return setErrMessage(ele," not match element " + lim[1] + "'s value.");
					}
				}
			}
		}
		//ַ
		if(general && vtype=='string'){
			if(containsSpecialChar(valu)){
				return setErrMessage(ele," can't allow contains special character.");
			}
		}
	}
	//============================Ƽ=======================//
	global_formjs_valid_flag = true;
	return true;
}
/**
 * Ϣ
 * @param divid
 */
function clearMsgArea(divid){
    var msgSpan = document.getElementById(divid);
    if(msgSpan != undefined && msgSpan != null){
		msgSpan.innerHTML = "";
	}
}

/*ȥո*/
function trim(str){
	return str.replace(/^\s+|\s+$/g, '');
}

/**
*   жǷ
*   ֵ÷ʽ:
*	1.һ,жǷΪ,Ȳ10λ
*	2.,ڶΪ '>'()  '<'(С),3ΪҪȽϵ
*	3.ڶΪжϴĵһֵǷм䡣߽磩
*/
function judgeDigit(){
	var s = arguments[0];
	if(arguments.length == 1){
		return isDigit(s);
	}else if(arguments.length == 3){
		//֤ͨ
		var patrn=/^-?[0-9]{1,10}$/;
		if(patrn.test(s)){
			var p1 = arguments[1];
			var sint = parseInt(s);
			if(isDigit(arguments[2])){
				var pint = parseInt(arguments[2]);
				if(p1 == '>' || p1 == '<'){
					if(p1 == '>'){
						return sint > pint;
					}else if(p1 == '<'){
						return sint < pint;
					}
				}else if(isDigit(p1)){
					var pmin = parseInt(p1);
					return (sint >= pmin) && (sint <= pint);
				}else{
					alert('arguments error,the 2nd argument is not a number and not an operation:greater|less|equals.');
				}
			}else{
				alert('arguments error,the 3rd argument is not a number.');
			}
		}
	}
	return false;
}
/**
*Ƿ
*/
function isDigit(s){
	var patrn=/^-?[0-9]{1,10}$/;
	return patrn.test(s);
}

/**
* жϱʶǵ¼ĸͷ,ɴ֡"_""." ִ
* ޶С(ڶ)󳤶()(ĬΪ2--32λ)
* @param string
* @param min length
* @param max length
*/
function isSignName(){
	var s = arguments[0];
	if(arguments.length == 1){
		var patrn=/^[a-zA-Z]{1}([a-zA-Z0-9]|[._]){1,31}$/;
		return patrn.test(s);
	}else if(arguments.length == 3){
		if(isDigit(arguments[1]) && isDigit(arguments[2])){
			eval("var patrn=/^[a-zA-Z]{1}([a-zA-Z0-9]|[._]){" + (parseInt(arguments[1]) - 1) + "," + (parseInt(arguments[2]) - 1) + "}$/;");
			return eval("patrn.test(s);");
		}else{
			alert('Error:the 2nd argument and the 3rd argument must be number.');
			return false;
		}
	}else{
		alert('method invoke error.error arguments number.');
		return false;
	}
}
/**
*жǷʵ
*/
function isRealName(s){
	var patrn = /^([a-zA-Z0-9]|[._ ]){2,64}$/;		//Ӣ
	var p2 = /^([^\x00-\xff]|[\s]){2,32}$/;		//˫ֽ
	return patrn.test(s) || p2.test(s);
}

/**
* 绰
* ֿͷ⣬ɺ"-"
**/
function isTel(s){
	var patrn=/^[+]{0,1}(\d){1,3}[ ]?([-]?((\d)|[ ]){1,12})+$/;
	return patrn.test(s);
}

/**
* й½ֻ
* 1315ͷʹʱݱ仯޸
* Уͨ绰⣬"-"ոֿ
**/
function isMobileCN(s){
	var patrn = /^1[3|5]{1}[0-9]{1}[-| ]?\d{8}$/;
	return patrn.test(s);
}

/**
* йʱ
***/
function isPostalCodeCN(s){
	var patrn=/^[1-9]\d{5}$/;
	return patrn.test(s);
}
/**Emai*/
function isEmail(s){
	var patrn = /^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/;
	return patrn.test(s);
}

/**URL*/
function isURL(s){
	var patrn = /^http:\/\/([\w-]+(\.[\w-]+)+(\/[\w-   .\/\?%&=\u4e00-\u9fa5]*)?)?$/;
	return patrn.test(s);
}
/**
* IP
**/
function isIP(s) {
	var patrn=/^((1?\d?\d|(2([0-4]\d|5[0-5])))\.){3}(1?\d?\d|(2([0-4]\d|5[0-5])))$/;
	return patrn.test(s);
}
/**
*Ƿʽ
*ֻпʼƥΪTRUE
*HTML Tag
*/
function isHtmlTag(s){
	var patrn = /^<(.*)>.*<\/\1>|<(.*) \/>$/;
	return patrn.test(s);
}
/**
*֤
*ʡ뻹ûж
*15λ
*/
function isIDNumber15(s){
	var patrn=/^[\d]{6}((\d{2}((0[13578]|1[02])(0[1-9]|[12]\d|3[01])|(0[13456789]|1[012])(0[1-9]|[12]\d|30)|02(0[1-9]|1\d|2[0-8])))|([02468][048]|[13579][26])0229)[\d]{3}$/;
	return patrn.test(s);
}
/**
*֤
*ʡ뻹ûж
*18λ
*/
function isIDNumber18(s){
	var patrn = /^[\d]{6}[0-9]{4}(((0[13578]|(10|12))(0[1-9]|[1-2][0-9]|3[0-1]))|(02(0[1-9]|[1-2][0-9]))|((0[469]|11)(0[1-9]|[1-2][0-9]|30)))[\d]{3}[\d|x|X]$/;
	return patrn.test(s);
}

/**
*
*/
function isChineseString(s){
	var patrn = /^[\u4e00-\u9fa5]+$/
	return patrn.test(s);
}
/**
*˫ֽ
*/
function isDoubleByteString(s){
	var patrn = /^[^x00-xff]+$/;
	return patrn.test(s);
}
/**
*ǷβոTRUE
*/
function hasHESpace(s){
	var patrn = /^\s+|\s+$/;
	return patrn.test(s);
}
/**
*	QQ10λС5λ
*/
function isQQ(s){
	var patrn=/^[1-9]{1}\d{4,9}$/;
	return patrn.test(s);
}
/**
*
*	һôжǷΪ
*	ôڶΪ޶
*	ôǽΪֵ
*/
function judgeFloat(){
	if(arguments.length == 1){
		return isFloat(arguments[0]);
	}else if(arguments.length == 2){
		eval("var patrn = /^-?\\d+.?\\d{0," + arguments[1] + "}$/;");
		return eval("patrn.test(arguments[0]);");
	}else if(arguments.length == 4){
		var a3 = arguments[2];
		if(a3 == '>' || a3 == '<'){
			if(isFloat(arguments[3])){
				eval("var patrn = /^-?\\d+.?\\d{0," + arguments[1] + "}$/;");
				if(eval("patrn.test(arguments[0]);")){
					if(a3 == '<'){
						if(parseFloat(arguments[0]) < parseFloat(arguments[3])) return true;
					}else{
						if(parseFloat(arguments[0]) > parseFloat(arguments[3])) return true;
					}
				}
				return false;
			}
		}else if(isFloat(a3)){
			eval("var patrn = /^-?\\d+.?\\d{0," + arguments[1] + "}$/;");
				if(eval("patrn.test(arguments[0]);")){
					var f0 = parseFloat(arguments[0]);
					var f3 = parseFloat(arguments[2]);
					var f4 = parseFloat(arguments[3]);
					return f0 >= f3 && f0 <= f4;
				}else{
					return false;
				}
		}else{
			alert('the 3rd and the 4th arguments are not number.');
			return false;
		}
	}
	return false;
}
/**
*ǷǸ
**/
function isFloat(s){
	var patrn = /^-?\d*.?\d+$/;
	return patrn.test(s);
}
/**
*Ƿ
**/
function isLeapYear(y){
	return (y % 4 == 0 && y % 100 != 0) || y % 400 == 0;
}
/**
*
*yyyy-mm-ddʽyyyy/mm/ddʽλʾ
*Regex author:Michael Ash
*֧1600Ժ
*/
function isDateYMD(s){
	var patrn = /^(?:(?:(?:(?:(?:1[6-9]|[2-9]\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00)))(\/|-|\.)(?:0?2\1(?:29)))|(?:(?:(?:1[6-9]|[2-9]\d)?\d{2})(\/|-|\.)(?:(?:(?:0?[13578]|1[02])\2(?:31))|(?:(?:0?[1,3-9]|1[0-2])\2(29|30))|(?:(?:0?[1-9])|(?:1[0-2]))\2(?:0?[1-9]|1\d|2[0-8]))))$/;
	return patrn.test(s);
}
/**
*
*dd-mm-yyyyʽdd/mm/yyyyʽλʾ
*Regex author:Marco Storti
*֧1600Ժ
*/
function isDateDMY(s){
	var patrn = /^(?:(?:31(\/|-|\.)(?:0?[13578]|1[02]))\1|(?:(?:29|30)(\/|-|\.)(?:0?[1,3-9]|1[0-2])\2))(?:(?:1[6-9]|[2-9]\d)?\d{2})$|^(?:29(\/|-|\.)0?2\3(?:(?:(?:1[6-9]|[2-9]\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))$|^(?:0?[1-9]|1\d|2[0-8])(\/|-|\.)(?:(?:0?[1-9])|(?:1[0-2]))\4(?:(?:1[6-9]|[2-9]\d)?\d{2})$/;
	return patrn.test(s);
}
/**
*
*mm-dd-yyyyʽmm/dd/yyyyʽλʾ
*Regex author:Michael Ash
*֧1600Ժ
*/
function isDateMDY(s){
	var patrn =  /^(?:(?:(?:0?[13578]|1[02])(\/|-|\.)31)\1|(?:(?:0?[13-9]|1[0-2])(\/|-|\.)(?:29|30)\2))(?:(?:1[6-9]|[2-9]\d)?\d{2})$|^(?:0?2(\/|-|\.)29\3(?:(?:(?:1[6-9]|[2-9]\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))$|^(?:(?:0?[1-9])|(?:1[0-2]))(\/|-|\.)(?:0?[1-9]|1\d|2[0-8])\4(?:(?:1[6-9]|[2-9]\d)?\d{2})$/;
	return patrn.test(s);
}
/**
*ʱ䣺M/d/y hh:mm:ss
*Regex author:Michael Ash
*֧1600Ժ
*/
function isDateTimeMDY(s){
	var patrn = /^(?=\d)(?:(?:(?:(?:(?:0?[13578]|1[02])(\/|-|\.)31)\1|(?:(?:0?[1,3-9]|1[0-2])(\/|-|\.)(?:29|30)\2))(?:(?:1[6-9]|[2-9]\d)?\d{2})|(?:0?2(\/|-|\.)29\3(?:(?:(?:1[6-9]|[2-9]\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))|(?:(?:0?[1-9])|(?:1[0-2]))(\/|-|\.)(?:0?[1-9]|1\d|2[0-8])\4(?:(?:1[6-9]|[2-9]\d)?\d{2}))($|\ (?=\d)))?(((0?[1-9]|1[012])(:[0-5]\d){0,2}(\ [AP]M))|([01]\d|2[0-3])(:[0-5]\d){1,2})?$/;
	return patrn.test(s);
}
/**
*ʱ yyyy/mm/dd hh:mm:ss  yyyy-mm-dd hh:mm:ss
*Date Regex author:Michael Ash
*Modified by Shaw Sunkee
*֧1600Ժ
*/
function isDateTimeYMD(s){
	var patrn = /^(?:(?:(?:(?:(?:1[6-9]|[2-9]\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00)))(\/|-|\.)(?:0?2\1(?:29)))|(?:(?:(?:1[6-9]|[2-9]\d)?\d{2})(\/|-|\.)(?:(?:(?:0?[13578]|1[02])\2(?:31))|(?:(?:0?[1,3-9]|1[0-2])\2(29|30))|(?:(?:0?[1-9])|(?:1[0-2]))\2(?:0?[1-9]|1\d|2[0-8]))))[ ]([0-1]?[0-9]|[2][0-3]):([0-5]?[0-9]):([0-5]?[0-9])$/;;
	return patrn.test(s);
}
/**
*ʱ
*hh:mm:ss 24Сʱ 0 ~ 23 hour
*/
function isTime(s){
	var patrn = /^([0-1]?[0-9]|[2][0-3]):([0-5]?[0-9]):([0-5]?[0-9])$/;
	return patrn.test(s);
}

/**
*	Ƿַ(ַĸ֣»ߣ͵ţո@#$% ˫ֽ)
*	 true
*/
var validation_specialChars = new Array('\'','\"','\n','\r','\t',';',':','=','<','>',',','|','\\','<','>','/','^','~','`');
function containsSpecialChar(str){
	for(var i = 0;i<validation_specialChars.length;i++){
		if(str.indexOf(validation_specialChars[i]) > -1){
			return true;
		}
	}
	return false;
}
/**
*	жǷΪִ(ڴǰ"-"ţ磺-123)
*	ֵ÷ʽ:
*	1.һƳ
*	2.ڶʾСȣʾ󳤶
*/
function isDigitString(){
	return judgePattrnAndLen("-?\\d",arguments);
}
/**ĸ
*	ֵ÷ʽ
*	һһҪֵ֤
*	Ǵڶ͵ֱСȺ󳤶
*/
function isLetter(){
	return judgePattrnAndLen("[A-Za-z]",arguments);
}

/**
*	дĸ
*	ֵ÷ʽ
*	һһҪֵ֤
*	Ǵڶ͵ֱСȺ󳤶
*/
function isUpperLetter(){
	return judgePattrnAndLen("[A-Z]",arguments);
}
/**
*	Сдĸ
*	ֵ÷ʽ
*	һһҪֵ֤
*	Ǵڶ͵ֱСȺ󳤶
*/
function isLowerLetter(){
	return judgePattrnAndLen("[a-z]",arguments);
}
/**ַ*/
function isLetterNumString(){
	return judgePattrnAndLen("[A-Za-z0-9]",arguments);
}
/**֣ĸ»ַ*/
function isLNUString(s){
	return judgePattrnAndLen("\\w",arguments);
}
/**
*һ򵥵ʽҪжֵ޶СȺ󳤶
**/
function judgePattrnAndLen(){
	var pat = arguments[0];
	var as = arguments[1];
	if(as == null || as == undefined || as.length == 0){
		alert('no arguments.');
		return false;
	}else if(as.length == 1){
		eval("var patrn= /^" + pat + "+$/;");
		return eval("patrn.test(as[0]);");
	}else if(as.length == 3){
		if(isDigit(as[1]) && isDigit(as[2])){
			eval("patrn =" + "/^" + pat + "{" + as[1] + "," + as[2] + "}$/;");
			return eval("patrn.test(as[0]);");
		}else{
			alert('error arguments:the 2nd argument and the 3rd argument must be number.');
			return false;
		}
	}else{
		alert('error arguments number');
		return false;
	}
}