<?php 
require_once('weibooauth.php');

class sina_oauth_client_class extends base_client_class{
	public $_sina_weibo_oauth;
	public $_sina_weibo_client;
	
	function __construct($app_key,$app_secret){
		$this->_app_key = $app_key;
		$this->_app_secret = $app_secret;
		parent::__construct($app_key,$app_secret);
		$this->_sina_weibo_oauth = new WeiboOAuth( $app_key,$app_secret);
	}
	
	
	//Ȩӵ
	function get_auth_url($callback){
		$this->_error_info = null;
		$o = $this->_sina_weibo_oauth;
		$keys = $o->getRequestToken();
		$aurl = $o->getAuthorizeURL( $keys['oauth_token'] ,false,$callback);
		
		$_SESSION['auth_sina']['keys'] = $keys;
		return $aurl;
	}
	
	//֤ǷȨ
	function get_access_token(){
		return $_SESSION['auth_sina']['last_key'];
	}
	
	//Ȩ
	function clear_access_token(){
		$this->init_client();
		$c = $this->_sina_weibo_client;
		$r = $c->oauth->get('http://api.t.sina.com.cn/account/end_session.json',null);
		unset($_SESSION['auth_sina']);
		
	}
	
	//ͨȨ
	function create_access_token($oauth_verifier=false){
		$this->_error_info = null;
		$o = $this->_sina_weibo_oauth;
		$o->__construct($this->_app_key,$this->_app_secret,$_SESSION['auth_sina']['keys']['oauth_token'] ,$_SESSION['auth_sina']['keys']['oauth_token_secret'] );
		
		$last_key = $o->getAccessToken($oauth_verifier,$oauth_token) ;
		
		if (!$last_key['user_id']){
			$this->set_error('access_tokenڻѹ');
			return false;
		}
		//last_key 
		$_SESSION['auth_sina']['last_key'] = $last_key;
		
		//client  ˺ʹsinaٷصclient
		
		$this->init_client();
		return $last_key['user_id'];
	}
	
	private function init_client(){
		if (!$this->_sina_weibo_client){
		$this->_sina_weibo_client = new WeiboClient($this->_app_key,$this->_app_secret, $_SESSION['auth_sina']['last_key']['oauth_token'] ,$_SESSION['auth_sina']['last_key']['oauth_token_secret']);
		}
		
	}
	//õǰ¼û
	function get_login_info(){
		global $_K;
		$this->init_client();
		$c = $this->get_client();
		$auth_user_info  = $c->show_user($_SESSION['auth_sina']['last_key']['user_id']);
		
		
		if (strtolower($_K['charset'])=='gbk'){
			$auth_user_info = kekezu::utftogbk($auth_user_info);
		}
		
		if ($auth_user_info['error']){
			unset($_SESSION['auth_sina']);
			$this->set_error('ûݻȡʧܣ:'.$auth_user_info['error']);
			return false;
		}
		
		return $auth_user_info;
	}
	
	//΢
	function post_wb($msg,$img){
		$this->_error_info = null;
		$this->init_client();
		$c = $this->get_client();
		
		global $_K;
		
		if (strtolower($_K['charset'])=='gbk'){
			$msg = kekezu::gbktoutf($msg);
		}
		
		if (!$img){
			$r = $c->update($msg);
		}
		else {
			$r = $c->upload($msg,$img);
			//var_dump($r);
		}
		
		if (strtolower($_K['charset'])=='gbk'){
			$r = kekezu::utftogbk($r);
		}
		
		if ($r['error']){
			unset($_SESSION['auth_sina']);
			$this->set_error('ʧ:'.$r['error']);
			return false;
		}
		
		return $r['id'];
		
	}
	
	//ʱ
	function get_wb_list($page=0,$page_size=0){
		$this->_error_info = null;
		$this->init_client();
		$c = $this->get_client();	
	
		$page = $page?$page:1;
		$page_size = $page_size?$page_size:20;
		$r = $c->user_timeline($page,$page_size);
		
		global $_K;
		if (strtolower($_K['charset'])=='gbk'){
			$r = kekezu::utftogbk($r);
		}
		
		return $r;
	}
	
	function get_wb_info($sid){
		$this->_error_info = null;
		$this->init_client();
		$c = $this->get_client();	
		$r = $c->show_status($sid);
		
		global $_K;
		if (strtolower($_K['charset'])=='gbk'){
			$r = kekezu::utftogbk($r);
		}
		
		if ($r ['error']) {
			unset ( $_SESSION ['auth_sina'] );
			$this->set_error ( '΢Ϣȡʧ:' . $r ['error'] );
			return false;
		}
		
		return $r;
	}
	
	
	//UIDӹע
	function follow_wb_user($u_id){
		$this->_error_info = null;
		$this->init_client();
		$c = $this->get_client();	
		$r = $c->follow($u_id);
		
		global $_K;
		if (strtolower($_K['charset'])=='gbk'){
			$r = kekezu::utftogbk($r);
		}
			if ($r ['error']) {
			//unset ( $_SESSION ['auth_sina'] );
			$this->set_error (  $r ['error'] );
			return false;
		}
		return $r;
	}
	
	//SIDתһ΢
	function repost_wb($sid,$text=null){
		global $_K;
		$this->_error_info = null;
		$this->init_client();
		if(strtolower($_K['charset'])=='gbk'&&$text){
			$text = kekezu::gbktoutf($text);
		}
		$c = $this->get_client();
		$r = $c->repost($sid,$text);
		
		
		if (strtolower($_K['charset'])=='gbk'){
			$r = kekezu::utftogbk($r);
		}
		
		
		if ($r['error']) {
			//unset ( $_SESSION ['auth_sina'] );
			$this->set_error ( $r ['error'] );
			return false;
		}
		return $r['id'];
		
	}
	
	//SIDһ΢
	function send_comment($sid,$text=null){
		global $_K;
		$this->_error_info = null;
		$this->init_client();
		$c = $this->get_client();
		
		if(strtolower($_K['charset'])=='gbk'){
			$text = kekezu::gbktoutf($text);
		}
		
		$r = $c->send_comment($sid,$text);
		
		if (strtolower($_K['charset'])=='gbk'){
			$r = kekezu::utftogbk($r);
		}
		if ($r ['error']) {
			unset ( $_SESSION ['auth_sina'] );
			$this->set_error (  $r ['error'] );
			return false;
		}
		return $r;
	}
	
	
	//ûݸʽ
	function user_data_format($data){
		$r = array();
		$r['account'] = $data['id'];
		$r["name"]=$data['name'];
		$r["location"]=$data['location'];
		$r['img']=$data['profile_image_url'];
		$r['url']="http://t.sina.com.cn/{$data['id']}/";
		$r['fans_count']=$data['followers_count']; 
		$r['gz_count']=$data['friends_count'];
		$r['wb_count']=$data['statuses_count'];
		$r['sex'] = $data['gender']=='m'?'':$data['gender']=='f'?'Ů':'';
		return $r;
	}
	
	//΢ݸʽ
	function wb_data_format($data){
		$r = array();
		$r['id']=$data['id'];
		$r['text']=$data['text'];
		$r['uid']=$data['user']['id'];
		$r['username']=$data['user']['name'];
		$r['img'] = $data['bmiddle_pic'];
		$r['url']="http://api.t.sina.com.cn/{$r['uid']}/statuses/{$r['id']}";
		return $r;
	}
	
	function get_operate(){
		return $this->_sina_weibo_oauth;
	}
	
	function get_client(){
		return $this->_sina_weibo_client;
	}
}

