<?php
class TopClient {
	public $appkey;
	
	public $secretKey;
	
	public $gatewayUrl = "http://gw.api.taobao.com/router/rest";
	
	public $format = "json";
	public $_user_get_request_obj;
	
	public $_error;
	protected $signMethod = "md5";
	
	protected $apiVersion = "2.0";
	
	protected $sdkVersion = "top-sdk-php-20110701";
	function __construct() {
		require_once 'request/UserGetRequest.php';
		require_once 'logger/logger.php';
		$this->_user_get_request_obj = new UserGetRequest ();
	}
	protected function generateSign($params) {
		ksort ( $params );
		
		$stringToBeSigned = $this->secretKey;
		foreach ( $params as $k => $v ) {
			if ("@" != substr ( $v, 0, 1 )) {
				$stringToBeSigned .= "$k$v";
			}
		}
		unset ( $k, $v );
		$stringToBeSigned .= $this->secretKey;
		
		return strtoupper ( md5 ( $stringToBeSigned ) );
	}
	
	protected function curl($url, $postFields = null) {
		$ch = curl_init ();
		curl_setopt ( $ch, CURLOPT_URL, $url );
		curl_setopt ( $ch, CURLOPT_FAILONERROR, false );
		curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, true );
		
		if (is_array ( $postFields ) && 0 < count ( $postFields )) {
			$postBodyString = "";
			$postMultipart = false;
			foreach ( $postFields as $k => $v ) {
				if ("@" != substr ( $v, 0, 1 )) //жǲļϴ
{
					$postBodyString .= "$k=" . urlencode ( $v ) . "&";
				} else //ļϴmultipart/form-datawww-form-urlencoded
{
					$postMultipart = true;
				}
			}
			unset ( $k, $v );
			curl_setopt ( $ch, CURLOPT_POST, true );
			if ($postMultipart) {
				curl_setopt ( $ch, CURLOPT_POSTFIELDS, $postFields );
			} else {
				curl_setopt ( $ch, CURLOPT_POSTFIELDS, substr ( $postBodyString, 0, - 1 ) );
			}
		}
		$reponse = curl_exec ( $ch );
		
		if (curl_errno ( $ch )) {
			throw new Exception ( curl_error ( $ch ), 0 );
		} else {
			$httpStatusCode = curl_getinfo ( $ch, CURLINFO_HTTP_CODE );
			if (200 !== $httpStatusCode) {
				throw new Exception ( $reponse, $httpStatusCode );
			}
		}
		curl_close ( $ch );
		return $reponse;
	}
	/**
	 * ûϢת
	 */
	function process_user_oauth($top_sign, $top_appkey, $top_parameters, $top_session) {
		global $_K;
	/*	echo $top_sign."<br>";
		echo base64_encode((md5($top_appkey.$top_parameters.$top_session.$this->secretKey)))."<br>";
		echo base64_encode(md5($top_appkey.$this->secretKey));
		die();*/
		if ($top_sign) {
			$format_simple_data = $this->format_parameters ( $top_parameters );
			if ($format_simple_data ['vistor_role']) { //ûûе¼
				$this->_error = $this->error_handle ( 3 );
			} else if ($format_simple_data ['ts'] + 300 < time ()) {
				$this->_error = $this->error_handle ( 2 );
			} else { //ȡûϢ.
				$req = $this->_user_get_request_obj;
				$req->setFields ( "user_id,uid,nick,sex,buyer_credit,seller_credit,location,created,last_visit,birthday,type,status,alipay_no,alipay_account,alipay_account,email,consumer_protection,alipay_bind" );
				
				$req->setNick ( $format_simple_data ['vistor_nick'] );
				$resp = $this->execute ( $req, $top_session );
				if (! empty ( $resp )) {
					$user_data = $this->format_user_info ( $resp );
					$_SESSION['taobao_login_info']=$user_data;
					header ( "Location:" . $_K ['website_url'] . "/oauth_login.php?wb_type=taobao");
				} else {
					$this->_error = $this->error_handle ( 4 );
				}
			}
		} else {
			$this->_error = $this->error_handle ( 1 );
		}
	}
	/**
	 * ʽصĲ
	 * Enter description here ...
	 * @param unknown_type $parameters
	 */
	public function format_parameters($top_parameters) {
		$simple_data = explode ( "&", base64_decode ( $top_parameters ) );
		foreach ( $simple_data as $v ) {
			$v2 = explode ( "=", $v );
			$format_simple_data [$v2 [0]] = $v2 [1];
		}
		return $format_simple_data;
	
	}
	/**
	 * 
	 * ʽûϢ
	 */
	public function format_user_info($user_obj) {
		
		$user_data ['name'] = $user_obj->user->nick;
		$user_data ['account'] = $user_obj->user->user_id;
		$user_data ['uid'] = $user_obj->user->uid;
		return $user_data;
	}
	protected function logCommunicationError($apiName, $requestUrl, $errorCode, $responseTxt) {
		$localIp = isset ( $_SERVER ["SERVER_ADDR"] ) ? $_SERVER ["SERVER_ADDR"] : "CLI";
		$logger = new LtLogger ();
		$logger->conf ["log_file"] = rtrim ( TOP_SDK_WORK_DIR, '\\/' ) . '/' . "logs/top_comm_err_" . $this->appkey . "_" . date ( "Y-m-d" ) . ".log";
		$logger->conf ["separator"] = "^_^";
		$logData = array (date ( "Y-m-d H:i:s" ), $apiName, $this->appkey, $localIp, PHP_OS, $this->sdkVersion, $requestUrl, $errorCode, str_replace ( "\n", "", $responseTxt ) );
		$logger->log ( $logData );
	}
	
	public function execute($request, $session = null) {
		//װϵͳ
		$sysParams ["app_key"] = $this->appkey;
		$sysParams ["v"] = $this->apiVersion;
		$sysParams ["format"] = $this->format;
		$sysParams ["sign_method"] = $this->signMethod;
		$sysParams ["method"] = $request->getApiMethodName ();
		$sysParams ["timestamp"] = date ( "Y-m-d H:i:s" );
		$sysParams ["partner_id"] = $this->sdkVersion;
		if (null != $session) {
			$sysParams ["session"] = $session;
		}
		
		//ȡҵ
		$apiParams = $request->getApiParas ();
		
		//ǩ
		$sysParams ["sign"] = $this->generateSign ( array_merge ( $apiParams, $sysParams ) );
		
		//ϵͳGET
		$requestUrl = $this->gatewayUrl . "?";
		foreach ( $sysParams as $sysParamKey => $sysParamValue ) {
			$requestUrl .= "$sysParamKey=" . urlencode ( $sysParamValue ) . "&";
		}
		$requestUrl = substr ( $requestUrl, 0, - 1 );
		
		//HTTP
		try {
			$resp = $this->curl ( $requestUrl, $apiParams );
		} catch ( Exception $e ) {
			$this->logCommunicationError ( $sysParams ["method"], $requestUrl, "HTTP_ERROR_" . $e->getCode (), $e->getMessage () );
			return false;
		}
		
		//TOPؽ
		$respWellFormed = false;
		if ("json" == $this->format) {
			$respObject = json_decode ( $resp );
			if (null !== $respObject) {
				$respWellFormed = true;
				foreach ( $respObject as $propKey => $propValue ) {
					$respObject = $propValue;
				}
			}
		} else if ("xml" == $this->format) {
			$respObject = @simplexml_load_string ( $resp );
			if (false !== $respObject) {
				$respWellFormed = true;
			}
		}
		
		//صHTTPıǱ׼JSONXML´־
		if (false === $respWellFormed) {
			$this->logCommunicationError ( $sysParams ["method"], $requestUrl, "HTTP_RESPONSE_NOT_WELL_FORMED", $resp );
			return false;
		}
		
		return $respObject;
	}
	public function error_handle($err_id) {
		$error = array ("1" => "ȡȨʧ!", "2" => "¼ʱ!", "3" => "Ա¼ʧ!", "4" => "!ûϢȡʧ" );
		return $error [$err_id];
	}
}