<?php
/**
 * Enter description here ...
 * @author Administrator
 *
 */
class keke_prom_class {
	public $_prom_rule_config_info;
	public $_prom_relation_obj;
	public $_cpc_open;
	public $_cpc_cash;
	public $_reg_open;
	public $_auth_step;
	public static function get_instance() {
		static $obj = null;
		if ($obj == null) {
			$obj = new keke_prom_class ();
		}
		return $obj;
	}
	function __construct() {
		global $kekezu, $_K;
		$this->_prom_relation_obj = new Keke_witkey_prom_relation_class ();
		$this->prom_rule_config_init ();
		$this->check_cpc_reg_init ();
	}
	public function prom_rule_config_init() {
		$this->_prom_rule_config_info = kekezu::get_table_data ( '*', 'witkey_prom_rule', '', '', '', '', 'prom_code', null );
	}
	public function check_cpc_reg_init() {
		$cpc_info = db_factory::get_one ( "select is_open,cash from " . TABLEPRE . "witkey_prom_rule where prom_code='cpc'" );
		$this->_cpc_open = $cpc_info ['is_open'];
		$this->_cpc_cash = $cpc_info ['cash'];
		$reg = db_factory::get_one ( "select config,is_open from " . TABLEPRE . "witkey_prom_rule where prom_code='reg'" );
		$reg_config = unserialize ( $reg ['config'] );
		$this->_reg_open = $reg ['is_open'];
		$this->_auth_step = $reg_config ['auth_step'];
	}
	function url_data_format($query_string) {
		$format_data = array ();
		parse_str ( $query_string, $format_data );
		//($format_data ['o'] || $format_data ['e'] || $format_data ['t'] || $format_data ['p'] == 'pub_task') and $format_data ['r'] = 'temp' or $format_data ['r'] = 'long';
		$format_data ['r'] = 'long';
		$format_data ['p'] and $format_data ['p'] = $format_data ['p'] or $format_data ['p'] = 'reg';
		$format_data ['l'] and $format_data ['l'] = $format_data ['l'] or $format_data ['l'] = 'register';
		return $format_data;
	}
	function prom_relation_init($uid) {
		//ʼƹϵϢ
		$prom_relation_obj = new Keke_witkey_prom_relation_class ();
		$prom_relation_obj->setWhere ( "uid='$uid' and relation_status=1 limit 0,1" );
		$prom_relation_info = $prom_relation_obj->query_keke_witkey_prom_relation ();
		return $prom_relation_info [0];
	}
	public function get_prom_cash($prom_code, $relation_type, $obj_id, $prom_rate, $prize = '') {
		global $model_list;
		switch ($prom_code) {
			case "talent" :
				$hire_info = db_factory::get_one ( " select * from " . TABLEPRE . "witkey_hire where hire_id='$obj_id'" );
				$model_list [6] and $model_config = unserialize ( $model_list [6] ['config'] );
				if ($model_config) {
					$obj_cash = $hire_info ['price'] * $model_config ['deduct_scale'] / 100;
					switch ($relation_type) {
						case "temp" :
							$profit = $obj_cash * $model_config ['prom_rate'] / 100;
							break;
						case "long" :
							$profit = $obj_cash * $prom_rate / 100;
							break;
					}
				}
				break;
			case "pub_task" :
				$task_info = $this->get_prom_task_info ( $obj_id );
				$model_list [$task_info ['model_id']] and $model_config = unserialize ( $model_list [$task_info ['model_id']] ['config'] );
				if ($model_config) {
					($model_list [$task_info ['model_id']] ['model_dir'] == 'tender') and $obj_cash = $task_info ['task_cash'] or $obj_cash = $task_info ['task_cash'] * $model_config ['deduct_scale'] / 100;
					;
					switch ($relation_type) {
						case "temp" :
							$profit = $obj_cash * $model_config ['prom_rate'] / 100;
							break;
						case "long" :
							$profit = $obj_cash * $prom_rate / 100;
							break;
					}
				}
				break;
			case "bid_task" :
				$task_info = $this->get_prom_task_info ( $obj_id );
				$model_list [$task_info ['model_id']] and $model_config = unserialize ( $model_list [$task_info ['model_id']] ['config'] );
				if ($model_config) {
					$site_cash = $task_info ['task_cash'] * $model_config ['deduct_scale'] / 100;
					switch ($task_info ['task_mode']) {
						case "2" :
							$task_prize = db_factory::query ( " select * from " . TABLEPRE . "witkey_task_prize where task_id='$obj_id'" );
							foreach ( $task_prize as $v ) {
								if ($v ['prize'] == $prize) {
									$prize_rate = $v ['prize_cash'] / ($task_info ['task_cash'] * $v ['prize_count']);
								}
							}
							break;
						case "3" :
							$work_count = $task_info ['work_count'];
							break;
					}
					$prize_rate and $p_rate = $prize_rate or $p_rate = 1;
					$work_count and $w_count = $work_count or $w_count = 1;
					switch ($relation_type) {
						case "temp" :
							$obj_cash = $task_info ['prom_count'] + $site_cash * $model_config ['prom_rate'] / 100;
							$profit = $p_rate * $obj_cash / $w_count;
							break;
						case "long" :
							$obj_cash = $task_info ['prom_count'] + $site_cash * $prom_rate / 100;
							$profit = $p_rate * $obj_cash / $w_count;
							
							break;
					}
				}
				break;
		}
		return array ("user_cash" => $profit, "obj_cash" => $obj_cash );
	}
	function prom_rule_init($prom_code, $obj_id, $uid, $relation_type, $prize = '') {
		$prom_relation_arr = $this->prom_relation_init ( $uid );
		$prom_rule_config_info = $this->_prom_rule_config_info;
		$prom_rule_arr = $prom_rule_config_info [$prom_code];
		
		$valid_time = time () - $prom_relation_arr [on_time] - $prom_rule_arr ['month'] * 24 * 3600 * 30;
		switch ($relation_type) {
			case "temp" :
				$cash_arr = $this->get_prom_cash ( $prom_code, $relation_type, $obj_id, $prom_rule_arr ['rate'], $prize );
				$obj_cash = $cash_arr ['obj_cash'];
				$user_cash = $cash_arr ['user_cash'];
				$user_credit = 0;
				break;
			case "long" :
				switch ($prom_rule_arr ['type']) {
					case "reg" :
					case "auth" :
						$obj_cash = $prom_rule_arr ['cash'] + $prom_rule_arr ['credit'];
						$user_cash = $prom_rule_arr ['cash'];
						$user_credit = $prom_rule_arr ['credit'];
						break;
					case "task" :
						if ($valid_time >= 0) {
							$user_cash = 0;
						} else {
							$cash_arr = $this->get_prom_cash ( $prom_code, $relation_type, $obj_id, $prom_rule_arr ['rate'], $prize );
							$obj_cash = $cash_arr ['obj_cash'];
							$user_cash = $cash_arr ['user_cash'];
						}
						$user_credit = 0;
						break;
					case "vip" :
						$prom_vip = kekezu::get_table_data ( "witkey_prom_rule", " type = 'vip'", '', '', 'prom_code' );
						$prom_vip ['vip'] ['config'] and $prom_vip_config = unserialize ( $prom_vip ['vip'] ['config'] ) or $prom_vip_config = array ();
						$vip_history = db_factory::query ( " select count(h_id) as count from " . TABLEPRE . "witkey_vip_history where uid = '$uid' and h_status=1" );
						$vip_count = $vip_history [0] ['count'];
						if ($vip_count >= $prom_vip_config ['time'])
							return false;
						if ($prom_vip ['vip'] ['rate'] == 0)
							return false;
						$obj_cash = $prize;
						$user_cash = $prize * $prom_vip ['vip'] ['rate'] / 100;
						$user_credit = 0;
						break;
					case "weibo" :
						$wb_config = kekezu::get_task_config ( 11 );
						$prom_rule_arr ['config'] and $prom_config = unserialize ( $prom_rule_arr ['config'] ) or $prom_config = array ();
						$fans_show_arr = $wb_config ['fans_show_arr'];
						$fans_show_arr = explode ( ',', $fans_show_arr );
						$weibo_auth = kekezu::get_table_data ( "witkey_prom_rule", " type = 'weibo' " );
						$weibo_auth and $weibo_auth_config = unserialize ( $weibo_auth [0] ['config'] ) or $weibo_auth_config = array ();
						$wb_fans = 0;
						foreach ( $fans_show_arr as $fans ) {
							if ($prize > $fans) {
								$wb_fans = $fans;
							} else {
								break;
							}
						}
						echo $wb_fans;
						$user_cash = $prom_config ["wbauth_cash_$fans"] + 0;
						$user_credit = $prom_config ["wbauth_credit_$fans"] + 0;
						$obj_cash = $user_cash + $user_credit;
						break;
				}
				break;
		}
		$prom_rule_arr ['user_cash'] = $user_cash;
		$prom_rule_arr ['user_credit'] = $user_credit;
		$prom_rule_arr ['obj_cash'] = floatval ( $obj_cash );
		return $prom_rule_arr;
	}
	function has_temp_prom_relation($uid, $prom_type, $relation_status = '1') {
		$period_month = intval ( $this->_prom_rule_config_info [$prom_type] ['month'] );
		$sql = " select * from " . TABLEPRE . "witkey_prom_relation where uid='$uid' and relation_type='temp' and prom_type='$prom_type' and relation_status='$relation_status' and DATE_ADD(DATE(FROM_UNIXTIME(on_time)),INTERVAL $period_month MONTH)>CURDATE()";
		$has_relation = db_factory::query ( $sql );
		return $has_relation [0];
	}
	function has_long_prom_relation($uid) {
		$sql = " select * from " . TABLEPRE . "witkey_prom_relation where uid='$uid' and relation_type='long' and prom_type='reg'";
		$has_relation = db_factory::query ( $sql );
		return $has_relation [0];
	}
	function has_prom_relation($uid, $prom_type, $relation_status = '1') {
		
		$has_relation = $this->has_temp_prom_relation ( $uid, $prom_type, $relation_status );
		if (! empty ( $has_relation )) {
			return $has_relation;
		} else {
			$has_relation = $this->has_long_prom_relation ( $uid );
			return $has_relation;
		}
	
	}
	function has_prom_event($obj_id, $uid, $prom_type, $relation_type = 'temp', $relation_status = '1', $event_status = '0') {
		$sql = " select a.*,b.relation_id,b.relation_type,b.prom_type,b.relation_status from " . TABLEPRE . "witkey_prom_event as a left join " . TABLEPRE . "witkey_prom_relation as b on a.uid=b.uid where a.obj_id='$obj_id' and a.action='$prom_type' and a.uid='$uid' and a.event_status='$event_status' and b.relation_status='$relation_status' and b.relation_type='$relation_type'";
		$prom_event = db_factory::get_one ( $sql );
		return $prom_event ? $prom_event : false;
	}
	function create_prom_relation($prom_uid, $uid, $username, $url_data, $relation_status = '1') {
		global $kekezu;
		if ($prom_uid == $uid) {
			return false;
		}
		$prom_user_info = $kekezu->get_user_info ( $prom_uid );
		$prom_relation_obj = new Keke_witkey_prom_relation_class ();
		$prom_relation_obj->setUid ( $uid );
		$prom_relation_obj->setUsername ( $username );
		$prom_relation_obj->setProm_uid ( $prom_uid );
		$prom_relation_obj->setProm_username ( $prom_user_info [username] );
		$prom_relation_obj->setProm_type ( $url_data ['p'] );
		$prom_relation_obj->setRelation_type ( $url_data ['r'] );
		$prom_relation_obj->setObj_id ( $url_data ['o'] ? $url_data ['o'] : $uid );
		$prom_relation_obj->setRelation_status ( $relation_status );
		$prom_relation_obj->setOn_time ( time () );
		$prom_relation_obj->create_keke_witkey_prom_relation ();
	}
	function create_prom_event($obj_id, $obj, $uid, $prom_type, $relation_type = 'temp', $prize = '', $status = '0') {
		$prom_relation_arr = $this->has_prom_relation ( $uid, $prom_type );
		if (is_array ( $prom_relation_arr ) && $prom_relation_arr [prom_uid] != $uid) {
			if (! $this->has_prom_event ( $obj_id, $uid, $prom_type, $relation_type )) {
				$prom_rule_arr = $this->prom_rule_init ( $prom_type, $obj_id, $uid, $relation_type, $prize );
				$prom_event_obj = new Keke_witkey_prom_event_class ();
				$prom_event_obj->setAction ( $prom_type );
				$prom_event_obj->setEvent_desc ( $prom_rule_arr ['prom_item'] );
				$prom_event_obj->setProm_id ( $prom_rule_arr ['prom_id'] );
				$prom_event_obj->setUid ( $uid );
				$prom_event_obj->setUsername ( $prom_relation_arr [username] );
				$prom_event_obj->setParent_uid ( $prom_relation_arr [prom_uid] );
				$prom_event_obj->setParent_username ( $prom_relation_arr [prom_username] );
				$prom_event_obj->setObj ( $obj );
				$prom_event_obj->setObj_id ( $obj_id );
				$prom_event_obj->setObj_cash ( number_format ( $prom_rule_arr ['obj_cash'], 2 ) );
				$prom_event_obj->setRake_cash ( number_format ( $prom_rule_arr ['user_cash'], 2 ) );
				$prom_event_obj->setRake_credit ( number_format ( $prom_rule_arr ['user_credit'], 2 ) );
				$prom_event_obj->setEvent_time ( time () );
				$prom_event_obj->setEvent_status ( $status );
				$prom_event_id = $prom_event_obj->create_keke_witkey_prom_event ();
				$this->clear_prom_cookie ();
				return $prom_event_id ? true : false;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	function dispose_prom_event($obj_id, $uid, $prom_type) {
		if ($this->has_temp_prom_relation ( $uid, $prom_type )) { //Ƚʱϵ
			$prom_arr = $this->has_prom_event ( $obj_id, $uid, $prom_type );
		} else {
			$prom_arr = $this->has_prom_event ( $obj_id, $uid, $prom_type, 'long' );
		}
		if (! empty ( $prom_arr )) {
			if ($prom_type == 'pic') {
				$res = $this->dispose_web_pic_prom_event ( $prom_arr, $prom_arr ['obj'] );
			} elseif ($prom_type == 'txt') {
				$res = $this->dispose_web_text_prom_event ( $prom_arr, $prom_arr ['obj'] );
			} else {
				$res = $this->dispose_general_prom_event ( $prom_arr, $prom_arr ['obj'] );
			}
		}
		return $res ? true : false;
	}
	function dispose_general_prom_event($prom_arr, $action) {
		$res = $this->prom_public_dispose_method ( $prom_arr, $action );
		if ($prom_arr ['relation_type'] == 'temp') { //ʱϵ
			$res .= $this->set_relation_status ( $prom_arr ['relation_id'], 0 );
		}
		return $res ? true : false;
	}
	
	function dispose_web_pic_prom_event($prom_arr, $action) {
		global $kekezu;
		if ($this->_cpc_open == 1 && $prom_arr ['relation_type'] == 'temp') { //cpc
			$res = $this->set_relation_status ( $prom_arr ['relation_id'], 0 );
			if ($this->_reg_open == 1) { //رעƹ
				$this->clear_prom_cookie (); //ƹcookie
			}
		}
		return $res ? true : false;
	}
	function dispose_web_text_prom_event($prom_arr, $action) {
		global $kekezu;
		if ($prom_arr ['relation_type'] == 'temp') {
			$prom_task_info = $this->get_prom_task_info ( $prom_arr ['obj_id'] );
			if ($prom_task_info && in_array ( $prom_task_info ['task_status'], array (5, 7 ) )) { //ƹ
				$res = $this->prom_public_dispose_method ( $prom_arr, $action );
				$res .= $this->set_relation_status ( $prom_arr ['relation_id'], 0 ); //ʱ¼
			}
		}
		return $res ? true : false;
	}
	function prom_public_dispose_method($prom_arr, $action) {
		$res = keke_finance_class::cash_in ( $prom_arr [parent_uid], $prom_arr [rake_cash], $prom_arr [rake_credit], $action );
		$res .= $this->set_prom_event_status ( $prom_arr ['event_id'], 1 );
		return $res ? true : false;
	}
	function get_prom_task_info($task_id) {
		$task_info = db_factory::get_one ( " select task_id,task_mode,task_status,task_cash,istop,indus_id,model_id,prom_count,work_count from " . TABLEPRE . "witkey_task where task_id='$task_id'" );
		return $task_info ? $task_info : false;
	}
	function set_relation_status($relation_id, $status) {
		db_factory::execute ( " update " . TABLEPRE . "witkey_prom_relation set relation_status ='$status' where relation_id ='$relation_id'" );
	}
	function set_prom_event_status($event_id, $status) {
		db_factory::execute ( " update " . TABLEPRE . "witkey_prom_event set event_status = '$status' where event_id= '$event_id'" );
	
	}
	function has_prom_cpc($prom_uid, $prom_type) {
		$source = trim ( $_SERVER ['HTTP_REFERER'] );
		$ip = kekezu::get_ip ();
		$has_cpc_event = db_factory::get_count ( "select cpc_id from " . TABLEPRE . "witkey_prom_cpc where parent_uid='$prom_uid'
		 and prom_type='$prom_type'  and day(date(from_unixtime(on_time)))=day(curdate()) and source='$source' and ip='$ip'", 0, 'cpc_id' );
		return $has_cpc_event ? true : false;
	}
	function dispose_click_event($prom_uid, $action, $cpc_cash) {
		$res = keke_finance_class::cash_in ( $prom_uid, $cpc_cash, 0, $action );
		return $res ? true : false;
	}
	function create_prom_cpc($prom_uid, $prom_type) {
		global $kekezu;
		$prom_event_obj = $this->_prom_event_obj;
		$source = trim ( $_SERVER ['HTTP_REFERER'] );
		$ip = kekezu::get_ip ();
		$cpc_cash = $this->_cpc_cash;
		$prom_user_info = kekezu::get_user_info ( $prom_uid );
		if (! $this->has_prom_cpc ( $prom_uid, $prom_type )) {
			/*¼cpc*/
			$cpc_obj = new Keke_witkey_prom_cpc_class ();
			$cpc_obj->setCpc_id ( null );
			$cpc_obj->setSource ( $source );
			$cpc_obj->setIp ( $ip );
			$cpc_obj->setParent_uid ( $prom_uid );
			$cpc_obj->setParent_username ( $prom_user_info [username] );
			$cpc_obj->setCash ( $cpc_cash );
			$cpc_obj->setProm_type ( $prom_type );
			$cpc_obj->setOn_time ( time () );
			$cpc_id = $cpc_obj->create_keke_witkey_prom_cpc ();
			
			if ($cpc_id && $this->_cpc_open == 1) {
				$this->dispose_click_event ( $prom_uid, $prom_type, $cpc_cash );
			}
		} else {
			return false;
		}
	}
	function prom_income_rank() {
		$prom_income = db_factory::query ( " select * from (select uid,username,sum(fina_cash) as cash,sum(fina_credit) as credit from 
		" . TABLEPRE . "witkey_finance where (INSTR(fina_action,'prom')>0 and fina_action!='prom_task') or fina_action='txt' group by uid ) a order by a.cash desc limit 0,10 " );
		return $prom_income ? $prom_income : false;
	}
	function get_prom_article($limit = 10) {
		return kekezu::get_table_data ( '*', "witkey_article", " art_cat_id=216", ' pub_time desc ', '', '0,' . $limit, '', 3600 );
	}
	function create_prom_cookie($query_string) {
		global $_K, $kekezu;
		$url_data = $this->url_data_format ( $query_string );
		if ($kekezu->_uid != $url_data ['u'] && ($url_data ['p'] == 'txt' || $url_data ['p'] == 'pic') && $this->_cpc_open == 1) { //վ¼
			$this->create_prom_cpc ( $url_data ['u'], $url_data ['p'] );
		}
		if ($kekezu->_uid) {
			if ($url_data ['u'] != $kekezu->_uid && ($url_data ['p'] == 'pub_task' || $url_data ['p'] == 'bid_task' || $url_data ['p'] == 'talent' || $url_data ['p'] == 'txt')) {
				($url_data ['p'] == 'txt' && $url_data ['t']) and $url_data ['p'] = $url_data ['t'];
				
				if (! $this->has_prom_relation ( $kekezu->_uid, $url_data ['p'] )) {
					$this->create_prom_relation ( $url_data ['u'], $kekezu->_uid, $kekezu->_username, $url_data );
				} else {
				    kekezu::notify_user("ƹʧ","𾴵ûƹĻԱڱվӵƹԱƹʧЧɵĲ½",$url_data ['u']);
				}
			}
		} else {
			setcookie ( "user_prom_event", serialize ( $url_data ), time () + 24 * 3600, COOKIE_PATH, COOKIE_DOMAIN );
		}
		$this->prom_jump ( $url_data );
	}
	function del_when_temp_fail($obj_id, $prom_type, $is_employ = '1', $relation_status = '1') {
		if ($is_employ == 1) {
			$temp_relation = $this->has_temp_prom_relation ( $obj_id, $prom_type );
			$sql = " delete from " . TABLEPRE . "witkey_prom_relation where uid=%d and relation_type='temp' and prom_type='%s' and relation_status=%d";
			$temp_relation and $res = db_factory::execute ( sprintf ( $sql, $obj_id, $prom_type, $relation_status ) );
			$prom_event = $this->has_prom_event ( $obj_id, $obj_id, $prom_type, $temp_relation ['relation_type'], 1, 1 );
			$sql2 = " delete from " . TABLEPRE . "witkey_prom_event where obj_id='$obj_id' and action='%s' and uid=%d and event_status=1";
			$prom_event and $res .= db_factory::execute ( sprintf ( $sql2, $prom_type, $obj_id ) );
		} else {
			$sql = " delete from " . TABLEPRE . "witkey_prom_relation where obj_id=%d and relation_type='temp' and prom_type='%s' and relation_status=%d";
			$res = db_factory::execute ( sprintf ( $sql, $obj_id, $prom_type, $relation_status ) );
		}
		return $res ? true : false;
	}
	public function is_meet_require($prom_code, $task_id) {
		if ($prom_code == 'pub_task' || $prom_code == 'bid_task') {
			$task_info = $this->get_prom_task_info ( $task_id );
			$prom_config = db_factory::get_one ( " select * from " . TABLEPRE . "witkey_prom_rule where prom_code='$prom_code'" );
			$prom_config = unserialize ( $prom_config ['config'] );
			$result = TRUE;
			if ($prom_config ['is_top'] && $task_info ['istop'] != 1) {
				$result = FALSE;
			}
			if ($prom_config ['limit_cash'] && $prom_config ['mini_cash'] && $prom_config ['mini_cash'] > $task_info ['prom_count']) {
				$result = FALSE;
			}
			if ($prom_config ['indus'] && FALSE === strpos ( $prom_config ['indus_string'], $task_info ['indus_id'] )) {
				$result = FALSE;
			}
			if ($prom_config ['model'] && FALSE === strpos ( $prom_config ['model'], $task_info ['model_id'] )) {
				$result = FALSE;
			}
		}
		return $result;
	
	}
	function get_prom_item($item_type) {
		global $_K, $kekezu;
		$uid = $kekezu->_uid;
		return $kekezu->get_table_data ( "*", "witkey_prom_item", "item_type='$item_type'", "on_time desc", '', '', '', 3600 );
	
	}
	function get_prom_rule($prom_code) {
		return db_factory::get_one ( "select * from " . TABLEPRE . "witkey_prom_rule where prom_code='$prom_code'" );
	}
	public function get_required_task($type, $model_id) {
		$prom_config = db_factory::get_one ( " select * from " . TABLEPRE . "witkey_prom_rule where type='$type'" );
		$prom_config = unserialize ( $prom_config ['config'] );
		$sql = " select task_id,task_title from " . TABLEPRE . "witkey_task where model_id=" . $model_id;
		$prom_config ['is_top'] and $sql .= " and istop=1";
		($prom_config ['limit_cash'] && $prom_config ['mini_cash']) and $sql .= " and prom_count>=" . $prom_config ['mini_cash'];
		($prom_config ['indus'] && $prom_config ['indus_string']) and $sql .= " and indus_id in (" . $prom_config ['indus_string'] . ")";
		($prom_config ['model']) and $sql .= " and model_id in (" . $prom_config ['model'] . ")";
		$sql .= " and task_status in (2,3) order by start_time desc ";
		
		$data = db_factory::query ( $sql );
		if ($data) {
			kekezu::echojson ( "1", 1, $data );
			die ();
		} else {
			kekezu::echojson ( "1", 0 );
			die ();
		}
	}
	function extract_prom_cookie() {
		isset ( $_COOKIE ['user_prom_event'] ) and $url_data = unserialize ( stripslashes ( $_COOKIE ['user_prom_event'] ) );
		return $url_data;
	}
	function clear_prom_cookie() {
		if (isset ( $_COOKIE ['user_prom_event'] )) {
			setcookie ( 'user_prom_event', '', - 9999 );
			unset ( $_COOKIE ['user_prom_event'] );
		}
	}
	function prom_jump($url_data) {
		global $_K;
		if (isset ( $url_data ['u'] ) && $url_data ['l']) {
			if ($url_data ['o'] && ! $url_data ['e']) {
				header ( "Location:" . $_K ['siteurl'] . "/index.php?do=" . $url_data ['l'] . "&task_id=" . $url_data ['o'] );
			} elseif (! $url_data ['o'] && $url_data ['e']) {
				header ( "Location:" . $_K ['siteurl'] . "/index.php?do=" . $url_data ['l'] . "&member_id=" . $url_data ['e'] );
			} else {
				header ( "Location:" . $_K ['siteurl'] . "/index.php?do=" . $url_data ['l'] );
			}
		}
	}
}

?>