<?php

class keke_shop_class {
	public $_service_id;
	public $_service_type;
	public $_service_info;
	
	public $_seller_uid;
	public $_seller_username;
	public $_seller_info;
	
	public $_shop_id;
	public $_shop_info;
	public $_logo_info;
	
	public $_service_obj;
	public $_order_obj;
	public $_order_detail_obj;
	
	public static function get_instance($service_id) {
		static $obj = null;
		if ($obj == null) {
			$obj = new keke_shop_class ( $service_id );
		}
		return $obj;
	}
	public function __construct($service_id) {
		global $kekezu;
		$this->_service_id = $service_id;
		$this->_service_obj = new Keke_witkey_service_class ();
		$this->_order_obj = new Keke_witkey_service_order_class ();
		$this->_order_detail_obj = new Keke_witkey_service_order_detail_class ();
		$this->_buy_uid=$kekezu->_uid;
		$this->_buy_username=$kekezu->_username;
		$this->service_info_init ();
		$this->seller_info_init ();
		$this->shop_info_init();
		$this->shop_logo_init();
	}
	
	public function service_info_init() {
		$service_info = db_factory::get_one ( " select * from " . TABLEPRE . "witkey_service where service_id='$this->_service_id'" );
		$this->_service_info = $service_info;
		$this->_service_type = $service_info ['service_type'];
		$this->_shop_id=$service_info['shop_id'];
	}
	public function seller_info_init() {
		global $kekezu;
		$this->_seller_uid = $this->_service_info ['uid'];
		$this->_seller_info = $kekezu->get_user_info ( $this->_service_info ['uid'] );
		$this->_seller_username=$this->_seller_info['username'];
	}
	public function shop_info_init() {
		$shop_info = db_factory::get_one ( "select b.*,a.* from " . TABLEPRE . "witkey_shop a left join " . TABLEPRE . "witkey_space b on a.uid = b.uid where a.shop_id = '$this->_shop_id'" );
		$this->_shop_info=$shop_info;
	}
	public function shop_logo_init() {
		$shop_logo = db_factory::get_one("select shop_logo from " . TABLEPRE . "witkey_shop_tpl_econfig where shop_id = '$this->_shop_id'" );
		$this->_logo_info=$shop_logo;
	}
	function create_order($pay_cash='0') {
		global $kekezu;
		($this->_buy_uid==$this->_seller_uid) and $kekezu->show_msg('ʾ',$_SERVER['HTTP_REFERER'],3,'޷ԼƷ','error');
		$service_order_obj =$this->_order_obj;
		$service_order_obj->_order_id = null;
		$service_order_obj->setBuy_uid ( $this->_buy_uid );
		$service_order_obj->setBuy_username ( $this->_buy_username );
		$service_order_obj->setOn_time ( time () );
		if ($this->_service_type == 2) {
			$service_order_obj->setOrder_status ( 2 );
		} elseif ($this->_service_type == 1) {
			$service_order_obj->setOrder_status ( 0 );
		}
		$service_order_obj->setCount_cash ( $this->_service_info['price'] );
		$service_order_obj->setPay_cash($pay_cash);
		$service_order_obj->setTitle (  $this->_service_info['title'] );
		$service_order_obj->setSale_uid ( $this->_seller_uid);
		$service_order_obj->setSale_username ( $this->_seller_username);
		$service_order_obj->setService_id ( $this->_service_id );
		$service_order_obj->setService_type ( $this->_service_type );
		$service_order_obj->setShop_id ( $this->_shop_id );
		if ($this->_service_type == 2) {
			$service_order_obj->setBuyer_status ( 1 );
		} elseif ($this->_service_type == 1) {
			$service_order_obj->setBuyer_status (0 );
		}
		$service_order_obj->setSale_status ( 0 );
		$order_id = $service_order_obj->create_keke_witkey_service_order ();
		return $order_id?$order_id:false;
	
	}
	 function create_new_step($new_detail_arr, $order_id) {
		$order_detail_obj =$this->_order_detail_obj;
		foreach ( $new_detail_arr as $k => $detail ) {
			
			$order_detail_obj->_detail_id = null;
			$order_detail_obj->setStep_cash ( $detail ['step_cash'] );
			$order_detail_obj->setStep_detail ( $detail ['step_detail'] );
			$order_detail_obj->setStep_num ( $k );
			$order_detail_obj->setStep_status ( 0 );
			$order_detail_obj->setOrder_id ( $order_id );
			$res += $order_detail_obj->create_keke_witkey_service_order_detail ();
		}
		return $res?true:false;
	
	}
	 function delete_detail_step($detail_arr) {
		$order_detail_obj =$this->_order_detail_obj;
		$order_detail_obj->setWhere ( "detail_id in ($detail_arr[del])" );
		$res = $order_detail_obj->del_keke_witkey_service_order_detail ();
		return $res?true:false;
	}
	 function update_order_status($order_id, $status) {
		$service_order_obj =$this->_order_obj;
		$service_order_obj->setWhere ( "order_id = '$order_id'" );
		$service_order_obj->setOrder_status ( $status );
		$res = $service_order_obj->edit_keke_witkey_service_order ();
		return $res?true:false;
	
	}
	 function update_custom_status($order_id, $step, $is_saler = '1') {
		$service_order_obj =$this->_order_obj;
		$service_order_obj->setWhere ( "order_id = '$order_id'" );
		if ($is_saler) {
			$service_order_obj->setSale_status ( intval ( $step ) );
		} else {
			$service_order_obj->setBuyer_status ( intval ( $step ) );
		}
		$res=$service_order_obj->edit_keke_witkey_service_order ();
		return $res?true:false;
	
	}
	 function insert_into_file($obj_type, $obj_id, $file_name, $save_name) {
	 	global $kekezu;
	 	($this->_seller_uid!=$kekezu->_uid) and $kekezu->show_msg('ʾ',$_SERVER['HTTP_REFERER'],3,'ֻҲſϴ','error');
		$file_obj = new Keke_witkey_file_class ();
		$file_obj->_file_id = null;
		$file_obj->setObj_type ( $obj_type );
		$file_obj->setObj_id ( $obj_id );
		$file_obj->setFile_name ( $file_name );
		$file_obj->setFile_save_name ( "data/uploads/" . UPLOAD_RULE . $save_name );
		$file_obj->setUid ( $this->_seller_uid );
		$file_obj->setUsername ( $this->_seller_username);
		$file_obj->setOn_time ( time () );
		$res = $file_obj->create_keke_witkey_file ();
		return $res?true:false;
	
	}
	 function get_order_file($order_id) {
		$file_obj = new Keke_witkey_file_class ();
		$file_obj->setWhere ( "obj_type = 'service_order' and obj_id = " . intval ( $order_id ) );
		$file_list = $file_obj->query_keke_witkey_file ();
		return $file_list?$file_list:false;
	
	}
	 function is_shop_order($uid = null) {
	 	$sql = " select a.*,b.file_path,b.submit_method from " . TABLEPRE . "witkey_service_order as a left join " . TABLEPRE . "witkey_service as b on a.service_id= b.service_id where a.service_id ='$this->_service_id' ";
	 	($uid&&$uid==$this->_buy_uid&&$this->_seller_uid!=$this->_buy_uid) and $sql.=" and a.buy_uid= '$uid'";
	 	($uid&&$uid==$this->_seller_uid) and $sql.=" and a.sale_uid= '$uid'";
	 	$sql.=" order by a.on_time desc";
		$order_info = db_factory::get_one($sql );
		return $order_info?$order_info:false;
	
	}
}

?>