<?php
/**
 * @copyright keke-tech
 * @author shang
 * @version v 1.0
 * 2010-5-2816:59:00
 */

class keke_mark_class {
	
	public static function create_mark_log($obj, $obj_id, $obj_cash = 0, $buyer_uid, $seller_uid, $buyer_username = '', $seller_username = '') {
		global $basic_config;
		
		if (! $buyer_username) {
			$buyer_uinfo = kekezu::get_user_info ( $buyer_uid );
			$buyer_username = $buyer_uinfo ['username'];
		}
		
		if (! $seller_username) {
			$seller_uinfo = kekezu::get_user_info ( $seller_uid );
			$seller_username = $seller_uinfo ['username'];
		}
		
		$mark_log_obj = new Keke_witkey_mark_log_class ();
		$mark_log_obj->setWhere ( "obj = '$obj' and obj_id = '$obj_id'" );
		$mark_arr = $mark_log_obj->query_keke_witkey_mark_log ();
		
		if ($mark_arr) {
			return false;
		}
		
		$mark_log_obj->setBy_uid ( $buyer_uid );
		$mark_log_obj->setBy_username ( $buyer_username );
		$mark_log_obj->setUid ( $seller_uid );
		$mark_log_obj->setUsername ( $seller_username );
		$mark_log_obj->setObj ( $obj );
		$mark_log_obj->setObj_id ( $obj_id );
		$mark_log_obj->setObj_cash ( $obj_cash );
		$mark_log_obj->setUser_type ( 1 );
		$mark_log_obj->setMark_status ( 0 );
		$mark_log_obj->setMark_time ( time () );
		$mark_log_obj->setMark_max_time ( time () + $basic_config ['auto_mark_time'] * 24 * 3600 );
		$mark_log_obj->create_keke_witkey_mark_log ();
		
		$mark_log_obj->_mark_id = null;
		$mark_log_obj->setBy_uid ( $seller_uid );
		$mark_log_obj->setBy_username ( $seller_username );
		$mark_log_obj->setUid ( $buyer_uid );
		$mark_log_obj->setUsername ( $buyer_username );
		$mark_log_obj->setObj ( $obj );
		$mark_log_obj->setObj_id ( $obj_id );
		$mark_log_obj->setUser_type ( 2 );
		$mark_log_obj->setMark_status ( 0 );
		$mark_log_obj->setMark_time ( time () );
		$mark_log_obj->setMark_max_time ( $basic_config ['auto_mark_time'] ? time () + $basic_config ['auto_mark_time'] * 24 * 3600 : 0 );
		$res = $mark_log_obj->create_keke_witkey_mark_log ();
		return $res ? true : false;
	
	}
	public static function get_mark_level($mark_value, $user_type) {
		$mark_value = intval ( $mark_value );
		$user_type = intval ( $user_type );
 
		$mark_rule = kekezu::get_table_data ('*',"witkey_mark_rule", "", "max_mark","","","","3600");
 
		for($i = 0; $i < count ( $mark_rule ); $i ++) {
			if ($mark_value < $mark_rule [0] [max_mark]) {
				
				$g_pic = $mark_rule [0] [g_ico];
				$w_pic = $mark_rule [0] [m_ico];
			} elseif ($mark_value < $mark_rule [$i + 1] [max_mark] && $mark_value >= $mark_rule [$i] [max_mark]) {
				
				$g_pic = $mark_rule [$i] [g_ico];
				$w_pic = $mark_rule [$i] [m_ico];
			} elseif ($mark_value > $mark_rule [count ( $mark_rule ) - 1] [max_mark]) {
				
				$g_pic = $mark_value [count ( $mark_rule ) - 1] [g_ico];
				$w_pic = $mark_rule [count ( $mark_rule ) - 1] [m_ico];
			}
		}
		
		$mark_level_arr [value] = $mark_value;
		if ($user_type == 1) {
			$mark_level_arr [pic] = '<img src="' . $g_pic . '" align="absmiddle" title="ֵ' . $mark_value . '">';
		} else {
			$mark_level_arr [pic] = '<img src="' . $w_pic . '" align="absmiddle" title="ֵ' . $mark_value . '">';
		}
		return $mark_level_arr;
	}
	
	public static function exec_mark($mark_id, $mark_status, $mark_content, $mark_cash = 0) {
		global $basic_config;
		$mark_log_obj = new Keke_witkey_mark_log_class ();
		$mark_log_obj->setWhere ( "mark_id = '$mark_id'" );
		$mark_info = $mark_log_obj->query_keke_witkey_mark_log ();
		$mark_info = $mark_info [0];
		
		$mark_log_obj->setWhere ( "mark_id = '$mark_id'" );
		if (! $mark_info ['mark_status'] || $mark_status < $mark_info ['mark_status']) {
			$mark_log_obj->setMark_status ( $mark_status );
		}
		$mark_log_obj->setMark_content ( $mark_content );
		$res=$mark_log_obj->edit_keke_witkey_mark_log ();
		if (! $mark_info ['mark_status']) {
			
			$edit_col = $mark_info ['user_type'] == 2 ? "g_m_credit_value" : "w_m_credit_value";
			$mark_cash = $mark_cash ? $mark_cash : $mark_info ['obj_cash'];
			$plus_value = keke_mark_class::get_comment_score ( $mark_cash, $mark_status );
			keke_mark_class::exec_rate($mark_info['uid'],$mark_info['user_type']);
			
			db_factory::execute ( "update " . TABLEPRE . "witkey_space set $edit_col=ifnull($edit_col,0)+$plus_value where uid = '{$mark_info['uid']}'" );
		}
		return $res;
	
	}
	
	public static function exec_rate($uid,$user_type=0){
		$where_sql = " 1=1 ";
		$exec_sql = " ";
		if (is_array($uid)){
			$where_sql .= " and uid in (".implode(",",$uid).")";
		}
		else {
			$where_sql .= " and uid = '$uid'";
		}
		
		if ($user_type==2){
			$exec_sql = "seller_good_rate = ROUND((select count(*) from ".TABLEPRE."witkey_mark_log b where a.uid = b.uid and user_type=2 and mark_status=1)*100/(select count(*) from ".TABLEPRE."witkey_mark_log b where a.uid = b.uid and user_type=2 and ifnull(mark_status,0)>0),2)";
		}
		elseif ($user_type==1){
			$exec_sql = "buyer_good_rate = ROUND((select count(*) from ".TABLEPRE."witkey_mark_log b where a.uid = b.uid and user_type=1 and mark_status=1)*100/(select count(*) from ".TABLEPRE."witkey_mark_log b where a.uid = b.uid and user_type=1 and ifnull(mark_status,0)>0),2)";
		}
		else {
			$exec_sql = "seller_good_rate = ROUND((select count(*) from ".TABLEPRE."witkey_mark_log b where a.uid = b.uid and user_type=2 and mark_status=1)*100/(select count(*) from ".TABLEPRE."witkey_mark_log b where a.uid = b.uid and user_type=2 and ifnull(mark_status,0)>0),2),buyer_good_rate = ROUND((select count(*) from ".TABLEPRE."witkey_mark_log b where a.uid = b.uid and user_type=1 and mark_status=1)*100/(select count(*) from ".TABLEPRE."witkey_mark_log b where a.uid = b.uid and user_type=1 and ifnull(mark_status,0)>0),2)";
		}
		
		db_factory::execute("update ".TABLEPRE."witkey_space a set $exec_sql where $where_sql ");
	}
	
	
	public static function get_user_mark_info($obj, $obj_id, $uid) {
		$mark_log_obj = new Keke_witkey_mark_log_class ();
		$mark_log_obj->setWhere ( "by_uid = '$uid' and obj = '$obj' and obj_id='$obj_id' order by mark_time desc limit 0,1" );
		$mark_arr = $mark_log_obj->query_keke_witkey_mark_log ();
		
		return $mark_arr [0];
	}
	
	public static function get_obj_mark_data($obj, $obj_id, $pk = null) {
		$mark_log_obj = new Keke_witkey_mark_log_class ();
		
		if (is_array ( $obj_id )) {
			$mark_log_obj->setWhere ( "obj = '$obj' and obj_id in (" . implode ( ',', $obj_id ) . ") " );
		} else {
			$mark_log_obj->setWhere ( "obj = '$obj' and obj_id = '$obj_id'" );
		}
		
		$mark_arr = $mark_log_obj->query_keke_witkey_mark_log ();
		
		if(!is_array($mark_arr)){
			return false;
		}
		$pk = $pk ? $pk : 'by_uid';
		$return = array ();
		foreach ( $mark_arr as $k => $v ) {
			if (is_array ( $obj_id )) {
				$return [$v ['obj_id']] [$v [$pk]] = $v;
			} else {
				$return [$pk] = $v;
			}
		}
		
		return $return;
	}
	static function get_comment_score($cash, $type = 2) {
		$type = intval ( $type );
		$score_rule = kekezu::get_table_data ( "*","witkey_mark_config", "", "max_cash asc", '','','', null );
		if ($type == 1) {
			$type = 'good';
		} elseif ($type == 2) {
			$type = 'normal';
		} elseif ($type == 3) {
			$type = 'bad';
		} else {
			$type = 'normal';
		}
		
		for($i = 0; $i < count ( $score_rule ); $i ++) {
			if ($cash < $score_rule [0] [max_cash]) {
				$score = $score_rule [0] [$type];
			} elseif ($cash <= $score_rule [$i + 1] [max_cash] && $cash > $score_rule [$i] [max_cash]) {
				$score = $score_rule [$i + 1] [$type];
			} elseif ($cash > $score_rule [count ( $score_rule ) - 1] [max_cash]) {
				$score = $score_rule [count ( $score_rule ) - 1] [$type];
			}
		}
		return intval ( $score );
	}
	
	static function get_experience_level($experience_value) {
		$experience_value = intval ( $experience_value );
		$score_rule = kekezu::get_table_data ("*", "witkey_score_rule", "", "max_score asc ",'','','', "3600");
		$count=count($score_rule);
		for($i = 0; $i <$count; $i ++) {
			if ($experience_value < $score_rule [0] [max_score]) {
				$title = $score_rule [0] [unit_title];
				$pic = $score_rule [0] [unit_ico];
				$sc_id = $score_rule [0] [score_rule_id];
			} elseif ($experience_value < $score_rule [$i + 1] [max_score] && $experience_value >= $score_rule [$i] [max_score]) {
				$title = $score_rule [$i] [unit_title];
				$pic = $score_rule [$i] [unit_ico];
				$sc_id = $score_rule [$i] [score_rule_id];
			} elseif ($experience_value > $score_rule [$count- 1] [max_score]) {
				$title = $score_rule [count ( $score_rule ) - 1] [unit_title];
				$pic = $score_rule [count ( $score_rule ) - 1] [unit_ico];
				$sc_id = $score_rule [count ( $score_rule ) - 1] [score_rule_id];
			}
		}
		$experience_level_arr [score_id] = $sc_id;
		$experience_level_arr [value] = $experience_value;
		$experience_level_arr [title] = $title;
		$experience_level_arr [pic] = '<img src="' . $pic . '" align="absmiddle" title="ͷΣ' . $title . '&#13;&#10;ֵ' . $experience_value . '">';
		return $experience_level_arr;
	}
	static function get_praise_comment($uid, $user_type = 1) {
		$uid = intval ( $uid );
		$type = intval ( $type );
		$user_type = intval ( $user_type );
		$mark_log_obj = new Keke_witkey_mark_log_class ();
		$mark_log_obj->setWhere ( " mark_status = 1 and user_type =" . $user_type . " and uid = " . $uid );
		$mark_good = $mark_log_obj->count_keke_witkey_mark_log ();
		$mark_log_obj->setWhere ( " mark_status = 2 and user_type =" . $user_type . " and uid =" . $uid );
		$mark_middle = $mark_log_obj->count_keke_witkey_mark_log ();
		$mark_log_obj->setWhere ( " mark_status = 3 and user_type =" . $user_type . " and uid = " . $uid );
		$mark_bad = $mark_log_obj->count_keke_witkey_mark_log ();
		$mark_total = intval ( $mark_good + $mark_middle + $mark_bad );
		
		if ($mark_total == 0) {
			$favorable_comment_rate = 0;
		} else {
			$favorable_comment_rate = round ( $mark_good / $mark_total * 100, 2 ) . "";
		}
		$favorable_comment [total] = intval ( $mark_total );
		$favorable_comment [good] = intval ( $mark_good );
		$favorable_comment [middle] = intval ( $mark_middle );
		$favorable_comment [bad] = intval ( $mark_bad );
		$favorable_comment [rate] = $favorable_comment_rate;
		return $favorable_comment;
	}

}
?>