<?php
class oauth_operator_class {
	static $_auth_info;
	static $_task_info;
	
	private static function get_auth_info() {
		
		$auth_info = self::$_auth_info;
		if (! $_auth_info) {
			$auth_info = db_factory::query ( "select * from " . TABLEPRE . "witkey_auth_item where auth_dir = 'weibo'" );
			$auth_info = $auth_info [0];
			$auth_info = keke_auth_class::get_auth_list ( $auth_info ['auth_id'] );
			self::$_auth_info = $auth_info;
		}
		return $auth_info;
	}
	
	private static function get_task_info() {
		$task_info = self::$_task_info;
		if (! $task_info) {
			$task_info = db_factory::query ( "select * from " . TABLEPRE . "witkey_model where model_dir = 'wbtask'" );
			$task_info = $task_info [0];
			$task_info = kekezu::get_task_config ( $task_info ['model_id'] );
			self::$_task_info = $task_info;
		}
		return $task_info;
	}
	
	static function get_api_config() {
		global $kekezu;
		switch (APP_INIT_TYPE) {
			case 'auth' :
				$auth_info = self::get_auth_info ();
				$api_config = unserialize ( $auth_info ['config'] );
				break;
			case 'task' :
				$task_info = self::get_task_info ();
				$api_config = $task_info;
				break;
			default :
				$interface_config_arr = $kekezu->get_table_data ( "*", "witkey_basic_config", "type='weibo'", "listorder asc ", '', '', 'k' );
				foreach ( $interface_config_arr as $k => $v ) {
					$api_config_arr [$v [k]] = $v [v];
				}
				$api_config = $api_config_arr;
		}
		return $api_config;
	}
	
	static function get_type_list() {
		global $init_api_config;
		switch (APP_INIT_TYPE) {
			case 'auth' :
				include_once S_ROOT . 'auth/weibo/auth_operate_class.php';
				$auth = self::get_auth_info ();
				$type_list = auth_operate_class::get_type_list ();
				break;
			case 'task' :
				include_once S_ROOT . 'task/wbtask/lib/wbtask_operate_class.php';
				$task_config = self::get_task_info ();
				$type_list = wbtask_operate_class::get_wb_type_list ( $task_config );
				break;
			default :
				$type_list = array ();
				if ($init_api_config ['sina_app_id']) {
					$type_list ['sina'] = '΢';
				}
				if ($init_api_config ['ten_app_id']) {
					$type_list ['ten'] = 'Ѷ΢';
				}
				if ($init_api_config ['netease_app_id']) {
					$type_list ['netease'] = 'ҳ΢';
				}
				if ($init_api_config ['souhu_app_id']) {
					$type_list ['souhu'] = 'Ѻ΢';
				}
		}
		
		return $type_list;
	}
	
	static function oauth_login($wb_type, $app_id, $app_secret) {
		global $callback, $_K;
		if ($callback) {
			global $oauth_verifier;
			oauth_api_factory::create_access_token ( $oauth_verifier, $wb_type, $app_id, $app_secret );
			header ( "Location:oauth_login.php?wb_type=" . $wb_type );
			die ();
		}
		
		if (oauth_api_factory::get_access_token ( $wb_type, $app_id, $app_secret )) {
			return true;
		} else {
			$aurl = oauth_api_factory::get_auth_url ( $_K ['siteurl'] . "/oauth_login.php?wb_type=$wb_type&callback=1", $wb_type, $app_id, $app_secret );
			header ( 'Location:' . $aurl );
			die ();
		}
	}
	
	/**
	 *Ƿа˺
	 *@param int $oauth_id  -- oauth_id
	 *@param string $source  -- $source
	 *@return array $bind_info
	 */
	static function check_bind_by_oauth_id($oauth_id, $source) {
		$bind_info = db_factory::query ( " select uid,username from " . TABLEPRE . "witkey_oauth_login where oauth_id='$oauth_id' and source='$source'" );
		return $bind_info [0];
	}
	
	//Ȩ    Ѵڵվû
	static function oauth_assign($data, $wb_type, $uid, $username = null) {
		global $basic_config;
		if (! $uid)
			return false;
		
		if (! $username) {
			$username = kekezu::get_user_info ( $uid );
		}
		$oauth_obj = new Keke_witkey_oauth_login_class ();
		$oauth_obj->setAccount ( $data ['name'] );
		$oauth_obj->setOauth_id ( $data ['account'] );
		$oauth_obj->setOn_time ( time () );
		$oauth_obj->setSource ( $wb_type );
		$oauth_obj->setUid ( $uid );
		$oauth_obj->setUsername ( $username );
		$oauth_id=$oauth_obj->create_keke_witkey_oauth_login ();
		
		$message_obj = new keke_msg_class ();
		if ($message_obj->validate ( 'reg' ) && $basic_config ['allow_reg_action'] == 0) {
			$message_obj->setUid ($uid);
			$message_obj->setUsername ($username);
			$message_obj->setTitle ( 'עɹ' );
			@$message_obj->send ();
		}
	
	}
	
	static function install() {
		db_factory::execute ( "CREATE TABLE IF NOT EXISTS `" . TABLEPRE . "witkey_oauth_login` (
  `id` int(11) NOT NULL auto_increment,
  `source` char(10) default NULL,
  `account` varchar(50) default NULL,
  `uid` int(11) default NULL,
  `username` varchar(20) default NULL,
  `on_time` int(10) default NULL,
  `oauth_id` varchar(50) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=" . DBCHARSET . " ;" );
	}

}
?>