<?php
/**
 *	[Discuz!] (C)2001-2099 Comsenz Inc.
 *	This is NOT a freeware, use is subject to license terms
 *
 *	$Id: index.inc.php 2011-12-15 11:19:27 Ian - Zhouxingming $
 */
if(!defined('IN_DISCUZ')) {
	exit('Access Denied');
}

//定义插件id
define('IN_BRAND', true);

/**
 * 载入插件模块
 * @param string $model			模块名称, 位于source/plugin/PLUGIN_ID/model/下
 *					名称为 $model.class.php
 */
function ploadmodel_brand($model) {
	$filename = DISCUZ_ROOT.'./source/plugin/brand/model/'.$model.'.class.php';
	if(file_exists($filename)) {
		include_once $filename;
	} else {
		exit('Cannot find model named '.$model);
	}
}
/**
 * 载入插件函数库
 * @param string $function		函数库名称，位于source/plugin/PLUGIN_ID/model/下
 *					名称为 $function.func.php
 */
function ploadlib_brand($function) {
	$filename = DISCUZ_ROOT.'./source/plugin/brand/model/'.$function.'.func.php';
	if(file_exists($filename)) {
		include_once $filename;
	} else {
		exit('Cannot find libfile named '.$function);
	}
}
/**
 * 插件语言包简化函数
 *
 * @param str 语言包key
 * return string
 */
function plang_brand($str, $vars = array()) {
	return lang('plugin/brand', $str, $vars);
}

/**
 * 更新 keyword 缓存
 */
function update_keyword_cache($force = 0) {
	$filename = DISCUZ_ROOT.'./data/cache/cache_brand_keyword.php';
	$filemtime = @filemtime($filename);
	if(!$filemtime || $filemtime < TIMESTAMP - 86400 || $force) {
		$query = DB::query("SELECT keyword FROM ".DB::table('brand_keyword')." LIMIT 3000");
		$keyword = array();
		while($line = DB::fetch($query)) {
			$keyword[] = $line['keyword'];
		}
		include_once libfile('function/cache');
		writetocache('brand_keyword', getcachevars(array('keyword' => $keyword)));
	} else {
		include_once $filename;
	}
	return $keyword;
}
?>
