<?php

class stBackendDesktopModule
{
   protected
      $route = null,
      $name = null,
      $icon = null,
      $valid = true,
      $label = null;

   public function  __construct($routing, $params)
   {
      static $packages = null;

      if (is_array($params))
      {
         $this->route = $params['route'];

         $this->label = $params['label'];

         $this->icon = $params['icon'];
      }
      else
      {
         if (null === $packages)
         {
            $packages = stApplication::getApps();
         }

         if ($routing->hasRouteName($params))
         {
            $this->route = '@'.$params;
         }
         else
         {
            $this->route = '@'.$params.'Default';
         }

         $this->icon = $params.'.png';

         if (isset($packages[$params]))
         {
            $this->label = $packages[$params];
         }
         else
         {
            $this->label = $params;

            $this->valid = false;
         }
      }

      try
      {
         $tmp = $routing->getRouteByName($this->route);

         $this->name = $tmp[4]['module'];
      }
      catch(sfConfigurationException $e)
      {
         $this->valid = false;
      }
   }

   public function isValid()
   {
      return $this->valid;
   }

   public function getName()
   {
      return $this->name;
   }

   public function getRoute()
   {
      return $this->route;
   }

   public function getLabel()
   {
      return $this->label;
   }

   public function getIcon()
   {
      return $this->icon;
   }

   public function getIconPath()
   {
      return 'backend/main/icons/'.$this->icon;
   }
}