<?php

/**
 * SOTESHOP/stAuthUsers 
 * 
 * Ten plik należy do aplikacji stAuthUsers opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stAuthUsers
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 251 2009-03-30 11:35:06Z marek $
 */
class sfGuardUserActions extends autosfGuardUserActions
{

   public function executeList()
   {
      parent::executeList();
      $this->pager->getCriteria()->addJoin(sfGuardUserPeer::ID, sfGuardUserGroupPeer::USER_ID);
      $this->pager->getCriteria()->addJoin(sfGuardUserGroupPeer::GROUP_ID, sfGuardGroupPermissionPeer::GROUP_ID);
      $this->pager->getCriteria()->addJoin(sfGuardPermissionPeer::ID, sfGuardGroupPermissionPeer::PERMISSION_ID);
      $this->pager->getCriteria()->add(sfGuardPermissionPeer::NAME, 'admin');
      $this->pager->init();

      $this->sf_guard_user_action_select_options = $this->getActionSelectControlOptions();
      $this->forward_parameters = array();
   }

   public function executeDelete()
   {
      if (!$this->getUser()->getGuardUser()->getIsSuperAdmin())
      {
         $this->setFlash('warning', 'Nie posiadasz uprawnień do wykonywania tej operacji');

         return $this->redirect('sfGuardUser/list?page='.$this->getRequestParameter('page', 1).'');
      }

      if ($this->getRequestParameter('sf_guard_user[selected]['.$this->getUser()->getGuardUser()->getId().']') !== null)
      {
         $this->setFlash('warning', 'Nie możesz usunąć własnego konta');

         return $this->redirect('sfGuardUser/list?page='.$this->getRequestParameter('page', 1).'');
      }

      return parent::executeDelete();
   }

   /**
    * Przeciążenie zapisu - automatyczne nadawanie grupy
    *
    * @param   sfGuardUser $sf_guard_user      Użytkownik  
    */
   protected function savesfGuardUser($sf_guard_user)
   {
      if ($this->getUser()->isSuperAdmin() == false)
      {
         $sf_guard_user->setIsSuperAdmin(false);
      }

      parent::savesfGuardUser($sf_guard_user);

      $c = new Criteria();

      $c->add(sfGuardUserGroupPeer::USER_ID, $sf_guard_user->getPrimaryKey());

      sfGuardUserGroupPeer::doDelete($c);

      $sf_guard_user->addGroupByName('admin');

      $sf_guard_user->setIsConfirm(1);

      $sf_guard_user->save();

      $c = new Criteria();
      $c->add(sfGuardPermissionPeer::NAME, 'update');
      $update = sfGuardPermissionPeer::doSelectOne($c);

      $c = new Criteria();
      $c->add(sfGuardPermissionPeer::NAME, 'backend');
      $backend = sfGuardPermissionPeer::doSelectOne($c);

      $c = new Criteria();
      $c->add(sfGuardUserPermissionPeer::USER_ID, $sf_guard_user->getId());
      $c->add(sfGuardUserPermissionPeer::PERMISSION_ID, array($backend->getId(), $update->getId()), Criteria::IN);
      sfGuardUserPermissionPeer::doDelete($c);


      if ($this->hasRequestParameter('adminPermission'))
      {
         if ($this->getRequestParameter('adminPermission[backend]') == 1)
         {
            $sf_guard_user->addPermissionByName('backend');
         }

         if ($this->getRequestParameter('adminPermission[update]') == 1)
         {
            $sf_guard_user->addPermissionByName('update');
         }
      }

      if ($sf_guard_user->getIsSuperAdmin() == 1)
      {
         $c = new Criteria();
         $c->add(sfGuardUserPermissionPeer::USER_ID, $sf_guard_user->getId());
         $c->add(sfGuardUserPermissionPeer::PERMISSION_ID, array($backend->getId(), $update->getId()), Criteria::IN);
         sfGuardUserPermissionPeer::doDelete($c);

         $sf_guard_user->addPermissionByName('backend');
         $sf_guard_user->addPermissionByName('update');
      }

      $c = new Criteria();

      $c->addJoin(sfGuardUserPermissionPeer::USER_ID, sfGuardUserPeer::ID);

      $c->addJoin(sfGuardUserPermissionPeer::PERMISSION_ID, sfGuardPermissionPeer::ID);

      $c->add(sfGuardPermissionPeer::NAME, 'update');

      $config = stConfig::getInstance($this->getContext(), 'stAuth');

      $users = sfGuardUserPeer::doSelect($c);

      $tmp = array();

      foreach ($users as $user)
      {
         $tmp[] = array('username' => $user->getUsername(), 'salt' => $user->getSalt(), 'password' => $user->getPassword());
      }

      $config->set('users', $tmp);

      $config->save();
   }

   public function validateEdit()
   {
      if (!$this->getUser()->getGuardUser()->getIsSuperAdmin())
      {
         $this->setFlash('warning', 'Nie posiadasz uprawnień do wykonywania tej operacji');

         return $this->redirect('sfGuardUser/list?page='.$this->getRequestParameter('page', 1).'');
      }

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         if ($this->getRequest()->hasParameter('id'))
         {


            $guardUser = SfGuardUserPeer::retrieveByPK($this->getRequest()->getParameter('id'));
            if (!is_object($guardUser))
            {
               $error_exists = false;

               $i18n = $this->getContext()->getI18N();


               if (!$this->getRequestParameter('sf_guard_user[password]'))
               {
                  $this->getRequest()->setError('sf_guard_user{password}', $i18n->__('Proszę podać hasło.'));
                  $error_exists = true;
               }

               if (!$this->getRequestParameter('sf_guard_user[password_bis]'))
               {
                  $this->getRequest()->setError('sf_guard_user{password_bis}', $i18n->__('Proszę podać hasło.'));
                  $error_exists = true;
               }


               return!$error_exists;
            }
         }
      }
      return true;
   }

}
