<?php     
/** 
 * SOTESHOP/stBackend 
 * 
 * Ten plik należy do aplikacji stBackend opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stBackend
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 15028 2011-09-08 08:39:41Z michal $
 * @author      Marek Jakubowicz <marek.jakubowicz@sote.pl>
 */
 
/** 
 * Akcje modułu stBackendMain.
 *
 * @package     stBackend
 * @subpackage  actions
 */
class stBackendMainActions extends stActions
{                       
     
    /**
     * Lista aplikacji.
     * Lista wyświetlana na głównej stronie backend w postaci ikonek.
     */
    public function executeList()
    {
        $backendMainConfig = stConfig::getInstance($this->getContext(), 'stBackendMain');

        if($backendMainConfig->get('is_icon_menu') == 1)
        {
            $this->apps = stApplication::getDefaultDesktopApps();
        } elseif($backendMainConfig->get('is_icon_menu') == 2) {
        	$this->apps = stApplication::getDefaultDesktopApps('app_default_all_desktop');
        }
    }

    public function executeChangeBackendView()
    {
            $backendMainConfig = stConfig::getInstance($this->getContext(), 'stBackendMain');

            $backendView = $this->getRequestParameter('backend_view');

            if($backendView == "icon")
            {
                $backendMainConfig->set('is_icon_menu', 1);
                $backendMainConfig->save();
            }
            
            if($backendView == "icon_all")
            {
                $backendMainConfig->set('is_icon_menu', 2);
                $backendMainConfig->save();
            }

            if($backendView == "info")
            {
                $backendMainConfig->set('is_icon_menu', 0);
                $backendMainConfig->save();
            }

        $this->redirect('@homepage');
    }
    
    /** 
     * Lista wszystkich zainstalowanych aplikacji.
     * Lista wyświetlana na głównej stronie backend w postaci ikonek.
     */
    public function executeListAll()
    {
        $this->apps = stApplication::getApps();   
    }
    
    public function executeOpen()
    {
        
    }
    
    public function executeTimeRequestAjax() {
    	return sfView::NONE;
    }
}
