<?php

/**
 * SOTESHOP/stCategory
 *
 * Ten plik należy do aplikacji stCategory opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stCategory
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 10063 2010-12-30 12:57:19Z marcin $
 */

/**
 * Akcje kategorii
 *
 * @author Marcin Butlak <marcin.butlak@sote.pl>
 *
 * @package     stCategory
 * @subpackage  actions
 */
class stCategoryActions extends autostCategoryActions
{
   public function executeSetRootPosition()
   {
      $id = $this->getRequestParameter("id");
      
      $move = $this->getRequestParameter('move');
      
      $node = CategoryPeer::retrieveByPK($id);
      
      if ($node->isRoot())
      {
         if ($move == 'up')
         {
            $this->treeMoveUp($node);
         }
         elseif ($move == 'down')
         {
            $this->treeMoveDown($node);
         }
      }
      
      return $this->redirect('stCategory/manager');
   }
   
   public function executeIndex()
   {
      $this->redirect('category/manager');
   }

   /**
    * Wyświetla zarządzanie kategoriami
    */
   public function executeManager()
   {
      $c = new Criteria();

      $c->add(CategoryPeer::PARENT_ID, null, Criteria::ISNULL);

      $c->addAscendingOrderByColumn(CategoryPeer::ROOT_POSITION);

      $this->roots = CategoryPeer::doSelect($c);
   }

   /**
    * Dodaje nowe drzewo kategorii
    */
   public function executeAddTree()
   {
      $treeName = $this->getRequestParameter("category_tree[tree_name]");

      if ($treeName == '')
      {
         $treeName = "Nowa kategoria";
      }

      $tree = new Category();

      $tree->setCulture('pl_PL');

      $tree->setName(addslashes($treeName));

      $tree->makeRoot();

      $tree->save();

      $tree->setScope($tree->getId());

      $tree->save();

      $this->redirect('category/manager');
   }

   /**
    * Dodaje nową kategorię do drzewa
    */
   public function executeAddCategory()
   {
      $categoryName = $this->getRequestParameter("category_tree[category_name]");

      $treeId = $this->getRequestParameter("category_tree[tree_id]");

      $c = new Criteria();

      $rootTree = CategoryPeer::retrieveByPK($treeId);

      $this->childCategory = new Category();

      $this->childCategory->setCulture('pl_PL');

      $this->childCategory->setName($categoryName);

      $this->childCategory->insertAsLastChildOf($rootTree);

      $this->childCategory->save();

      $this->redirect('category/manager');
   }

   /**
    * Aktualizuje nazwę kategorii i zwraca jej nazwę jako odpowiedź na wywołanie Ajax
    *
    * @return   string
    */
   public function executeCategorySave()
   {
      $value = $this->getRequestParameter("value");
      $id = $this->getRequestParameter("id");

      $category = CategoryPeer::retrieveByPK($id);

      $category->setCulture('pl_PL');

      if (empty($value))
      {
         return $this->renderText($category->getName());
      }

      $category->setName($value);

      $category->save();

      return $this->renderText($value);
   }

   /**
    * Usuwa całe drzewo lub gałąź kategorii
    */
   public function executeDelete()
   {
      $categoryTree = CategoryPeer::retrieveByPK($this->getRequestParameter("id"));

      $categoryTree->delete();

      $this->redirect('category/manager');
   }

   /**
    * Wiąże produkt z wybranymi kategoriami
    */
   public function executeAddToManager()
   {
      $this->product_id = $this->getRequestParameter('product_id');

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {

         $categories = $this->getRequestParameter('category');

         CategoryPeer::addProduct($this->product_id, $categories);
      }
   }

   /**
    * Informuje o błędzie dodania drzewa kategorii
    */
   public function handleErrorAddTree()
   {
      $this->forward('category', 'manager');
   }

   public function validateEdit()
   {
      if ($this->getRequest()->getMethod() == sfRequest::POST && !$this->hasRequestParameter('category[delete_image]'))
      {
         $validator = new stAssetFileValidator();

         $validator->initialize($this->getContext(), array('mime_types' => '@web_images'));

         $value = $this->getRequest()->getFileValues('category[image]');

         if (!$validator->execute($value, $error))
         {
            $this->getRequest()->setError('category{image}', $error);

            return false;
         }
      }

      return true;
   }

   /**
    * Dodaje zdjęcie do produktu
    *
    * @param Product $product Produkt
    */
   protected function saveCategoryImage($category)
   {
      if ($this->getRequest()->getFileError('category[image]') == UPLOAD_ERR_OK)
      {
         $filename = $this->getRequest()->getFileName('category[image]');

         $filepath = $this->getRequest()->getFilePath('category[image]');

         $ext = sfAssetsLibraryTools::getFileExtension($filename);

         $category->createAsset($category->getId() . '.' . $ext, $filepath);

         $category->save();
      }
   }

   protected function deleteCategoryImage($category)
   {
      if ($this->getRequestParameter('category[delete_image]'))
      {
         $category->destroyAsset();
      }
   }

   protected function saveCategory($category)
   {
      $v = strip_tags($category->getName());

      $category->setName($v);

      $this->deleteCategoryImage($category);

      parent::saveCategory($category);

      $this->saveCategoryImage($category);
   }

   protected function saveConfig()
   {
      parent::saveConfig();

      stFastCacheManager::clearCache();
   }
   
   protected function treeMoveUp(Category $node, $by = 1)
   {
      $position = $node->getRootPosition();
      
      $c = new Criteria();
      
      $c->add(CategoryPeer::ROOT_POSITION, $position - $by);
      
      $prev = CategoryPeer::doSelectOne($c);
      
      if ($prev)
      {
         $node->setRootPosition($prev->getRootPosition());
         
         $prev->setRootPosition($position);
         
         $node->save();
         
         $prev->save();
      }
   }
   
   protected function treeMoveDown(Category $node, $by = 1)
   {
      $position = $node->getRootPosition();
      
      $c = new Criteria();
      
      $c->add(CategoryPeer::ROOT_POSITION, $position + $by);
      
      $next = CategoryPeer::doSelectOne($c);
      
      if ($next)
      {
         $node->setRootPosition($next->getRootPosition());
         
         $next->setRootPosition($position);
         
         $node->save();
         
         $next->save();
      }
   }   

}
