<?php
/**
 * SOTESHOP/stWebApiPlugin
 *
 * Ten plik należy do aplikacji stWebApiPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stWebApiPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stModuleWebApi.class.php 10120 2011-01-11 11:36:18Z piotr $
 */

/**
 * Komponenty aplikacji stCategory
 *
 * @author Marcin Butlak <marcin.butlak@sote.pl>
 *
 * @package     stWebApiPlugin
 * @subpackage  libs
 */
class StCategoryWebApi extends autoStCategoryWebApi {

    /**
     * Dodawanie danych
     *
     * @param   object      $object             obiekt z parametrami
     * @return  object      okiekt z numer id dodanych danych
     * @throws WEBAPI_ADD_ERROR WEBAPI_REQUIRE_ERROR
     * @todo dodać waliadacje danych
     */
    public function AddCategory( $object )
    {
    	if (isset($object->_culture)) { $this->__setCulture($object->_culture);}    	
        stWebApi::getLogin($object->_session_hash, 'webapi_write');
        $this->TestAndValidateAddCategoryFields( $object );

        if ($object->parent_id==0) {
            $item = new Category();
            $item->setCulture('pl_PL');
            
            $item->makeRoot();
            $item->setName($object->name);
            $item->save();
            $item->setScope($item->getId());
            $item->save();

        } else {
            
            $parent = CategoryPeer::retrieveByPK($object->parent_id);
            if (!is_object($parent)) throw new SoapFault( "2", sprintf($this->__(WEBAPI_ADD_ERROR), $this->__('niepoprawny parametr parent_id')) );
            $parent->setCulture('pl_PL');
            
            $item = new Category();
            $item->setCulture('pl_PL');
            $item->setName($object->name);
            $item->insertAsLastChildOf($parent);
            $item->save();
        }

        if ( $item )
        {
            //Zapisywanie obrazka dla categorii
            if (isset($object->image) && isset($object->image_filename))
            {$this->setCategoryImage($item, $object->image_filename,$object->image);}
            if (isset($object->main_page)) {$item->setMainPage($object->main_page);}
            if (isset($object->description)) {$item->setDescription($object->description);}
            
            //Zapisywanie danych do bazy
            try {
                $item->save( );
            } catch ( Exception $e ) {
                throw new SoapFault( "2", $this->__(WEBAPI_ADD_ERROR) );
            }

            ProductHasCategoryPeer::cleanCache();
            
            // Zwracanie danych
            $object = new StdClass( );
            $this->getFieldsForAddCategory( $object, $item );
            ProductHasCategoryPeer::cleanCache();
            return $object;

        } else {
            throw new SoapFault( "1", $this->__(WEBAPI_ADD_ERROR) );
        }
    }

    public function DeleteCategory($object)
    {
        $ret = parent::DeleteCategory($object);
        
        ProductHasCategoryPeer::cleanCache();
        
        return $ret;
    }

    /**
     * Aktualizacja danych
     *
     * @param   object      $object             obiekt z parametrami
     * @return  object      obiekt z true
     * @throws WEBAPI_INCORRECT_ID WEBAPI_UPDATE_ERROR WEBAPI_REQUIRE_ERROR
     * @todo dodać walidacje danych
     */
    public function UpdateCategory( $object )
    {
    	if (isset($object->_culture)) { $this->__setCulture($object->_culture);}    	
        stWebApi::getLogin($object->_session_hash, 'webapi_write');
        $this->TestAndValidateUpdateCategoryFields( $object );

        $item = CategoryPeer::retrieveByPk( $object->id );
        if ( is_object($item) )
        {
            $item->setCulture('pl_PL');
                        
            if (isset($object->name)) {$item->setName($object->name);}
            if (isset($object->image) && isset($object->image_filename))
            {$this->setCategoryImage($item, $object->image_filename,$object->image);}
            if (isset($object->main_page)) {$item->setMainPage($object->main_page);}
            if (isset($object->description)) {$item->setDescription($object->description);}
            
            //$this->setFieldsForUpdateCategory( $object, $item );
            //Zapisywanie danych do bazy
            try {
                $item->save( );
            } catch ( Exception $e ) {
                throw new SoapFault( "2", sprintf($this->__(WEBAPI_UPDATE_ERROR), $e->getMessage()));
            }

            ProductHasCategoryPeer::cleanCache();
            
            // Zwracanie danych
            $object = new StdClass( );
            $object->_update = 1;
            return $object;
        } else {
            throw new SoapFault( "1", $this->__(WEBAPI_INCORRECT_ID) );
        }
    }

    public function getProductCategoryList( $object )
    {
    	if (isset($object->_culture)) { $this->__setCulture($object->_culture);}    	
        stWebApi::getLogin($object->_session_hash, 'webapi_read');
        $this->TestAndValidategetProductCategoryListFields( $object );

        $c = new Criteria( );

        if (isset($object->_modified_from) && isset($object->_modified_to)) {
            $criterion = $c->getNewCriterion(ProductHasCategoryPeer::UPDATED_AT, $object->_modified_from, Criteria::GREATER_EQUAL);
            $criterion->addAnd($c->getNewCriterion(ProductHasCategoryPeer::UPDATED_AT, $object->_modified_from, Criteria::LESS_EQUAL));
            $c->add($criterion);
        } else {
            if (isset($object->_modified_from)) {
                $criterion = $c->getNewCriterion(ProductHasCategoryPeer::UPDATED_AT, $object->_modified_from, Criteria::GREATER_EQUAL);
                $c->add($criterion);
            }

            if (isset($object->_modified_to)) {
                $criterion = $c->getNewCriterion(ProductHasCategoryPeer::UPDATED_AT, $object->_modified_to, Criteria::LESS_EQUAL);
                $c->add($criterion);
            }
        }
        
        if (!isset($object->_limit)) $object->_limit = 20;

        // ustawiamy kryteria wyboru
        $c->setLimit( $object->_limit );
        $c->setOffset( $object->_offset );
        $c->add(ProductHasCategoryPeer::PRODUCT_ID, $object->id);
        $items = ProductHasCategoryPeer::doSelectJoinProduct( $c );

        if ( $items )
        {
            // Zwracanie wyniku, dla wszystkich pol z tablicy 'out'
            $items_array = array();
            foreach ( $items as $item )
            {
                $object = new StdClass( );
                $this->getFieldsForgetProductCategoryList( $object, $item );
                $items_array[] = $object;
            }
            return $items_array;
        } else {
            return array( );
        }
    }

    public function setCategoryImage($item, $filename, $image)
    {
        $tmp_file = sfConfig::get('sf_cache_dir').DIRECTORY_SEPARATOR.'webapi.tmp';

        if (is_object($item->getSfAsset()))
        {
            $item->getSfAsset()->delete();
            $item->setSfAsset(null);
        }

        file_put_contents($tmp_file, base64_decode($image));
        $item->createAsset($item->getId() . '.' . pathinfo($filename, PATHINFO_EXTENSION), $tmp_file);
    }

    /** 
     * Pobieranie danych
     *
     * @param   object      $object             obiekt z parametrami
     * @return  object      okiekt z danymi
     * @throws WEBAPI_INCORRECT_ID WEBAPI_REQUIRE_ERROR
     */
    public function GetCategoryChildrens( $object )
    {
    	if (isset($object->_culture)) { $this->__setCulture($object->_culture);}    	
        stWebApi::getLogin($object->_session_hash, 'webapi_read');
        $this->TestAndValidateGetCategoryChildrensFields( $object );
        $c = new Criteria( );
        if ($object->parent_id!=0) {
            $c->add(CategoryPeer::PARENT_ID, $object->parent_id);
        } else {
            $c->add(CategoryPeer::PARENT_ID, null, Criteria::ISNULL );
        }
        
        $items = CategoryPeer::doSelect( $c );
        
        if ( $items )
        {
          // Zwracanie wyniku, dla wszystkich pol z tablicy 'out'
            $items_array = array();
            foreach ( $items as $item )
            {
                $object = new StdClass( );
                $this->getFieldsForGetCategoryChildrens( $object, $item );        
                $items_array[] = $object;
            }
            return $items_array;
        } else {
            return array( );
        }
    }   
    
}