<?php

/**
 * stFastCache actions.
 *
 * @package    soteshop
 * @subpackage stFastCache
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 9661 2010-12-01 09:45:27Z piotr $
 */
class stFastCacheActions extends autostFastCacheActions
{
	/**
	 * Executes index action
	 *
	 */
	public function executeIndex()
	{
		return $this->forward('stFastCache','config');
	}

	public function executeConfig()
	{
		if (!$this->testRequirements()) $this->forward('stFastCache','nosqlite');
			
		if ($this->getRequest()->getMethod() == sfRequest::POST)
		{
			
			$config = $this->getRequestParameter('config');
			$dbFile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'cache.db';
			$fastCacheEnabled = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'db'.DIRECTORY_SEPARATOR.'fast_cache_enabled';
			$fastCacheTimer = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'db'.DIRECTORY_SEPARATOR.'generation_time_enabled';
			//unlink if not enabled or create if enabled
			if (!isset($config['fast_cache_enabled']) && file_exists($fastCacheEnabled))
			{
				unlink($fastCacheEnabled);
				$this->clearFastCache();
			}
			if (isset($config['fast_cache_enabled']) && !file_exists($fastCacheEnabled))
			{
				touch($fastCacheEnabled);
				$this->clearFastCache();
			}

			if (!isset($config['generation_time_enabled']) && file_exists($fastCacheTimer)) unlink($fastCacheTimer);
			if (isset($config['generation_time_enabled'])) file_put_contents($fastCacheTimer, $config['generation_time_enabled']);

		}
		if ($this->hasRequestParameter('delete'))  $this->clearFastCache();
		
		parent::executeConfig();
	}

	public function executeOpen()
	{

	}

	public function executeNosqlite()
	{
			
	}

	protected function testRequirements()
	{
		if (class_exists('PDO'))
		{
			if (array_search('sqlite',PDO::getAvailableDrivers()) === false) return false;
			return true;
		}
		return false;
	}
	
	protected function clearFastCache()
	{
        stFastCacheManager::clearCache();
	}
}
