<?php
use_helper('stCurrency', 'stOrder', 'stPrice', 'stJQueryTools', 'stProductImage');
sfLoader::loadHelpers('stProduct', 'stProduct');
?>

<?php if(!$sf_user->getAttribute('edit_mode', false, 'soteshop/stOrder')): ?>
<table id="st_order-product-list" class="st_record_list" cellspacing="0" width="100%">
    <thead>
        <tr>
            <th style="padding: 3px 2px">&nbsp;</th>
            <th><?php echo __('Kod') ?></th>
            <th><?php echo __('Nazwa') ?></th>
            <th><?php echo __('Netto') ?></th>
            <th><?php echo __('Vat') ?></th>
            <th><?php echo __('Brutto') ?></th>
            <th><?php echo __('Rabat') ?></th>
            <th><?php echo __('Ilość') ?></th>
            <th><?php echo __('J.m.') ?></th>
            <th><?php echo __('Suma') ?></th>
        </tr>
    </thead>
    <tfoot>
        <tr>
            <th colspan="9" style="text-align: right"><?php echo __('Łącznie') ?>:</th>
            <th style="text-align: right"><?php echo st_order_product_total_amount($order) ?></th>
        </tr>
    </tfoot>
    <tbody>
        <?php foreach ($order->getOrderProducts() as $order_product): ?>
        <tr>
            <td style="padding: 3px 2px"><?php echo st_product_image_tag($order_product, 'icon', array('style' => 'max-height: 42px; max-width: 42px')) ?></td>
            <td><?php echo $order_product->getCode() ?></td>      
            <td class="st_record_list-item-name">
                    <?php if ($order_product->productValidate()): ?>
                        <?php echo st_external_link_to($order_product->getProduct()->getName(), 'stProduct/edit?id=' . $order_product->getProductId()) ?>
                    <?php else: ?>
                        <?php echo $order_product->getName() ?>
                    <?php endif; ?>
                    <?php if ($order_product->hasPriceModifiers() || $order_product->hasOldOptions()): ?>
                        <?php st_order_display_product_options($order_product) ?>
                    <?php endif; ?>
            </td>      
            <td style="text-align: right"><?php echo st_order_product_price($order_product) ?></td>
            <td style="text-align: right"><?php echo $order_product->getVat() ?> %</td>
            <td style="text-align: right"><?php echo st_order_product_price($order_product, true) ?></td>
            <td style="text-align: right"><?php echo $order_product->getDiscountInPercent() ?> %</td>
            <td style="text-align: right"><?php echo $order_product->getQuantity() ?></td>
            <td style="text-align: right"><?php echo st_product_uom($order_product->getProduct()) ?></td>
            <td style="text-align: right"><?php echo st_order_product_total_amount($order_product, true) ?></td>
        </tr>
        <?php endforeach; ?>
        </tbody>
</table>
<?php else: ?>
<?php
use_javascript('/jQueryTools/jquery/effects.core.js?version=2');

use_javascript('/jQueryTools/stTableRecordManager/js/script.js?version=2');

use_stylesheet('/jQueryTools/stTableRecordManager/css/style.css?version=2');

use_javascript('backend/stOrder.js?version=4');

$taxes =  TaxPeer::doSelect(new Criteria());

$tax_values = array();

foreach ($taxes as $tax)
{
    $tax_values[] = $tax->getVat();

    $tax_options[$tax->getId()] = $tax->getVatName();

    if ($tax->getIsDefault())
    {
        $default_tax = $tax->getId();
    }
}

echo form_error('order{product}', array('style' => 'color: #ff3333'));
?>
<table id="st_order-product-list" class="st_record_list st_record_manager" cellspacing="0" width="100%">
        <thead>
        <tr>
            <th><?php echo __('Kod') ?></th>
            <th><?php echo __('Nazwa') ?></th>
            <th><?php echo __('Netto') ?></th>
            <th><?php echo __('Vat') ?></th>
            <th><?php echo __('Brutto') ?></th>
            <th><?php echo __('Rabat') ?></th>
            <th><?php echo __('Netto(-%)') ?></th>
            <th><?php echo __('Brutto(-%)') ?></th>
            <th><?php echo __('Ilość') ?></th>
            <th><?php echo __('Suma') ?></th>
            <th>&nbsp;</th>
        </tr>
        <tr class="template">
            <th>
               <?php echo st_autocompleter_input_tag("code", null, array('class' => 'code-field', 'autocompleter' => array(
                  'serviceUrl' => url_for('stOrder/ajaxSearchProduct?by=code&order_id='.$order->getId()),
                  'deferRequestBy' => 300,
                  'onSelect' => 'stOrderProductPriceManagment.updateProductForm(value, data, el);',
                  'resultFormat' => 'stOrderProductPriceManagment.fnFormatResult')))?>
            </th>
            <th>
               <?php echo st_autocompleter_input_tag("name", null, array('class' => 'name-field', 'autocompleter' => array(
                  'serviceUrl' => url_for('stOrder/ajaxSearchProduct?by=name&order_id='.$order->getId()),
                  'deferRequestBy' => 300, 'minChars' => 3,
                  'onSelect' => 'stOrderProductPriceManagment.updateProductForm(value, data, el);',
                  'resultFormat' => 'stOrderProductPriceManagment.fnFormatResult')))?>
            </th>
            <th><?php echo input_tag("price_netto", '0.00', array('class' => 'price-field'))?></th>
            <th><?php echo select_tag('tax', options_for_select($tax_options, $default_tax)) ?></th>
            <th><?php echo input_tag("price_brutto", '0.00', array('class' => 'price-field'))?></th>
            <th><?php echo input_tag("discount", 0, array('class' => 'discount-field'))?>%</th>
            <th><?php echo input_tag("price_netto_discount", '0.00', array('class' => 'price-field', 'disabled' => true))?></th>
            <th><?php echo input_tag("price_brutto_discount", '0.00', array('class' => 'price-field', 'disabled' => true))?></th>
            <th><?php echo input_tag("quantity", 1, array('class' => 'quantity-field'))?></th>
            <th>
               <?php echo input_tag("total_amount", '0.00', array('class' => 'price-field', 'disabled' => true)) ?>
               <?php echo input_hidden_tag('oid', null) ?>
               <?php //echo input_hidden_tag('hidden_data', null, array('class' => 'hidden_data')) ?>
            </th>
            <th class="actions">
               <?php echo link_to(image_tag('backend/icons/add.png'), "#", array('class' => 'create')) ?>
               <?php echo link_to(image_tag('backend/icons/delete.png'), "#", array('class' => 'remove')) ?>
            </th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($order->getOrderProducts() as $index => $order_product): if ($order_product->isDeleted()) continue; ?>
        <?php if (form_has_error('order{product}{'.$index.'}{code}')): ?>
        <tr class="errors">
           <td colspan="11"><?php echo form_error('order{product}{'.$index.'}{code}') ?></td>
        </tr>
        <?php endif; ?>
        <?php if (form_has_error('order{product}{'.$index.'}{name}')): ?>
        <tr class="errors">
           <td colspan="11"><?php echo form_error('order{product}{'.$index.'}{name}') ?></td>
        </tr>
        <?php endif; ?>
        <tr>
            <td class="<?php echo form_has_error('order{product}{'.$index.'}{code}') ? 'errors' : 'none' ?>"><?php echo input_tag("order[product][".$index."][code]", $order_product->getCode(), array('class' => 'code-field')) ?></td>
            <td class="<?php echo form_has_error('order{product}{'.$index.'}{name}') ? 'errors' : 'none' ?>">
               <?php echo input_tag("order[product][".$index."][name]", $order_product->getName(), array('class' => 'name-field'))?>
                 <?php if ($order_product->hasPriceModifiers() || $order_product->hasOldOptions()): ?>
                 <div class="product-options-container"><span><?php echo $order_product->getPriceModifierLabels(); ?></span></div>
                 <?php endif; ?>
            </td>
            <td><?php echo input_tag("order[product][".$index."][price_netto]", $order_product->getPriceNetto(true, false), array('class' => 'price-field'))?></td>
            <td><?php echo select_tag("order[product][".$index."][tax]", options_for_select($tax_options, $order_product->getTaxId())); ?></td>
            <td><?php echo input_tag("order[product][".$index."][price_brutto]", stPrice::round($order_product->getPriceBrutto(true, false)), array('class' => 'price-field'))?></td>
            <td><?php echo input_tag("order[product][".$index."][discount]", $order_product->getDiscountInPercent(), array('class' => 'discount-field'))?>%</td>
            <td><?php echo input_tag("order[product][".$index."][price_netto_discount]", $order_product->getPriceNetto(true), array('class' => 'price-field', 'disabled' => true))?></td>
            <td><?php echo input_tag("order[product][".$index."][price_brutto_discount]", $order_product->getPriceBrutto(true), array('class' => 'price-field', 'disabled' => true))?></td>
            <td><?php echo input_tag("order[product][".$index."][quantity]", $order_product->getQuantity(), array('class' => 'quantity-field'))?></td>
            <td>
               <?php echo input_tag("order[product][".$index."][total_amount]", $order_product->getTotalAmount(true, true), array('class' => 'price-field', 'disabled' => true)) ?>
               <?php
               echo input_hidden_tag('order[product]['.$index.'][oid]', $order_product->getId());
               /*
               $hidden_data = array('id' => $order_product->getProductId(), 'io' => $order_product->getImage());
               
               if ($order_product->hasPriceModifiers() || $order_product->hasOldOptions())
               {
                  $hidden_data['pm'] = $order_product->getPriceModifiers();
               }
               
               echo input_hidden_tag('order[product]['.$index.'][hidden_data]', json_encode($hidden_data), array('class' => 'hidden_data'));
                */
               ?>
            </td>
            <td class="actions">
               <?php echo link_to(image_tag('backend/icons/delete.png'), '#', array('class' => 'remove')) ?>
            </td>
        </tr>
        <?php endforeach; ?>
        </tbody>    
</table>
<div id="st_order-autocomplete-template">
   <div class="st_order-autocomplete-item">
      <div class="image"><img src="" alt="" /></div>
      <div class="content">
         <h2></h2>
         <ul>
            <li><b><?php echo __('Cena:') ?></b> <?php echo $order->getOrderCurrency()->getFrontSymbol() ?><span class="price_netto"></span> <?php echo $order->getOrderCurrency()->getBackSymbol() ?> / <?php echo $order->getOrderCurrency()->getFrontSymbol() ?><span class="price_brutto"></span> <?php echo $order->getOrderCurrency()->getBackSymbol() ?></li>
         </ul>
      </div>
   </div>
</div>
<script type="text/javascript">
   stOrderProductPriceManagment.setParams({taxValues: <?php echo json_encode($tax_values) ?>});
   jQuery(function($) {

      stOrderPriceModifiers.params.url = '<?php echo st_url_for('stOrder/ajaxPriceModifiers') ?>';

      $('#st_order-product-list').stTableRecordManager({ namespace: 'order[product]', confirmMsg: '<?php echo __('Jesteś pewien?', null, 'stAdminGeneratorPlugin') ?>'});

      $('#st_order-product-list').bind('preRemove', function(event, row)
      {
         row = row.prev('tr');
         
         while(row.hasClass('errors'))
         {
            var tmp = row.prev('tr');
            row.remove();
            row = tmp;
         }
      });

      $('#st_order-product-list').bind('postAdd', function(event, row, fields) {
         $.each(fields, function() {
            $(this).css('background-color', $(this).attr('prev-background-color'));
         });

         new stOrderProductPriceManagment(fields);

         $(fields.discount).after('%');
         /*
         var hidden_data = $(fields.hidden_data).val().evalJSON(true);

         if (hidden_data.pm != undefined && hidden_data.pm.length)
         {
            
            var options_container = $(this).find('.template .product-options-container').clone();

            options_container.children('span').html(stOrderProductPriceManagment.getPriceModifiersLabel(hidden_data.pm));

            options_container.children('a').toggle(
            function(){
               var target = $(this);

               target.html('<?php echo  __('ukryj') ?>');

               stOrderPriceModifiers.show(target);
            },
            function() {
               var target = $(this);

               stOrderPriceModifiers.hide(target);

               target.html('<?php echo  __('zmień') ?>');
            });

            $(fields.name).after(options_container);
         }
         */

         stOrderProductPriceManagment.updateTotalAmount(fields);
      });

      /*
      $('.product-options-container a').toggle(
      function(){
         var target = $(this);

         target.html('<?php echo  __('ukryj') ?>');

         stOrderPriceModifiers.show(target, '<?php echo st_url_for('stOrder/ajaxPriceModifiers') ?>');
      },
      function() {
         var target = $(this);

         stOrderPriceModifiers.hide(target);

         target.html('<?php echo  __('zmień') ?>');
      });
      */
   });

document.observe("dom:loaded", function()
{
   $$('#st_order-product-list tr').each(function(tr)
   {
      var fields = tr.select('input', 'select');
      if (fields.size())
      {
         new stOrderProductPriceManagment({
            price_netto: fields[2],
            price_brutto: fields[3],
            tax: fields[10],
            discount: fields[4],
            price_netto_discount: fields[5],
            price_brutto_discount: fields[6],
            quantity: fields[7],
            total_amount: fields[8]
         });
      }
   });
});
</script>
<?php endif; ?>