<?php use_helper('stCurrency'); ?>
<div id="st_component-stOrderEdit_Payment"> 
   <?php if (!$sf_user->getAttribute('edit_mode', false, 'soteshop/stOrder')): ?>
      <table class="st_record_list" cellspacing="0" width="100%">
         <thead>
            <tr>
               <th><?php echo __('Data dokonania płatności') ?></th>
               <th><?php echo __('Typ płatności') ?></th>
               <th><?php echo __('Kwota') ?></th>
               <th><?php echo __('Rozliczona') ?></th>
            </tr>
         </thead>
         <tbody>
            <?php foreach ($payments as $index => $ohp): $payment = $ohp->getPayment(); ?>
               <tr>
                  <td>
                     <?php echo $payment->getPayedAt() ? st_format_date($payment->getPayedAt()) : '-' ?>
                     <?php echo input_hidden_tag('order[payment][' . $index . '][payment_id]', $payment->getId()) ?>
                  </td>
                  <?php if ($payment->getGiftCard()): ?>
                     <td><?php echo st_external_link_to(__('Bon towarowy: %code%', array('%code%' => $payment->getGiftCard()->getCode())), 'stGiftCardBackend/edit?id=' . $payment->getGiftCard()->getId()) ?></td>
                  <?php else: ?>
                     <td><?php echo $payment->getPaymentType() ?></td>
                  <?php endif; ?>
                  <td><?php echo st_order_price_format($payment->getAmount(), $order->getOrderCurrency()) ?></td>
                  <td>
                     <?php echo checkbox_tag('order[payment][' . $index . '][payment_status]', 1, $payment->getStatus(), array('disabled' => $payment->getGiftCard())); ?>
                     <?php if ($payment->getGiftCard()): ?>
                        <?php echo input_hidden_tag('order[payment][' . $index . '][payment_status]', true); ?>               
                     <?php endif; ?>
                  </td>
               </tr>
            <?php endforeach; ?>
         </tbody>
      </table>
   <?php else: ?>
      <table id="st_record_manager-payment" class="st_record_list st_record_manager" cellspacing="0" width="100%">
         <thead>
            <tr>
               <th><?php echo __('Data dokonania płatności') ?></th>
               <th><?php echo __('Typ') ?></th>
               <th><?php echo __('Kwota') ?></th>
               <th><?php echo __('Rozliczona') ?></th>
               <th>&nbsp;</th>
            </tr>
            <tr class="template">
               <th>&nbsp;<?php echo input_hidden_tag('payment_id', null) ?></th>
               <th><?php echo select_tag("payment_type", options_for_select($paymentsType)) ?></th>
               <th><?php echo input_tag("payment_amount", '0.00', array('class' => 'price-field')) ?></th>
               <th><?php echo checkbox_tag("payment_status", true, false) ?></th>
               <th class="actions">
                  <?php echo link_to(image_tag('backend/icons/add.png'), "#", array('class' => 'create')) ?>
                  <?php echo link_to(image_tag('backend/icons/delete.png'), "#", array('class' => 'remove')) ?>
               </th>            
            </tr>        
         </thead>
         <tbody>
            <?php foreach ($payments as $index => $ohp): $payment = $ohp->getPayment() ?>
               <tr>
                  <td>
                     <?php echo $payment->getPayedAt() ? st_format_date($payment->getPayedAt()) : '-' ?>
                     <?php echo input_hidden_tag('order[payment][' . $index . '][payment_id]', $payment->getId()) ?>
                  </td>
                  <?php if ($payment->getGiftCard()): ?>
                     <td><?php echo st_external_link_to($payment->getGiftCard()->getCode(), 'stGiftCardBackend/edit?id=' . $payment->getGiftCard()->getId()) ?></td>
                  <?php else: ?>            
                     <td><?php echo select_tag("order[payment][" . $index . "][payment_type]", options_for_select($paymentsType, $payment->getPaymentTypeId())) ?></td>
                  <?php endif; ?> 
                  <td>
                     <?php echo input_tag('order[payment][' . $index . '][payment_amount]', stPrice::round($payment->getAmount()), array('disabled' => $payment->getGiftCard() || $payment->getStatus(), 'class' => 'price-field')) ?>              
                  </td>
                  <td>               
                     <?php echo checkbox_tag('order[payment][' . $index . '][payment_status]', 1, $payment->getStatus(), array('disabled' => $payment->getGiftCard())); ?>
                     <?php if ($payment->getGiftCard()): ?>
                        <?php echo input_hidden_tag('order[payment][' . $index . '][payment_status]', true); ?>               
                     <?php endif; ?>
                  </td>
                  <td class="actions">
                     <?php if (!$payment->getGiftCard()): ?>               
                        <?php echo link_to(image_tag('backend/icons/delete.png'), '#', array('class' => 'remove')) ?>
                     <?php endif; ?>
                  </td>            
               </tr>
            <?php endforeach; ?>
         </tbody>
      </table>
   <?php endif; ?>
</div>

<script type="text/javascript">
   jQuery(function($) {
      $('#st_record_manager-payment').stTableRecordManager({ namespace: 'order[payment]', confirmMsg: '<?php echo __('Jesteś pewien?', null, 'stAdminGeneratorPlugin') ?>'});
      $('#payment_amount').change(function() { $(this).val(stPrice.fixNumberFormat($(this).val())); });
      $('#st_record_manager-payment').bind('postAdd', function(event, row, fields) {
      
         $(fields.payment_amount).val(stPrice.fixNumberFormat($(fields.payment_amount).val()));
      
         $(fields.payment_amount).change(function() {
            $(this).val(stPrice.fixNumberFormat($(this).val()));
         });
      });
   });

</script>