<?php use_helper('I18N', 'stAdminGenerator') ?>
<?php echo st_get_admin_head('stPriceCompare', __('Przypomnienia'), __('Zarządzanie produktami w porównywarkach cen, konfiguracja ustawień.'), NULL) ?>  
    <div id="sf_admin_content">

        <div class="st_horizontal_list">
            <ul>
                <li class="none"><?php echo link_to(__('Dodawanie produktów do porównywarek cen'), '@stPriceCompareDefault')?></li>
                <li class="st_horizontal_list-item-selected"><?php echo link_to(__('Przypomnienia'), 'stPriceCompare/remind')?></li>
                <li class="none""><?php echo link_to(__('Konfiguracja'), 'stPriceCompare/config')?></li>
                <li class="st_horizontal_list-item-clear"></li>
            </ul>
        </div>

        <?php if ($sf_flash->has('notice')): ?>
            <div class="save-ok">
                <h2><?php echo __($sf_flash->get('notice'), array(), 'stAdminGeneratorPlugin') ?></h2>
            </div>
        <?php endif; ?>
        <div id="sf_admin_content_config">
            <?php echo form_tag('price_compare/remind', array('id' => 'sf_admin_config_form', 'name' => 'sf_admin_config_form')) ?>
                <table cellspacing="0" class="st_record_list">
                    <tr>
                        <th id="sf_admin_list_th_id"><?php echo __('Nazwa<br/> porównywarki cen') ?></th>
                        <th id="sf_admin_list_th_id"><?php echo __('Przypomnij co<br/> (ilość dni)') ?></th>
                        <th id="sf_admin_list_th_id"><?php echo __('Data ostatnio<br/> wygenerowanego pliku') ?></th>
                        <th id="sf_admin_list_th_id"><?php echo __('Data najbliższego<br/> przypomnienia') ?></th>
                        <th id="sf_admin_list_th_id"><?php echo __('Włącz') ?></th>
                    </tr>
                    <?php $i = 1;?>
                    <?php foreach ($plugins as $key => $plugin):?>
                        <tr<?php if($i%2) echo ' class="st_row-highlight"'?>>
                            <td><?php echo $plugin['name'];?></td>
                            <td><?php echo input_tag('price_compare['.$key.'_days]',$config->get($key.'_days'),array('size' => 1, 'style' => 'text-align: center'))?></td>
                            <td>
                                <?php if(is_object($priceComparesFromDb[$key])):?>
                                    <?php echo $priceComparesFromDb[$key]->getGeneratedAt();?>
                                <?php endif;?>
                            </td>
                            <td>
                                <?php if(is_object($priceComparesFromDb[$key])):?>
                                    <?php echo date('Y-m-d H:i:s', $priceComparesFromDb[$key]->getGeneratedAt(null)+($config->get($key.'_days')*24*60*60));?>
                                <?php endif;?>
                            </td>
                            <td><?php echo checkbox_tag('price_compare['.$key.']',1,$config->get($key));?></td> 
                        </tr>
                    <?php $i++;?>
                    <?php endforeach; ?>
                </table>

                <?php echo st_get_admin_actions_head('style="margin-top: 10px; float: right"') ?>
                    <?php echo st_get_admin_action('save', __('Zapisz', array(), 'stAdminGeneratorPlugin'), null, array('name' => 'save')) ?>
                <?php echo st_get_admin_actions_foot() ?>
            </form>
        </div>    
    </div>
    <br class="st_clear_all" />
<?php echo st_get_admin_foot() ?>