<?php
/** 
 * SOTESHOP/stProducer 
 * 
 * Ten plik należy do aplikacji stProducer opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stProducer
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 617 2009-04-09 13:02:31Z michal $
 * @author      Bartosz Alejski <bartosz.alejski@sote.pl>
 */

/** 
 * Klasa wymagana do poprawnej pracy modułu producentów
 *
 * @package     stProducer
 * @subpackage  actions
 */
class stProducerActions extends autostProducerActions
{
    protected function saveProducerImage($producer)
    {
        if ($this->getRequest()->getFileError('producer[image]') == UPLOAD_ERR_OK)
        {
            $filename = $this->getRequest()->getFileName('producer[image]');

            $filepath = $this->getRequest()->getFilePath('producer[image]');

            $ext = sfAssetsLibraryTools::getFileExtension($filename);

            $producer->createAsset($producer->getId() . '.' . $ext, $filepath);

            $producer->save();
        }
    }

    protected function saveProducer($producer)
    {
        if ($this->hasRequestParameter('producer[delete_image]'))
        {
            $producer->destroyAsset();
        }

        parent::saveProducer($producer);

        $this->saveProducerImage($producer);
    }

    public function validateEdit()
    {
      if ($this->getRequest()->getMethod() == sfRequest::POST && !$this->hasRequestParameter('producer[delete_image]'))
      {
         $validator = new stAssetFileValidator();

         $validator->initialize($this->getContext(), array('mime_types' => '@web_images'));

         $value = $this->getRequest()->getFileValues('producer[image]');

         if (!$validator->execute($value, $error))
         {
            $this->getRequest()->setError('producer{image}', $error);

            return false;
         }
      }

      return true;
    }
}