<?php

/**
 * SOTESHOP/stProduct
 *
 * Ten plik należy do aplikacji stProduct opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stProduct
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 2545 2009-08-11 13:58:21Z pawel $
 */

/**
 * Akcje stProduct
 *
 * @author Marcin Butlak <marcin.butlak@sote.pl>
 * @author Marcin Olejncizak <marcin.olejniczak@sote.pl>
 * @author Krzysztof Beblo <krzysztof.beblo@sote.pl>
 *
 * @package     stProduct
 * @subpackage  actions
 */
class stProductActions extends autostProductActions
{

   public function executeAjaxFilterCategory()
   {
      $pk = str_replace('cf-trigger-', '', $this->getRequestParameter('id'));

      sfLoader::loadHelpers('stPartial');

      $params = array('include_container' => false);

      $c = new Criteria();

      $c->add(CategoryPeer::PARENT_ID, null, Criteria::ISNULL);

      if ($pk == 'null')
      {
         $roots = CategoryPeer::doSelect($c);

         if (isset($roots[1]))
         {
            $params['children'] = $roots;
         }
         elseif ($roots)
         {
            $params['parent'] = $roots[0];
         }
      }
      else
      {
         $parent = CategoryPeer::retrieveByPK($pk);

         if (!$parent->getParentId() && CategoryPeer::doCount($c) > 1)
         {
            $params['return_value'] = array('return_id' => 'null', 'label' => $parent->getName(), 'id' => null);
         }
         elseif ($parent->getParentId())
         {
            $params['return_value'] = array('return_id' => $parent->getParentId(), 'label' => $parent->getName(), 'id' => $parent->getId());
         }

         $params['parent'] = $parent;
      }



      return $this->renderText(st_get_partial('stProduct/category_filter', $params));
   }

   public function executeList()
   {
      parent::executeList();

      $this->pager->getCriteria()->setDistinct();

      $this->pager->init();
   }

   public function executeFetchCategories()
   {
      $node = $this->getRequestParameter('node');

      $parent = CategoryPeer::retrieveByPK($node);

      $product = null;

      $product_id = $this->getRequestParameter('product_id');

      if ($product_id)
      {
         $product = ProductPeer::retrieveByPk($product_id);
      }

      if (null === $product)
      {
         $product = new Product();
      }

      $output = '';

      $extjs_data = array();

      if ($parent)
      {
         $assigned = $this->processAssignedCategories($product, $parent);

         if (null === $assigned && $parent->isRoot())
         {
            $assigned = $this->fetchAssignedCategories($product, $parent);
         }

         $extjs_data = $this->fetchCategoriesRecursive($parent, $assigned);

         $output = json_encode($extjs_data);
      }

      $this->getResponse()->setHttpHeader('Content-Type', 'application/json');

      return $this->renderText($output);
   }

   protected function addSortCriteria($c)
   {
      if ($sort_column = $this->getUser()->getAttribute('sort', null, 'sf_admin/autoStProduct/sort'))
      {
         $sort_column = $this->translateSortColumn($sort_column);

         if ($sort_column == ProductPeer::CODE)
         {
            if ($this->getUser()->getAttribute('type', null, 'sf_admin/autoStProduct/sort') == 'asc')
            {

               $c->addAscendingOrderByColumn($sort_column.' + 0');
            }
            else
            {
               $c->addDescendingOrderByColumn($sort_column.' + 0');
            }
         }
      }
      
      parent::addSortCriteria($c);
   }

   protected function processAssignedCategories(Product $product, Category $parent)
   {
      $user = $this->getUser();

      $product_id = $product->isNew() ? $this->getRequestParameter('product_hash') : $product->getId();

      $assigned = $this->getRequestParameter('assigned-categories');

      if ($assigned)
      {
         $assigned = explode('-', $assigned);
      }

      $arr = array();

      $category_filter = null;

      if ($product->isNew() && !$assigned)
      {
         $category_filter = $this->getUser()->getAttribute('category_filter', null, 'soteshop/stProduct');

         if ($category_filter)
         {
            $assigned = array($category_filter);
         }
      }

      if (null !== $assigned)
      {
         $c = new Criteria();

         $c->add(CategoryPeer::ID, $assigned, Criteria::IN);

         $c->add(CategoryPeer::SCOPE, $parent->getScope());

         $categories = CategoryPeer::doSelect($c);

         $default = $this->getRequestParameter('default-category', $category_filter);

         foreach ($categories as $category)
         {
            $id = $category->getId();

            $arr[$id]['default'] = $default == $id;

            $arr[$id]['lft'] = $category->getLft();

            $arr[$id]['rgt'] = $category->getRgt();
         }
      }

      return null !== $assigned ? $arr : null;
   }

   protected function fetchAssignedCategories(Product $product, Category $category)
   {
      $arr = array();

      $c = new Criteria();

      $c->add(ProductHasCategoryPeer::PRODUCT_ID, $product->getId());

      $c->add(CategoryPeer::SCOPE, $category->getScope());

      $phcs = ProductHasCategoryPeer::doSelectJoinCategory($c);

      foreach ($phcs as $phc)
      {
         $id = $phc->getCategoryId();

         $arr[$id]['default'] = $phc->getIsDefault();

         $arr[$id]['lft'] = $phc->getCategory()->getLft();

         $arr[$id]['rgt'] = $phc->getCategory()->getRgt();
      }

      return $arr;
   }

   protected function fetchCategoriesRecursive(Category $parent, $assigned = array())
   {
      $items = array();

      $categories = $parent->getChildren();

      foreach ($categories as $category)
      {
         $id = $category->getId();

         $item = array('id' => $category->getId(), 'extended', 'text' => $category->getName(), 'in_category' => false);

         if (isset($assigned[$id]))
         {
            $item['default_category'] = $assigned[$id]['default'];

            $item['in_category'] = true;
         }

         if ($category->hasChildren() && $this->categoryIsExpandable($category, $assigned))
         {
            $item['children'] = $this->fetchCategoriesRecursive($category, $assigned);

            $item['expanded'] = true;
         }

         $items[] = $item;
      }

      return $items;
   }

   protected function categoryIsExpandable($category, $assigned)
   {
      if ($assigned)
      {
         foreach ($assigned as $k => $v)
         {
            if ($category->getRgt() > $v['rgt'] && $category->getLft() < $v['lft'])
            {
               return true;
            }
         }
      }

      return false;
   }

   /**
    * Zapisuje atrybuty produktu
    *
    * @param       Product     $product
    */
   protected function saveAttributes($product)
   {

      $attribute_fields = $this->getRequestParameter('attribute_field', array());

      $product_id = $product->getId();

      $c = new Criteria();
      $c->add(ProductHasAttributeFieldPeer::PRODUCT_ID, $product_id);
      ProductHasAttributeFieldPeer::doDelete($c);
      if (is_array($attribute_fields))
      {
         foreach ($attribute_fields as $id => $value)
         {
            $product_has_attribute_field = new ProductHasAttributeField();
            $product_has_attribute_field->setValue($value);
            $product_has_attribute_field->setProductId($product_id);
            $product_has_attribute_field->setAttributeFieldId($id);
            $product_has_attribute_field->save();
         }
      }
   }

   /**
    * Dodaje produkt do wybranych kategorii
    *
    * @param       Product     $product
    */
   protected function saveProductInCategory($product)
   {
      $categories = $this->getRequestParameter('product_has_category', array());

      $default_id = $this->getRequestParameter('product_default_category', isset($categories[0]) ? $categories[0] : null);

      $product_id = $product->getId();

      $c = new Criteria();

      $c->add(ProductHasCategoryPeer::PRODUCT_ID, $product_id);

      ProductHasCategoryPeer::doDelete($c);

      foreach ($categories as $id)
      {
         $pc = new ProductHasCategory();

         $pc->setProductId($product_id);

         $pc->setCategoryId($id);

         if ($default_id == $id)
         {
            $pc->setIsDefault(true);
         }

         $pc->save();
      }
   }

   public function executeConfig()
   {
      parent::executeConfig();

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         stFunctionCache::clearFrontendModule('stProduct', 'product');
         stFastCacheManager::clearCache();
      }
   }

   public function executePresentationConfig()
   {

      $i18n = $this->getContext()->getI18N();

      $this->forward_parameters = $this->getUser()->getAttributeHolder()->getAll('sf_admin/autoStProduct/presentation_forward_parameters');

      $this->config = $this->loadPresentationConfigOrCreate();

      $this->labels = $this->getPresentationConfigLabels();

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $this->updatePresentationConfigFromRequest();

         $this->savePresentationConfig();

         stFastCacheManager::clearCache();

         $this->setFlash('notice', $i18n->__('Twoje zmiany zostały zapisane', null, 'stAdminGeneratorPlugin'));

         return $this->redirect('stProduct/presentationConfig');
      }
   }

   /**
    * Przeciązenie aktualizowania ceny produktu
    *
    */
   protected function updateProductFromRequest()
   {
      $product = $this->getRequestParameter('product');

      parent::updateProductFromRequest();

      $this->product->setHidePrice(isset($product['hide_price']));

      if ($this->product->getCurrency()->getIsSystemCurrency())
      {
         if (isset($product['price_netto']))
         {
            $this->product->setPriceNetto($product['price_netto']);
         }

         if (isset($product['price_brutto']))
         {
            $this->product->setPriceBrutto($product['price_brutto']);
         }

         if (isset($product['old_price_netto']))
         {
            $this->product->setOldPriceNetto($product['old_price_netto']);
         }

         if (isset($product['old_price_brutto']))
         {
            $this->product->setOldPriceBrutto($product['old_price_brutto']);
         }

         $this->product->setCurrencyPrice(null);

         $this->product->setCurrencyOldPrice(null);

         $this->product->setHasFixedCurrency(false);

         $this->product->setCurrencyExchange(1);
      }
      else
      {
         if (isset($product['price_brutto']))
         {
            $this->product->setCurrencyPrice($product['price_brutto']);
         }

         if (isset($product['old_price_brutto']))
         {
            $this->product->setCurrencyOldPrice($product['old_price_brutto']);
         }

         if (isset($product['has_fixed_currency_exchange']))
         {
            $this->product->setHasFixedCurrency(true);

            $this->product->setCurrencyExchange($product['fixed_currency_exchange']);
         }
         else
         {
            $this->product->setHasFixedCurrency(false);
         }
      }
   }

   /**
    * Przeciażenie zapisywania produktu
    *
    * @param       Product     $product
    */
   protected function saveProduct($product)
   {
      parent::saveProduct($product);

      $this->saveProductInCategory($product);

      $this->saveProductImage($product);
   }

   /**
    * Ustawianie kodu przy dodawniu produktu
    */
   public function executeEdit()
   {
      sfLoader::loadHelpers(array('Helper', 'stProduct'), 'stProduct');

      parent::executeEdit();

      $default_code = $this->getDefaultCode();
      if (!$this->product->getCode())
      {
         $this->product->setCode($default_code);
      }
   }

   public function validateEdit()
   {
      $product = $this->getRequestParameter('product');

      $request = $this->getRequest();

      $i18n = $this->getContext()->getI18N();

      if ($request->getMethod() == sfRequest::POST)
      {
         if ($product['max_qty'] > 0 && $product['min_qty'] > $product['max_qty'])
         {
            $request->setError('product{min_qty}', $i18n->__('Minimalna ilość nie może być większa od maksymalnej ilości'));
         }
      }

      return!$request->hasErrors();
   }

   public function handleErrorEdit()
   {
      sfLoader::loadHelpers(array('Helper', 'stProduct'), 'stProduct');

      return parent::handleErrorEdit();
   }

   /**
    * Przeciążenie wyświetlania galerii produktu - ograniczenie zdjęć do danego produktu
    *
    */
   public function executeGalleryList()
   {
      parent::executeGalleryList();

      $this->pager->getCriteria()->add(ProductHasSfAssetPeer::PRODUCT_ID, $this->forward_parameters['product_id']);

      $this->pager->getCriteria()->add(ProductHasSfAssetPeer::IS_DEFAULT, false);

      $this->pager->getCriteria()->addAscendingOrderByColumn(ProductHasSfAssetPeer::ID);

      $this->pager->init();
   }

   public function executeAttachmentList()
   {
      parent::executeAttachmentList();

      $this->pager->getCriteria()->add(ProductHasAttachmentPeer::PRODUCT_ID, $this->forward_parameters['product_id']);

      $this->pager->getCriteria()->addAscendingOrderByColumn(ProductHasAttachmentPeer::ID);

      $this->pager->init();
   }

   /**
    * Pokazuje domyślny kod produktu, na podstawie id produktu
    *
    * @return  domyślny   kod produktu
    */
   private function getDefaultCode()
   {
      $c = new Criteria();
      $c->addDescendingOrderByColumn('id');
      $product = ProductPeer::doSelectOne($c);
      if ($product)
      {
         $num = $product->getId() + 1;
      }
      else
      {
         $num = 1;
      }
      return $num;
   }

   protected function saveConfig()
   {
      stFunctionCache::clearFrontendModule('stProduct', 'product');
      $this->config->save();
   }

   /**
    * Dodaje zdjęcie do produktu
    *
    * @param Product $product Produkt
    */
   protected function saveProductImage($product)
   {
      if ($this->getRequest()->getFileError('product[edit_image]') == UPLOAD_ERR_OK)
      {
         $filename = $this->getRequest()->getFileName('product[edit_image]');

         $filepath = $this->getRequest()->getFilePath('product[edit_image]');

         $product_has_asset = new ProductHasSfAsset();

         $product_has_asset->setProduct($product);

         $product_has_asset->setIsDefault(true);

         $product_has_asset->createAsset($filename, $filepath, ProductHasSfAssetPeer::IMAGE_FOLDER);

         $product_has_asset->save();
      }
   }

   /**
    * Przeciążenie metody pobierającej obiekt ProductHasSfAsset
    *
    * @param string $id Nazwa parametru zawierająca id
    * @return ProductHasSfAsset
    */
   protected function getGalleryProductHasSfAssetOrCreate($id = 'id')
   {
      $product_has_sf_asset = parent::getGalleryProductHasSfAssetOrCreate($id);

      $product_has_sf_asset->setProductId($this->forward_parameters['product_id']);

      return $product_has_sf_asset;
   }

   protected function getAttachmentProductHasAttachmentOrCreate($id = 'id')
   {
      $product_has_attachment = parent::getAttachmentProductHasAttachmentOrCreate($id);

      $product_has_attachment->setProductId($this->forward_parameters['product_id']);

      return $product_has_attachment;
   }

   protected function saveAttachmentProductHasAttachment($product_has_attachment)
   {
      $custom_name = $product_has_attachment->getAttachmentEditFilename();

      if ($this->getRequest()->getFileError('product_has_attachment[attachment_edit_file]') == UPLOAD_ERR_OK)
      {
         $filename = $this->getRequest()->getFileName('product_has_attachment[attachment_edit_file]');

         $filepath = $this->getRequest()->getFilePath('product_has_attachment[attachment_edit_file]');

         if ($custom_name)
         {
            $ext = sfAssetsLibraryTools::getFileExtension($filename);

            $filename = $custom_name.'.'.$ext;
         }

         $product_has_attachment->createAsset($filepath, $filename, false);
      }
      else
      {
         $product_has_attachment->renameAsset($custom_name);
      }

      parent::saveAttachmentProductHasAttachment($product_has_attachment);
   }

   protected function deleteAttachmentProductHasAttachment($product_has_attachment)
   {
      parent::deleteAttachmentProductHasAttachment($product_has_attachment);

      $product_has_attachment->getsfAsset()->delete();
   }

   public function validateAttachmentEdit()
   {
      $ok = true;

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $id = $this->getRequestParameter('id');

         $validator = new stAssetFileValidator();

         $validator->initialize($this->getContext(), array('mime_types' => null, 'required' => !$id));

         $value = $this->getRequest()->getFileValues('product_has_attachment[attachment_edit_file]');

         if (!$validator->execute($value, $error))
         {
            $this->getRequest()->setError('product_has_attachment{attachment_edit_file}', $error);

            return false;
         }

         $c = new Criteria();

         $product_id = $this->getRequestParameter('product_id');

         $product = ProductPeer::retrieveByPK($product_id);

         $filename = $this->getRequestParameter('product_has_attachment[attachment_edit_filename]');

         if ($pk = $this->getRequestParameter('id'))
         {
            $pha = ProductHasAttachmentPeer::retrieveByPK($pk);

            $uploaded_filename = $pha->getSfAsset()->getFilename();

            $check_filename = $pha->getAttachmentEditFilename() != $filename;

            $culture = $pha->getOptCulture();
         }
         else
         {
            $check_filename = true;

            $language = LanguagePeer::retrieveByPK($this->getRequestParameter('product_has_attachment[attachment_edit_language]'));

            if ($language)
            {
               $culture = $language->getOriginalLanguage();
            }
         }

         if ($this->getRequest()->getFileError('product_has_attachment[attachment_edit_file]') == UPLOAD_ERR_OK)
         {
            $uploaded_filename = $this->getRequest()->getFileName('product_has_attachment[attachment_edit_file]');
         }

         $ext = sfAssetsLibraryTools::getFileExtension($uploaded_filename);

         if ($check_filename && sfAssetPeer::retrieveFromUrl('/media/products/'.$product->getAssetFolder().'/attachments/'.$culture.'/'.$filename.'.'.$ext))
         {
            $this->getRequest()->setError('product_has_attachment{attachment_edit_filename}', 'Załącznik o podanej nazwie już istnieje...');

            $ok = false;
         }
      }

      return $ok;
   }

   /**
    * Przeciążenie zapisu - upload zdjęcia
    *
    * @param ProductHasSfAsset $product_has_sf_asset Relacja zdjęcia z produktem
    */
   protected function saveGalleryProductHasSfAsset($product_has_sf_asset)
   {
      $image_desc = $product_has_sf_asset->getGalleryEditImageDesc();

      $image_name = $product_has_sf_asset->getGalleryEditImageName();

      if ($this->getRequest()->getFileError('product_has_sf_asset[gallery_edit_image]') == UPLOAD_ERR_OK)
      {
         $filename = $this->getRequest()->getFileName('product_has_sf_asset[gallery_edit_image]');

         $filepath = $this->getRequest()->getFilePath('product_has_sf_asset[gallery_edit_image]');

         $product_has_sf_asset->createAsset($filename, $filepath, null, $image_name, $image_desc, false);
      }
      else
      {
         $product_has_sf_asset->renameAsset($image_name);

         $product_has_sf_asset->setAssetDescription($image_desc);
      }

      parent::saveGalleryProductHasSfAsset($product_has_sf_asset);
   }

   /**
    * Przeciążenie usuwania - fizyczne usuwanie zdjęcia
    *
    * @param ProductHasSfAsset $product_has_sf_asset Relacja zdjęcia z produktem
    */
   protected function deleteGalleryProductHasSfAsset($product_has_sf_asset)
   {
      parent::deleteGalleryProductHasSfAsset($product_has_sf_asset);

      $product_has_sf_asset->getsfAsset()->delete();

      if ($product_has_sf_asset->getIsDefault())
      {
         $c = new Criteria();

         $c->addAscendingOrderByColumn(ProductHasSfAssetPeer::ID);

         $c->add(ProductHasSfAssetPeer::PRODUCT_ID, $product_has_sf_asset->getProductId());

         $pha = ProductHasSfAssetPeer::doSelectOne($c);

         if ($pha)
         {
            $pha->setIsDefault(true);

            $pha->save();
         }
         else
         {
            $product = $product_has_sf_asset->getProduct();

            $product->setOptImage(null);

            $product->save();
         }
      }
   }

   /**
    * Walidacja akcji galleryEdit
    */
   public function validateGalleryEdit()
   {
      $ok = true;

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $id = $this->getRequestParameter('id');

         $validator = new stAssetFileValidator();

         $validator->initialize($this->getContext(), array('mime_types' => '@web_images', 'required' => !$id));

         $value = $this->getRequest()->getFileValues('product_has_sf_asset[gallery_edit_image]');

         if (!$validator->execute($value, $error))
         {
            $this->getRequest()->setError('product_has_sf_asset{gallery_edit_image}', $error);

            return false;
         }

         $c = new Criteria();

         $product_id = $this->getRequestParameter('product_id');

         $product = ProductPeer::retrieveByPK($product_id);

         $filename = $this->getRequestParameter('product_has_sf_asset[gallery_edit_image_name]');

         if ($pk = $this->getRequestParameter('id'))
         {
            $phc = ProductHasSfAssetPeer::retrieveByPK($pk);

            $uploaded_filename = $phc->getSfAsset()->getFilename();

            $check_filename = $phc->getGalleryEditImageName() != $filename;
         }
         else
         {
            $check_filename = true;
         }

         if ($this->getRequest()->getFileError('product_has_sf_asset[gallery_edit_image]') == UPLOAD_ERR_OK)
         {
            $uploaded_filename = $this->getRequest()->getFileName('product_has_sf_asset[gallery_edit_image]');
         }

         $ext = sfAssetsLibraryTools::getFileExtension($uploaded_filename);

         if ($check_filename && sfAssetPeer::retrieveFromUrl('/media/products/'.$product->getAssetFolder().'/images/'.$filename.'.'.$ext))
         {
            $this->getRequest()->setError('product_has_sf_asset{gallery_edit_image_name}', 'Zdjęcie o podanej nazwie już istnieje...');

            $ok = false;
         }
      }

      return $ok;
   }

   public function executeFixCode()
   {
      $this->checked = $this->getRequestParameter('checked');
   }

   /**
    * Poprawne filtry w produkcie
    *
    */
   public function executeFixProducts()
   {
      
   }

   /**
    * Tymczasowa poprawka filtrowania po producencie
    *
    * @author Marcin Butlak <marcin.butlak@sote.pl>
    *
    */
   protected function addFiltersCriteria($c)
   {
      parent::addFiltersCriteria($c);

      if (isset($this->filters['producer_is_empty']))
      {
         $criterion = $c->getNewCriterion(ProducerI18nPeer::NAME, '');
         $criterion->addOr($c->getNewCriterion(ProducerI18nPeer::NAME, null, Criteria::ISNULL));
         $c->add($criterion);
      }
      else
      {
         if (isset($this->filters['producer']) && $this->filters['producer'] !== '')
         {

            $c->addJoin(ProductPeer::PRODUCER_ID, ProducerI18nPeer::ID);
            $c->add(ProducerI18nPeer::ID, null, Criteria::ISNOTNULL);
         }
      }

      if (($category = $this->getRequestParameter('category_filter')) !== null)
      {
         $this->getUser()->setAttribute('category_filter', $category, 'soteshop/stProduct');
      }

      $category_filter = $this->getUser()->getAttribute('category_filter', null, 'soteshop/stProduct');

      $cc = new Criteria();

      $cc->add(CategoryPeer::ID, $category_filter);

      if ($category_filter && CategoryPeer::doCount($cc))
      {
         $c->addJoin(ProductHasCategoryPeer::PRODUCT_ID, ProductPeer::ID);

         $c->add(ProductHasCategoryPeer::CATEGORY_ID, $category_filter);
      }
      else
      {
         $this->getUser()->setAttribute('category_filter', null, 'soteshop/stProduct');
      }
   }

   /**
    * Zapisywanie wyglądu karty produktu
    *
    */
   protected function updatePresentationConfigFromRequest()
   {
      parent::updatePresentationConfigFromRequest();

      $config = $this->getRequestParameter('config');
   }

   public function handleErrorPresentationConfig()
   {
      $this->preExecute();
      $this->forward_parameters = $this->getUser()->getAttributeHolder()->getAll('sf_admin/autoStProduct/forward_parameters');

      $this->config = $this->loadPresentationConfigOrCreate();

      $this->labels = $this->getPresentationConfigLabels();

      $this->updatePresentationConfigFromRequest();

      return sfView::SUCCESS;
   }

   /**
    * Zduplikuj produkt
    *
    */
   public function executeDuplicate()
   {
      $i18n = $this->getContext()->getI18N();

      if ($this->hasRequestParameter('product_id'))
      {
         $id = $this->getRequestParameter('product_id');
      }
      else
      {
         $id = $this->getRequestParameter('id');
      }

      $default_culture = $this->getUser()->getCulture();
      $product = ProductPeer::retrieveByPK($id);

      $c = new Criteria();
      $c->add(ProductPeer::PARENT_ID, $id);
      $c->add(ProductPeer::CODE, '%'.$product->getCode().'DUPL%', Criteria::LIKE);
      $c->addDescendingOrderByColumn('created_at');
      $last_duplicate = ProductPeer::doSelectOne($c);

      if ($last_duplicate)
      {
         $last_duplicate_array = explode('-', $last_duplicate->getCode());
         $num_value = count($last_duplicate_array) - 1;
         $last_duplicate_num = $last_duplicate_array[$num_value];
         $num_duplicated = $last_duplicate_num + 1;

         $c = new Criteria();
         $c->add(ProductPeer::PARENT_ID, $id);
         $duplicates = ProductPeer::doSelect($c);
         foreach ($duplicates as $duplicate)
         {
            if ($duplicate->getCode() == $product->getCode().'DUPL-'.$num_duplicated)
            {
               $num_duplicated = $num_duplicated + 100;
            }
         }
      }
      else
      {
         $num_duplicated = 1;
      }

      $duplicate_product = $product->copy();
      $duplicate_product->setCreatedAt(time());
      $duplicate_product->setCulture($default_culture);
      $duplicate_product->setActive(0);
      $duplicate_product->setCode($product->getCode().'DUPL-'.$num_duplicated);
      $duplicate_product->setName($product->getName()." ".$i18n->__('Duplikat')."-".$num_duplicated);
      $duplicate_product->setOptName($product->getName()." ".$i18n->__('Duplikat')."-".$num_duplicated);
      $duplicate_product->setDescription($product->getDescription());
      $duplicate_product->setShortDescription($product->getShortDescription());
      $duplicate_product->setParentId($id);
      $duplicate_product->setOptAssetFolder(null);
      $duplicate_product->save();


      // duplikuje zdjęcie produktu
      $c = new Criteria();
      $c->add(ProductHasSfAssetPeer::PRODUCT_ID, $id);
      $phas = ProductHasSfAssetPeer::doSelectJoinsfAsset($c);
      foreach ($phas as $pha)
      {
         $tmp = new ProductHasSfAsset();
         $tmp->setProduct($duplicate_product);
         $tmp->setIsDefault($pha->getIsDefault());
         $tmp->createAsset($pha->getSfAsset()->getFilename(), $pha->getSfAsset()->getFullPath(), null, null, $pha->getSfAsset()->getDescription(), false, false);
         $tmp->save();
      }
      unset($phas);

//        //duplikuje nazwe produktu
      $c = new Criteria();
      $c->add(ProductI18nPeer::ID, $id);
      $productI18ns = ProductI18nPeer::doSelect($c);
      foreach ($productI18ns as $productI18n)
      {
         $culture = $productI18n->getCulture();
         if ($culture != $default_culture)
         {
            $duplicate_product_i18n = $productI18n->copy();
            $duplicate_product_i18n->setCulture($culture);
            $duplicate_product_i18n->setUrl($productI18n->getUrl().'-duplicate-'.$num_duplicated);
            $duplicate_product_i18n->setName($productI18n->getName().' Duplicate-'.$num_duplicated);
            $duplicate_product_i18n->setId($duplicate_product->getId());
            $duplicate_product_i18n->save();
         }
      }
      unset($productI18ns);

      //duplikuje kategorie produktu
      $c = new Criteria();
      $c->add(ProductHasCategoryPeer::PRODUCT_ID, $id);
      $product_has_categories = ProductHasCategoryPeer::doSelect($c);
      foreach ($product_has_categories as $product_has_category)
      {
         $duplicate_product_has_category = $product_has_category->copy();
         $duplicate_product_has_category->setProductId($duplicate_product->getId());
         $duplicate_product_has_category->save();
      }
      unset($product_has_categories);

      //duplikuje pozycjonowanie
      $c = new Criteria();
      $c->add(ProductHasPositioningPeer::PRODUCT_ID, $id);
      $product_has_positioning = ProductHasPositioningPeer::doSelectOne($c);
      if ($product_has_positioning)
      {
         $duplicate_product_has_positioning = $product_has_positioning->copy();
         $duplicate_product_has_positioning->setProductId($duplicate_product->getId());
         $duplicate_product_has_positioning->save();

         $c = new Criteria();
         $c->add(ProductHasPositioningI18nPeer::ID, $product_has_positioning->getId());
         $product_has_positioning_i18ns = ProductHasPositioningI18nPeer::doSelect($c);
         foreach ($product_has_positioning_i18ns as $product_has_positioning_i18n)
         {
            $culture = $product_has_positioning_i18n->getCulture();
            $duplicate_product_has_positioning_i18n = $product_has_positioning_i18n->copy();
            $duplicate_product_has_positioning_i18n->setCulture($culture);
            $duplicate_product_has_positioning_i18n->setId($duplicate_product_has_positioning->getId());
            $duplicate_product_has_positioning_i18n->save();
         }

         unset($product_has_positioning_i18ns);
      }

      //duplikuje grupy produku
      $c = new Criteria();
      $c->add(ProductGroupHasProductPeer::PRODUCT_ID, $id);
      $product_has_groups = ProductGroupHasProductPeer::doSelect($c);
      foreach ($product_has_groups as $product_has_group)
      {
         $duplicate_product_has_group = $product_has_group->copy();
         $duplicate_product_has_group->setProductId($duplicate_product->getId());
         $duplicate_product_has_group->save();
      }


      stEventDispatcher::getInstance()->notify(new sfEvent($this, 'stProductActions.postExecuteDuplicate', array('id' => $id, 'duplicate_id' => $duplicate_product->getId())));

      $this->redirect("stProduct/edit?id=".$duplicate_product->getId());
   }

   /**
    *  Pokaż liste duplikatów
    */
   public function executeDuplicateList()
   {
      parent::executeDuplicateList();

      $this->pager->getCriteria()->add(ProductPeer::PARENT_ID, $this->forward_parameters['product_id']);

      $this->pager->getCriteria()->setDistinct();

      $this->pager->init();
   }

   protected function updateListItem($product, $request)
   {
      parent::updateListItem($product, $request);

      if (isset($request['price_brutto']))
      {
         $product->setPriceBrutto($request['price_brutto']);

         $product->setPriceNetto(null);
      }
   }

   public function validateUpdateList()
   {
      $ok = true;

      $request = $this->getRequest();

      if ($request->getMethod() == sfRequest::POST)
      {
         $products = $request->getParameter('product', array());

         $code_validator = new stProductCodeValidator();

         $code_validator->initialize($this->getContext());

         foreach ($products as $id => $data)
         {
            if ($id == 'selected')
            {
               continue;
            }

            if (isset($data['code']))
            {
               $code_validator->setParameter('primary_key', $id);

               if (!$code_validator->execute($data['code'], $error))
               {
                  $request->setError('product{'.$id.'}{code}', $error);

                  $ok = false;
               }
            }
         }
      }

      return $ok;
   }

   public function handleErrorUpdateList()
   {
      $this->getRequest()->getParameterHolder()->remove('filters');

      $this->executeList();

      $this->setTemplate('list');

      return sfView::SUCCESS;
   }

   public function executeProductEnable()
   {
      $products = ProductPeer::retrieveByPKs($this->getRequestParameter('product[selected]', array()));

      foreach ($products as $product)
      {
         $product->setActive(true);

         $product->save();
      }

      return $this->redirect('stProduct/list?page='.$this->getRequestParameter('page', 1));
   }

   public function executeProductDisable()
   {
      $products = ProductPeer::retrieveByPKs($this->getRequestParameter('product[selected]', array()));

      foreach ($products as $product)
      {
         $product->setActive(false);

         $product->save();
      }

      return $this->redirect('stProduct/list?page='.$this->getRequestParameter('page', 1));
   }

   public function executeDelete()
   {
      $forward_parameters = $this->getUser()->getAttributeHolder()->getAll('sf_admin/autoStProduct/forward_parameters');
      $ids = $this->getRequestParameter('product[selected]', array($this->getRequestParameter('id')));

      foreach ($ids as $id)
      {
         // usuwa powiązania z duplikowanymi produktami
         $c = new Criteria();
         $c->add(ProductPeer::PARENT_ID, $id);
         $products = ProductPeer::doSelect($c);

         foreach ($products as $product)
         {
            $product->setParentId(NULL);
            $product->save();
         }

         if (!$this->processDelete($id))
         {
            break;
         }
      }

      return $this->redirect('stProduct/list?page='.$this->getRequestParameter('page', 1).'');
   }

}