<?php

use_helper('Asset', 'stPrice', 'I18N');

function object_product_stock_in_decimals(Product $product, $method, $options)
{
   if ($product->getStepQty() > 0)
   {
      $options['disabled'] = true;
   }
   
   return checkbox_tag($options['control_name'], true, $product->getStockInDecimals(), $options);
}

function object_product_step_qty(Product $product, $method, $options)
{
   $id = get_id_from_name($options['control_name']);
   
   $js =<<<JS
   <script type="text/javascript">
      jQuery(function($)
      {
         $('#$id').change(function(){
            $('#product_stock_in_decimals').attr('checked' , this.value > 0);
            $('#product_stock_in_decimals').attr('disabled' , this.value > 0);
         });
      });
   </script>
JS;
   
   return object_product_price($product, $method, $options).$js;
}

function object_product_weight(Product $product, $method, $options)
{
   return object_product_price($product, $method, $options).' kg';
}

function object_product_stock(Product $product, $method, $options)
{
   $value = object_product_price($product, $method, $options);

   if ($product->getOptHasOptions())
   {
      $value .= st_get_component('stProductOptionsBackend', 'productStockEdit', array('product' => $product));
   }
   
   return $value;
}

function object_product_uom($product, $method, $options)
{
   return input_tag($options['control_name'], st_product_uom($product), $options);
}

function object_product_price(Product $product, $method, $options)
{
   $name = $options['control_name'];

   unset($options['control_name']);

   if (!isset($options['size']))
   {
      $options['size'] = 8;
   }
   if (!isset($options['maxlength']))
   {
      $options['maxlength'] = 11;
   }

   $js = st_price_add_format_behavior(get_id_from_name($name));

   return input_tag($name, st_price_format($product->$method()), $options).$js;
}

function st_product_uom($product)
{
   static $uom = null;

   if (null === $uom)
   {
      $uom = __('szt.', null, 'stDepositoryFrontend');
   }

   return $product && $product->getUom() ? $product->getUom() : $uom;
}

function st_product_check_price_type()
{
   $config = stConfig::getInstance(sfContext::getInstance(), 'stProduct');

   return $config->get('price_type');
}

function st_product_get_attachment_icon($attachment)
{
   $types = array('archive' => true, 'txt' => true, 'image' => true, 'pdf' => true);

   $type = isset($types[$attachment->getType()]) ? $attachment->getType() : 'txt';

   return image_tag('/images/frontend/theme/default/attachments/'.$type.'.gif', array('alt' => ''));
}

function st_product_category_filter($parent)
{
   if (is_object($parent))
   {
      $children = $parent->getChildren();
   }
   else
   {
      $children = $parent;
   }

   $content = '';

   $is_first = true;

   foreach ($children as $child)
   {
      $content .= _st_category_filter_item($child, strtr(microtime(true), '.', '-').'-'.$child->getId(), $is_first);

      $is_first = false;
   }

   return content_tag('ul', $content);
}

function _st_category_filter_item(Category $item, $item_id, $is_first = false)
{
   $params = array();

   $has_children = $item->hasChildren();

   if ($has_children)
   {
      $params['class'] = 'expandable loadable';

      $children = content_tag('div', strtotime($item->getUpdatedAt()), array('id' => 'sub-categories-'.$item_id, 'class' => 'sub-categories', 'style' => 'display: none;'));

      $expand_icon = content_tag('span', '&rsaquo;');
   }
   else
   {
      $children = '';

      $expand_icon = '';
   }

   if ($is_first)
   {
      $params['class'] = isset($params['class']) ? $params['class'].' first' : 'first';
   }

   return content_tag('li', $children.link_to($item->getName().$expand_icon, '@stProductCategoryFilter?category_id='.$item->getId()), $params);
}