<?php

/**
 * SOTESHOP/stProduct
 *
 * Ten plik należy do aplikacji stProduct opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stProduct
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stModuleImportExport.class.php 617 2009-04-09 13:02:31Z michal $
 */
class stProductImportExport extends autoStProductImportExport
{

   public static function ImportValidateCode($value, $product_code)
   {
      if (preg_match('/[\'"]/', $value))
      {
         stImportExportLog::getActiveLogger()->add($product_code, sfContext::getInstance()->getI18n()->__('Kod produktu nie może zawierać znakow \' oraz "'), 2);

         return false;
      }

      return true;
   }

   public static function ImportValidateMinQty($value, $product_code, $data)
   {
      if ($data['max_qty'] > 0 && $value > $data['max_qty'])
      {
         stImportExportLog::getActiveLogger()->add($product_code, sfContext::getInstance()->getI18n()->__('Minimalna ilość nie może być większa od maksymalnej ilości', null, 'stProduct'), 2);

         return false;
      }

      return true;
   }

   public static function ImportValidateCurrencyExchange($value, $product_code, $data)
   {
      if (empty($value) && $value !== 0)
      {
         return true;
      }

      if (!is_numeric($value))
      {
         $context = sfContext::getInstance();

         stImportExportLog::getActiveLogger()->add($product_code, $context->getI18n()->__('Kurs "%%exchange%%" posiada nieprawidłowy format (poprawny format: 10, 10.0000)', array('%%exchange%%' => $value)), 2);

         return false;
      }

      return true;
   }

   public static function ImportValidateCurrencyIso($value, $product_code, $data)
   {
      if (empty($value))
      {
         $context = sfContext::getInstance();

         stImportExportLog::getActiveLogger()->add($product_code, $context->getI18n()->__('Brak ustawionej waluty'), 2);

         return false;
      }

      if (CurrencyPeer::retrieveByIso($value) === null)
      {
         $context = sfContext::getInstance();

         stImportExportLog::getActiveLogger()->add($product_code, $context->getI18n()->__('Waluta "%%currency%%" nie istnieje', array('%%currency%%' => $value)), 2);

         return false;
      }

      return true;
   }

   public static function ImportValidateOldPriceNetto($value, $product_code, $data)
   {
      $context = sfContext::getInstance();

      if (!self::validatePriceFormat($context, $value))
      {
         $message = $context->getI18n()->__('Stara cena netto "%%price%%" posiada nieprawidłowy format (poprawny format: 10, 10.00).', array('%%price%%' => $value));

         stImportExportLog::getActiveLogger()->add($product_code, $message, 2);

         return false;
      }

      if (!empty($value) && $data['old_price_brutto'] && self::validateNettoBrutto($value, $data['old_price_brutto'], $data['vat_value'], $data['currency_iso']) == false)
      {
         stImportExportLog::getActiveLogger()->add($product_code, $context->getI18n()->__('Stara cena netto nie pokrywa się z ceną brutto (jeżeli chcesz zmienić cenę netto usuń cenę brutto).'), 2);

         return false;
      }

      return true;
   }

   public static function ImportValidateOldPriceBrutto($value, $product_code, $data)
   {
      $context = sfContext::getInstance();

      if (!self::validatePriceFormat($context, $value))
      {
         $message = $context->getI18n()->__('Stara cena brutto "%%price%%" posiada nieprawidłowy format (poprawny format: 10, 10.00).', array('%%price%%' => $value));

         stImportExportLog::getActiveLogger()->add($product_code, $message, 2);

         return false;
      }

      if (!empty($value) && $data['old_price_netto'] && self::validateNettoBrutto($data['old_price_netto'], $value, $data['vat_value'], $data['currency_iso']) == false)
      {
         stImportExportLog::getActiveLogger()->add($product_code, $context->getI18n()->__('Stara cena brutto nie pokrywa się z ceną netto (jeżeli chcesz zmienić cenę brutto usuń cenę netto).'), 2);

         return false;
      }

      return true;
   }

   public static function ImportValidatePriceNetto($value, $product_code, $data)
   {
      $context = sfContext::getInstance();

      if (!self::validatePriceFormat($context, $value))
      {
         $message = $context->getI18n()->__('Cena netto "%%price%%" posiada nieprawidłowy format (poprawny format: 10, 10.00).', array('%%price%%' => $value));

         stImportExportLog::getActiveLogger()->add($product_code, $message, 2);

         return false;
      }

      if (!empty($value) && $data['price_brutto'] && self::validateNettoBrutto($value, $data['price_brutto'], $data['vat_value'], $data['currency_iso']) == false)
      {
         stImportExportLog::getActiveLogger()->add($product_code, $context->getI18n()->__('Cena netto nie pokrywa się z ceną brutto (jeżeli chcesz zmienić cenę netto usuń cenę brutto).'), 2);

         return false;
      }

      return true;
   }

   public static function ImportValidatePriceBrutto($value, $product_code, $data)
   {
      $context = sfContext::getInstance();

      if (!self::validatePriceFormat($context, $value))
      {
         $message = $context->getI18n()->__('Cena brutto "%%price%%" posiada nieprawidłowy format (poprawny format: 10, 10.00).', array('%%price%%' => $value));

         stImportExportLog::getActiveLogger()->add($product_code, $message, 2);

         return false;
      }

      if (!empty($value) && $data['price_netto'] && self::validateNettoBrutto($data['price_netto'], $value, $data['vat_value'], $data['currency_iso']) == false)
      {
         stImportExportLog::getActiveLogger()->add($product_code, $context->getI18n()->__('Cena brutto nie pokrywa się z ceną netto (jeżeli chcesz zmienić cenę brutto usuń cenę netto).'), 2);

         return false;
      }

      return true;
   }

   public static function validatePriceFormat($context, $value)
   {
      $nv = new sfNumberValidator();

      $nv->initialize($context, array(
          'min' => 0,
          'type' => 'any'
      ));

      return empty($value) || $nv->execute($value, $error) == true;
   }

   public static function validateNettoBrutto($netto, $brutto, $tax, $currency)
   {
      $config = stConfig::getInstance(null, 'stCurrencyPlugin');

      if ($currency != $config->get('default_currency'))
      {
         return true;
      }

      return stPrice::round($netto) == stPrice::extract($brutto, $tax) || stPrice::round($brutto) == stPrice::calculate($netto, $tax);
   }

   public static function setCurrencyExchange($product, $value, $logger, $data)
   {
      $config = stConfig::getInstance(null, 'stCurrencyPlugin');

      if ($value && $data['currency_iso'] != $config->get('default_currency'))
      {
         $product->setCurrencyExchange($value);

         $product->setHasFixedCurrency(true);
      }
      else
      {
         $product->setHasFixedCurrency(false);

         $product->setCurrencyExchange($product->getCurrency()->getExchange());
      }
   }

   public static function getCurrencyExchange($product)
   {
      return $product->getHasFixedCurrency() ? stPrice::round($product->getCurrencyExchange(), 4) : null;
   }

   public static function getPriceNetto($product)
   {
      return $product->getCurrencyExchange() == 1 ? stPrice::round($product->getPriceNetto()) : null;
   }

   public static function setPriceBrutto($product, $value, $logger, $data)
   {
      $config = stConfig::getInstance(null, 'stCurrencyPlugin');

      if ($data['currency_iso'] == $config->get('default_currency'))
      {
         $product->setPriceBrutto($value);

         $product->setCurrencyPrice(null);
      }
      else
      {
         $product->setCurrencyPrice($value);
      }
   }

   public static function setOldPriceBrutto($product, $value, $logger, $data)
   {
      $config = stConfig::getInstance(null, 'stCurrencyPlugin');

      if ($data['currency_iso'] == $config->get('default_currency'))
      {
         $product->setOldPriceBrutto($value);

         $product->setCurrencyOldPrice(null);
      }
      else
      {
         $product->setCurrencyOldPrice($value);
      }
   }

   public static function getPriceBrutto($product)
   {
      return $product->getCurrencyExchange() == 1 ? $product->getPriceBrutto() : $product->getCurrencyPrice();
   }

   public static function getOldPriceNetto($product)
   {
      return $product->getCurrencyExchange() == 1 ? stPrice::round($product->getOldPriceNetto()) : null;
   }

   public static function getOldPriceBrutto($product)
   {
      return $product->getCurrencyExchange() == 1 ? $product->getOldPriceBrutto() : $product->getCurrencyOldPrice();
   }
   
   public static function getUom($product)
   {
      return $product->getUom() ? $product->getUom() : sfContext::getInstance()->getI18N()->__('szt.');
   }

   public static function ImportValidateName($value, $product_code, $data)
   {
      if (strlen(trim($value)) == 0)
      {
         stImportExportLog::getActiveLogger()->add($product_code, sfContext::getInstance()->getI18n()->__('Nazwa produktu jest pusta'), 2);
         return false;
      }
      return true;
   }

}

