<?php
/**
 * SOTESHOP/stWebApiPlugin
 *
 * Ten plik należy do aplikacji stWebApiPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stWebApiPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stModuleWebApi.class.php 13533 2011-06-08 11:06:50Z piotr $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

define( "WEBAPI_CATEGORY_ERROR", "Kategoria o id %d nie istenieje.");
define( "WEBAPI_AVAILABILITY_ERROR", "Dostępność o id %d nie istenieje.");

/**
 * Klasa stProductWebApi
 *
 * @package     stWebApiPlugin
 * @subpackage  libs
 */
class StProductWebApi extends autoStProductWebApi
{
	public function AddProduct( $object )
	{
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}
		stWebApi::getLogin($object->_session_hash, 'webapi_write');
		$this->TestAndValidateAddProductFields( $object );

		if (preg_match('/["\']/', $object->code))
		{
			throw new SoapFault( "2", sprintf($this->__(WEBAPI_ADD_ERROR), $this->__("Niedozwolony kod produktu.")));
		}

		if (isset($object->category_id) && !CategoryPeer::retrieveByPK($object->category_id))
		throw new SoapFault( "2", sprintf($this->__(WEBAPI_ADD_ERROR), $this->__("kategoria o id").' '.$object->category_id.' '.$this->__("nie istnieje")));
		if (isset($object->producer_id) && !ProducerPeer::retrieveByPK($object->producer_id))
		throw new SoapFault( "2", sprintf($this->__(WEBAPI_ADD_ERROR), $this->__("producent o id").' '.$object->producer_id.' '.$this->__("nie istnieje")) );
		if (isset($object->tax_id) && !TaxPeer::retrieveByPK($object->tax_id))
		throw new SoapFault( "2", sprintf($this->__(WEBAPI_ADD_ERROR), $this->__("VAT o id").' '.$object->tax_id.' '.$this->__("nie istnieje")) );
		if (isset($object->weight) && $object->weight<0) $object->weight = 0.0;
		
		$c = new Criteria();
		$c->add(ProductPeer::CODE, $object->code);
		if (is_object(ProductPeer::doSelectOne($c))) {
			throw new SoapFault( "2", sprintf($this->__(WEBAPI_ADD_ERROR), $this->__("produkt o kodzie").' '.$object->code.' '.$this->__("już istnieje")) );
		}

		$item = new Product( );
		if ( $item )
		{
			$this->setFieldsForAddProduct( $object, $item );
			//Zapisywanie danych do bazy
			try {
				//w przypadku gdy nie ma tax id ustaw domyslny
				if (!isset($object->tax_id)) {
					$c_tax = new Criteria();
					$c_tax->add(TaxPeer::IS_DEFAULT, 0, Criteria::GREATER_THAN);
					$tax = TaxPeer::doSelectOne($c_tax);
				} else {
					$tax = TaxPeer::retrieveByPk($object->tax_id);
				}
				if (is_object($tax)) $item->setTax($tax);
				else throw new SoapFault( "2", sprintf($this->__(WEBAPI_ADD_ERROR), $this->__("Proszę podać poprawną wartość pola vat_id")));
				
				$this->setProductPrices($item, $object);

				$item->save( );
				$languages = LanguagePeer::doSelect(new Criteria());
				foreach ($languages as $lang) {
					stSimpleSearch::getInstance()->buildIndex($item, $lang->getOriginalLanguage());
					stAdvancedSearch::getInstance()->buildIndex($item, $lang->getOriginalLanguage());
				}

				$category = CategoryPeer::retrieveByPK($object->category_id);
				if ($category) {
					$producHasCategory = new ProductHasCategory();
					$producHasCategory->setProductId($item->getId());
					$producHasCategory->setCategoryId($object->category_id);
					$producHasCategory->setIsDefault(true);
					$producHasCategory->save();
				}

			} catch ( Exception $e ) {
				throw new SoapFault( "2", sprintf($this->__(WEBAPI_ADD_ERROR), $this->__("błąd podczas zapisu: ").$e->getMessage()));
			}

			// Zwracanie danych
			$object = new StdClass( );
			$this->getFieldsForAddProduct( $object, $item );
			return $object;

		} else {
			throw new SoapFault( "1", $this->__(WEBAPI_ADD_ERROR) );
		}
	}


	/**
	 * Aktualizacja danych
	 *
	 * @param   object      $object             obiekt z parametrami
	 * @return  object      obiekt z true
	 * @throws WEBAPI_INCORRECT_ID WEBAPI_UPDATE_ERROR WEBAPI_REQUIRE_ERROR
	 * @todo dodać walidacje danych
	 */
	public function UpdateProduct( $object )
	{
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}
		stWebApi::getLogin($object->_session_hash, 'webapi_write');
		$this->TestAndValidateUpdateProductFields( $object );

		if (isset($object->code))
		{
			if (preg_match('/["\']/', $object->code))
			{
				throw new SoapFault( "2", sprintf($this->__(WEBAPI_UPDATE_ERROR), $this->__("Niedozwolony kod produktu.")));
			}
		}

		if (isset($object->category_id) && !CategoryPeer::retrieveByPK($object->category_id))
		throw new SoapFault( "2", sprintf($this->__(WEBAPI_UPDATE_ERROR), $this->__("kategoria o id").' '.$object->category_id.' '.$this->__("nie istnieje")) );
		if (isset($object->producer_id) && !ProducerPeer::retrieveByPK($object->producer_id))
		throw new SoapFault( "2", sprintf($this->__(WEBAPI_UPDATE_ERROR), $this->__("producent o id").' '.$object->producer_id.' '.$this->__("nie istnieje")) );
		if (isset($object->tax_id) && !TaxPeer::retrieveByPK($object->tax_id))
		throw new SoapFault( "2", sprintf($this->__(WEBAPI_UPDATE_ERROR), $this->__("VAT o id").' '.$object->tax_id.' '.$this->__("nie istnieje")) );
		if (isset($object->weight) && $object->weight<0) $object->weight = 0.0;
		
		$item = ProductPeer::retrieveByPk( $object->id );
		if ( $item )
		{
			$this->setFieldsForUpdateProduct( $object, $item );
			//Zapisywanie danych do bazy
			try {
				if (isset($object->category_id)) $this->UpdateDefaultCategory($object->id, $object->category_id);
				$this->setProductPrices($item, $object);

				$item->save( );

				$languages = LanguagePeer::doSelect(new Criteria());
				foreach ($languages as $lang) {
					stSimpleSearch::getInstance()->buildIndex($item, $lang->getOriginalLanguage());
					stAdvancedSearch::getInstance()->buildIndex($item, $lang->getOriginalLanguage());
				}
			} catch ( Exception $e ) {
				throw new SoapFault( "2", sprintf($this->__(WEBAPI_UPDATE_ERROR),$e->getMessage()) );
			}

			// Zwracanie danych
			$object = new StdClass( );
			$object->_update = 1;
			return $object;

		} else {
			throw new SoapFault( "1", $this->__(WEBAPI_INCORRECT_ID));
		}
	}

	public function UpdateDefaultCategory($product_id, $category_id)
	{
		
		$c = new Criteria();
		$c->add(ProductHasCategoryPeer::PRODUCT_ID, $product_id);
		$c->add(ProductHasCategoryPeer::CATEGORY_ID, $category_id);

		$producHasCategory = ProductHasCategoryPeer::doSelectOne($c);
		if(is_object($producHasCategory)) {
			$producHasCategory->setIsDefault(true);
			$producHasCategory->save();
		} else {
			$producHasCategory = new ProductHasCategory();
			$producHasCategory->setProductId($product_id);
			$producHasCategory->setCategoryId($category_id);
			$producHasCategory->setIsDefault(true);
			$producHasCategory->save();
		}

	}

	public function AssignProductToCategory( $object )
	{
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}
		stWebApi::getLogin($object->_session_hash, 'webapi_write');
		$this->TestAndValidateAssignProductToCategoryFields( $object );

		$item = ProductPeer::retrieveByPk( $object->id );
		if ( $item )
		{
			$category = CategoryPeer::retrieveByPK($object->category_id);
			if (!$category) {
				throw new SoapFault( "2", sprintf($this->__(WEBAPI_CATEGORY_ERROR),$object->category_id ) );
			} else {
				$c = new Criteria();
				$c->add(ProductHasCategoryPeer::PRODUCT_ID, $object->id );
				$c->add(ProductHasCategoryPeer::CATEGORY_ID, $object->category_id );
				$producHasCategory = ProductHasCategoryPeer::doSelectOne($c);
				if (!$producHasCategory) {
					$producHasCategory = new ProductHasCategory();
					$producHasCategory->setProductId($item->getId());
					$producHasCategory->setCategoryId($object->category_id);
					$producHasCategory->save();
				}
			}
			// Zwracanie danych
			$object = new StdClass( );
			$object->_update = 1;
			return $object;

		} else {
			throw new SoapFault( "1", $this->__(WEBAPI_INCORRECT_ID) );
		}
	}

	public function RemoveProductFromCategory( $object )
	{
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}
		stWebApi::getLogin($object->_session_hash, 'webapi_write');
		$this->TestAndValidateRemoveProductFromCategoryFields( $object );

		$item = ProductPeer::retrieveByPk( $object->id );
		if ( $item )
		{
			$c = new Criteria();
			$c->add(ProductHasCategoryPeer::PRODUCT_ID, $object->id );
			$c->add(ProductHasCategoryPeer::CATEGORY_ID, $object->category_id );
			$producHasCategory = ProductHasCategoryPeer::doSelectOne($c);
			if ($producHasCategory) {
				$producHasCategory->delete();
			}
			// Zwracanie danych
			$obj = new StdClass( );
			$obj->_delete = 1;
			return $obj;
		} else {
			throw new SoapFault( "1", $this->__(WEBAPI_INCORRECT_ID) );
		}
	}

	/**
	 * Zwraca liste zdjec dla produktu
	 * @param $object
	 * @return array
	 */
	public function GetProductImageList( $object )
	{
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}		
		stWebApi::getLogin($object->_session_hash, 'webapi_read');
		$this->TestAndValidateGetProductImageListFields( $object );

		$c = new Criteria( );

		if (isset($object->_modified_from) && isset($object->_modified_to)) {
			$criterion = $c->getNewCriterion(ProductHasSfAssetPeer::UPDATED_AT, $object->_modified_from, Criteria::GREATER_EQUAL);
			$criterion->addAnd($c->getNewCriterion(ProductHasSfAssetPeer::UPDATED_AT, $object->_modified_from, Criteria::LESS_EQUAL));
			$c->add($criterion);
		} else {
			if (isset($object->_modified_from)) {
				$criterion = $c->getNewCriterion(ProductHasSfAssetPeer::UPDATED_AT, $object->_modified_from, Criteria::GREATER_EQUAL);
				$c->add($criterion);
			}

			if (isset($object->_modified_to)) {
				$criterion = $c->getNewCriterion(ProductHasSfAssetPeer::UPDATED_AT, $object->_modified_to, Criteria::LESS_EQUAL);
				$c->add($criterion);
			}
		}

		if (!isset($object->_limit)) $object->_limit = 20;

		// ustawiamy kryteria wyboru
		$c->setLimit( $object->_limit );
		$c->setOffset( $object->_offset );
		$c->add(ProductHasSfAssetPeer::PRODUCT_ID, $object->product_id);

		$items = ProductHasSfAssetPeer::doSelect( $c );

		if ( $items )
		{
			// Zwracanie wyniku, dla wszystkich pol z tablicy 'out'
			$items_array = array();
			foreach ( $items as $item )
			{
				$object = new StdClass( );
				$object->image_filename = $item->getSfAsset()->getFilename();
				$this->getFieldsForGetProductImageList( $object, $item );
				$items_array[] = $object;
			}
			return $items_array;
		} else {
			return array( );
		}
	}

	/**
	 * Przeladowanie domyslnej funkcji getFieldsForGetProductImage
	 * @param $object
	 * @param $item
	 * @return unknown_type
	 */
	public function getFieldsForGetProductImage( $object, &$item ) {
		parent::getFieldsForGetProductImage($object,$item);

		sfLoader::loadHelpers('Helper');
		sfLoader::loadHelpers('stAsset');
		$object->image = base64_encode(file_get_contents(st_asset_image_path($item->getSfAsset(),'full', 'product', true, false)));
		$object->image_filename = $item->getSfAsset()->getFilename();
	}

	/**
	 * Przeladowanie domyslnej funkcji setFieldsForAddProductImage
	 * @param $object
	 * @param $item
	 * @return unknown_type
	 */
	public function setFieldsForAddProductImage( $object, &$item ) {
		parent::setFieldsForAddProductImage( $object, &$item );

		$input_file = sfConfig::get('sf_upload_dir').DIRECTORY_SEPARATOR.'assets'.DIRECTORY_SEPARATOR.$object->image_filename;
		file_put_contents($input_file,base64_decode($object->image));

		$item->setProductId($object->product_id);
		$item->createAsset($object->image_filename, $input_file, ProductHasSfAssetPeer::IMAGE_FOLDER,pathinfo($object->image_filename,PATHINFO_FILENAME));
	}

	/**
	 * Zwraca liczbe zdjec dla produktu
	 * @param $object
	 * @return $object
	 */
	public function CountProductImage( $object )
	{
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}		
		stWebApi::getLogin($object->_session_hash, 'webapi_read');
		try{
			//Zwracanie danych
			$obj = new StdClass( );
			$c = new Criteria();
			$c->add(ProductHasSfAssetPeer::PRODUCT_ID,$object->product_id);
			$obj->_count = ProductHasSfAssetPeer::doCount( $c );
			return $obj;
		} catch ( Exception $e ) {
			throw new SoapFault( "1", sprintf($this->__(WEBAPI_COUNT_ERROR),$e->getMessage()) );
		}
	}

	/**
	 * Usuwanie zdjec dla produktu
	 * @param $object
	 * @return $object
	 */
	public function DeleteProductImage( $object )
	{
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}		
		stWebApi::getLogin($object->_session_hash, 'webapi_write');
		$this->TestAndValidateDeleteProductImageFields( $object );

		$item = ProductHasSfAssetPeer::retrieveByPk( $object->id );
		if ( $item )
		{
			// Zwracanie danych
			$obj = new StdClass( );
			$item->getSfAsset()->delete();
			$item->delete();
			$obj->_delete = 1;
			return $obj;
		} else {
			throw new SoapFault( "1", $this->__(WEBAPI_INCORRECT_ID));
		}
	}

	/**
	 * Pobieranie danych
	 *
	 * @param   object      $object             obiekt z parametrami
	 * @return  object      okiekt z danymi
	 * @throws WEBAPI_INCORRECT_ID WEBAPI_REQUIRE_ERROR
	 */
	public function GetProductList( $object )
	{
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}		
		stWebApi::getLogin($object->_session_hash, 'webapi_read');
		$this->TestAndValidateGetProductListFields( $object );
		$c = new Criteria( );

		if (isset($object->_modified_from) && isset($object->_modified_to)) {
			$criterion = $c->getNewCriterion(ProductPeer::UPDATED_AT, $object->_modified_from, Criteria::GREATER_EQUAL);
			$criterion->addAnd($c->getNewCriterion(ProductPeer::UPDATED_AT, $object->_modified_from, Criteria::LESS_EQUAL));
			$c->add($criterion);
		} else {
			if (isset($object->_modified_from)) {
				$criterion = $c->getNewCriterion(ProductPeer::UPDATED_AT, $object->_modified_from, Criteria::GREATER_EQUAL);
				$c->add($criterion);
			}

			if (isset($object->_modified_to)) {
				$criterion = $c->getNewCriterion(ProductPeer::UPDATED_AT, $object->_modified_to, Criteria::LESS_EQUAL);
				$c->add($criterion);
			}
		}

		if (isset($object->category_id)) {
			$c->addJoin(ProductHasCategoryPeer::PRODUCT_ID, ProductPeer::ID);
			$c->add(ProductHasCategoryPeer::CATEGORY_ID,$object->category_id);
		}

		if (!isset($object->_limit)) $object->_limit = 20;

		// ustawiamy kryteria wyboru
		$c->setLimit( $object->_limit );
		$c->setOffset( $object->_offset );

		$items = ProductPeer::doSelect( $c );

		if ( $items )
		{
			// Zwracanie wyniku, dla wszystkich pol z tablicy 'out'
			$items_array = array();
			foreach ( $items as $item )
			{
				$object = new StdClass( );
				$this->getFieldsForGetProductList( $object, $item );
				$items_array[] = $object;
			}
			return $items_array;
		} else {
			return array( );
		}
	}

	/**
	 *
	 * @param $object
	 * @param $item
	 * @return unknown_type
	 */
	public function getFieldsForCountProduct( $object, &$item ) {
		if (method_exists($item,"get_count" ) ) { $object->_count = $item->get_count();}
	}

	/**
	 * Zwraca id dostepnosci
	 * @param $object
	 * @return $object
	 */
	public static function getAvailabilityId($item) {
		if (is_object($item->getAvailability()))
		{
			return $item->getAvailability()->getId();
		}
		else
		{
			return 0;
		}
	}

	/**
	 * ustawia dostenosc dla produktu
	 *
	 * @param $item object
	 * @param $v mixed
	 * @return boolean
	 */
	public static function setAvailabilityId($item, $v) {
		$availability = AvailabilityPeer::retrieveByPk($v);
		if ($v==0 || is_object($availability)) $item->setAvailabilityId($v);
		else throw new SoapFault( "2", sprintf($this->__(WEBAPI_AVAILABILITY_ERROR),$v));
		return true;
	}

	/**
	 * Usuwanie danych
	 *
	 * @param   object      $object             obiekt z danymi
	 * @return  object      obiekt z true
	 * @throws WEBAPI_INCORRECT_ID WEBAPI_DELETE_ERROR WEBAPI_REQUIRE_ERROR
	 */
	public function DeleteTax( $object )
	{
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}		
		stWebApi::getLogin($object->_session_hash, 'webapi_write');
		$this->TestAndValidateDeleteTaxFields( $object );

		$item = TaxPeer::retrieveByPk( $object->id );
		if ( $item )
		{
			if ($item->getIsDefault()) {
				throw new SoapFault( "2", sprintf($this->__(WEBAPI_DELETE_ERROR), $this->__("nie można usunąć domyślnej stawki VAT")) );
			}

			if (TaxPeer::doCount(new Criteria())==1) {
				throw new SoapFault( "2", sprintf($this->__(WEBAPI_DELETE_ERROR), $this->__("w sklepie musi istnieć co najmniej jedna stawka VAT")));
			}
			// Zwracanie danych
			$obj = new StdClass( );
			$item->delete( );
			$obj->_delete = 1;
			return $obj;
		} else {
			throw new SoapFault( "1", $this->__(WEBAPI_INCORRECT_ID));
		}
	}

	/**
	 * ustawia stawke VAT dla produktu
	 *
	 * @param $item object
	 * @param $v mixed
	 * @return boolean
	 */
	public static function setTaxId($item, $v)
	{
		$tax = TaxPeer::retrieveByPk($v);
		if (is_object($tax))
		{
			$item->setTaxId($v);
			$item->setOptVat($tax->getVat());
		} else {
			throw new SoapFault( '2', sprintf($this->__(WEBAPI_UPDATE_ERROR), $this->__("w sklepie nie istnieje stawka VAT")));
		}
	}

	/**
	 * Zwraca id stawki VAT
	 * @param $object
	 * @return $object
	 */
	public static function getTaxId($item)
	{
		return $item->getTaxId();
	}

	/**
	 * Pobieranie danych
	 *
	 * @param   object      $object             obiekt z parametrami
	 * @return  object      okiekt z danymi
	 * @throws WEBAPI_INCORRECT_ID WEBAPI_REQUIRE_ERROR
	 */
	public function GetProductByCode( $object )
	{
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}		
		stWebApi::getLogin($object->_session_hash, 'webapi_read');
		$this->TestAndValidateGetProductByCodeFields( $object );

		$c = new Criteria();
		$c->add(ProductPeer::CODE, $object->code);
		$item = ProductPeer::doSelectOne($c);
		if ( $item )
		{
			$object = new StdClass( );
			$this->getFieldsForGetProduct( $object, $item );
			return $object;
		} else {
			throw new SoapFault( "1", $this->__(WEBAPI_INCORRECT_ID) );
		}
	}

	/**
	 * Aktualizacja danych
	 *
	 * @param   object      $object             obiekt z parametrami
	 * @return  object      obiekt z true
	 * @throws WEBAPI_INCORRECT_ID WEBAPI_UPDATE_ERROR WEBAPI_REQUIRE_ERROR
	 * @todo dodać walidacje danych
	 */
	public function UpdateProductByCode( $object )
	{
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}
		stWebApi::getLogin($object->_session_hash, 'webapi_write');

		if (isset($object->category_id) && !CategoryPeer::retrieveByPK($object->category_id))
		throw new SoapFault( "2", sprintf($this->__(WEBAPI_UPDATE_ERROR), $this->__("kategoria o id ").$object->category_id.$this->__(" nie istnieje")) );
		if (isset($object->producer_id) && !ProducerPeer::retrieveByPK($object->producer_id))
		throw new SoapFault( "2", sprintf($this->__(WEBAPI_UPDATE_ERROR), $this->__("producent o id ").$object->producer_id.$this->__(" nie istnieje")) );
		if (isset($object->tax_id) && !TaxPeer::retrieveByPK($object->tax_id))
		throw new SoapFault( "2", sprintf($this->__(WEBAPI_UPDATE_ERROR), $this->__("VAT o id ").$object->tax_id.$this->__(" nie istnieje")) );
		if (isset($object->weight) && $object->weight<0) $object->weight = 0.0;
		
		$this->TestAndValidateUpdateProductByCodeFields( $object );

		$c = new Criteria();
		$c->add(ProductPeer::CODE, $object->code);
		$item = ProductPeer::doSelectOne($c);
		if ( $item )
		{
			$this->setFieldsForUpdateProductByCode( $object, $item );
			//Zapisywanie danych do bazy
			try {
				if (isset($object->category_id)) $this->UpdateDefaultCategory($item->getId(), $object->category_id);
				$this->setProductPrices($item, $object);
				$item->save( );
				
				$languages = LanguagePeer::doSelect(new Criteria());
				foreach ($languages as $lang) {
					stSimpleSearch::getInstance()->buildIndex($item, $lang->getOriginalLanguage());
					stAdvancedSearch::getInstance()->buildIndex($item, $lang->getOriginalLanguage());
				}				
			} catch ( Exception $e ) {
				throw new SoapFault( "2", sprintf($this->__(WEBAPI_ADD_ERROR),$e->getMessage()) );
			}

			// Zwracanie danych
			$object = new StdClass( );
			$object->_update = 1;
			return $object;

		} else {
			throw new SoapFault( "1", $this->__(WEBAPI_INCORRECT_ID) );
		}
	}

	public static function getProductOptions($item) {
		return stProductOptionsImportExport::getProductOptions($item);
	}

	public static function setProductOptions($item, $value) {
		try {
			stProductOptionsImportExport::$useLogger = false;
			return stProductOptionsImportExport::setProductOptions($item, $value);
		} catch (Exception $e) {
			throw new SoapFault('2', sprintf($this->__(WEBAPI_UPDATE_ERROR), $e->getMessage()));
		}
	}

    public function setProductPrices($product, $object)
    {
        $product->setVat($product->getTax()->getId());
    	if (isset($object->price) && !isset($object->price_brutto)) $product->setPriceBrutto(stPrice::calculate($object->price, $product->getVat()));
		if (!isset($object->price) && isset($object->price_brutto)) $product->setPrice(stPrice::extract($object->price_brutto, $product->getVat()));

		if (isset($object->old_price) && !isset($object->old_price_brutto)) $product->setOldPriceBrutto(stPrice::calculate($object->old_price, $product->getVat()));
		if (!isset($object->old_price) && isset($object->old_price_brutto)) $product->setOldPrice(stPrice::extract($object->old_price_brutto, $product->getVat()));

		if (isset($object->wholesale_a_netto) && !isset($object->wholesale_a_brutto)) $product->setWholesaleABrutto(stPrice::calculate($object->wholesale_a_netto, $product->getVat()));
		if (!isset($object->wholesale_a_netto) && isset($object->wholesale_a_brutto)) $product->setWholesaleANetto(stPrice::extract($object->wholesale_a_brutto, $product->getVat()));

		if (isset($object->wholesale_b_netto) && !isset($object->wholesale_b_brutto)) $product->setWholesaleBBrutto(stPrice::calculate($object->wholesale_b_netto, $product->getVat()));
		if (!isset($object->wholesale_b_netto) && isset($object->wholesale_b_brutto)) $product->setWholesaleBNetto(stPrice::extract($object->wholesale_b_brutto, $product->getVat()));

		if (isset($object->wholesale_c_netto) && !isset($object->wholesale_c_brutto)) $product->setWholesaleCBrutto(stPrice::calculate($object->wholesale_c_netto, $product->getVat()));
		if (!isset($object->wholesale_c_netto) && isset($object->wholesale_c_brutto)) $product->setWholesaleCNetto(stPrice::extract($object->wholesale_c_brutto, $product->getVat()));

        if (isset($object->price) && isset($object->price_brutto))
        {
            if ((stPrice::round($object->price) == stPrice::extract($object->price_brutto, $product->getVat()) || stPrice::round($object->price_brutto) == stPrice::calculate($object->price, $product->getVat())) == false)
            throw new SoapFault( "2", $this->__("Cena brutto (price_brutto) nie pokrywa się z ceną netto (jeżeli chcesz zmienić cenę brutto usuń cenę netto)"));
            $product->setPriceBrutto($object->price_brutto);
            $product->setPrice($object->price);
        }

        if (isset($object->old_price) && isset($object->old_price_brutto))
        {
            if ((stPrice::round($object->old_price) == stPrice::extract($object->old_price_brutto, $product->getVat()) || stPrice::round($object->old_price_brutto) == stPrice::calculate($object->old_price, $product->getVat())) == false)
            throw new SoapFault( "2", $this->__("Cena brutto (old_price_brutto) nie pokrywa się z ceną netto (jeżeli chcesz zmienić cenę brutto usuń cenę netto)"));
            $product->setOldPriceBrutto($object->price_brutto);
            $product->setOldPrice($object->price);
        }

        if (isset($object->wholesale_a_netto) && isset($object->wholesale_a_brutto))
        {
            if ((stPrice::round($object->wholesale_a_netto) == stPrice::extract($object->wholesale_a_brutto, $product->getVat()) || stPrice::round($object->wholesale_a_brutto) == stPrice::calculate($object->wholesale_a_netto, $product->getVat())) == false)
            throw new SoapFault( "2",  $this->__("Cena brutto (wholesale_a_brutto) nie pokrywa się z ceną netto (jeżeli chcesz zmienić cenę brutto usuń cenę netto)"));
            $product->setWholesaleABrutto($object->wholesale_a_brutto);
            $product->setWholesaleANetto($object->wholesale_a_netto);
        }

        if (isset($object->wholesale_b_netto) && isset($object->wholesale_b_brutto))
        {
            if ((stPrice::round($object->wholesale_b_netto) == stPrice::extract($object->wholesale_b_brutto, $product->getVat()) || stPrice::round($object->wholesale_b_brutto) == stPrice::calculate($object->wholesale_b_netto, $product->getVat())) == false)
            throw new SoapFault( "2", $this->__("Cena brutto (wholesale_a_brutto) nie pokrywa się z ceną netto (jeżeli chcesz zmienić cenę brutto usuń cenę netto)"));
            $product->setWholesaleBBrutto($object->wholesale_b_brutto);
            $product->setWholesaleBNetto($object->wholesale_b_netto);
        }
        
        if (isset($object->wholesale_c_netto) && isset($object->wholesale_c_brutto))
        {
            if ((stPrice::round($object->wholesale_c_netto) == stPrice::extract($object->wholesale_c_brutto, $product->getVat()) || stPrice::round($object->wholesale_c_brutto) == stPrice::calculate($object->wholesale_c_netto, $product->getVat())) == false)
            throw new SoapFault( "2", $this->__("Cena brutto (wholesale_a_brutto) nie pokrywa się z ceną netto (jeżeli chcesz zmienić cenę brutto usuń cenę netto)"));
            $product->setWholesaleCBrutto($object->wholesale_c_brutto);
            $product->setWholesaleCNetto($object->wholesale_c_netto);
        }
     }
}
