<?php
/**
 * SOTESHOP/stProductGroup
 *
 * Ten plik należy do aplikacji stProductGroup opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stProductGroup
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 16236 2011-11-24 12:37:24Z krzysiek $
 * @author Krzysztof Bebło <krzysztof.beblo@sote.pl>, Paweł Byszewski <pawel.byszewski@sote.pl>
 */

/**
 * Akcje grupy produktów.
 *
 * @package stProductGroup
 * @author Krzysztof Bebło <krzysztof.beblo@sote.pl>, Paweł Byszewski <pawel.byszewski@sote.pl>
 */

class stProductGroupActions extends autostProductGroupActions
{
    public function executeDelete()
    {
        ProductGroupPeer::cleanCache();
        parent::executeDelete();
    }

    public function executeProductAddGroup()
    {
        $ids = $this->getRequestParameter('product[selected]', array($this->getRequestParameter('id')));
        $related_id = $this->getRequestParameter('forward_parameters[product_group_id]');

        foreach ($ids as $id)
        {
            $c = new Criteria();
            $c->add(ProductGroupHasProductPeer::PRODUCT_GROUP_ID, $related_id);
            $c->add(ProductGroupHasProductPeer::PRODUCT_ID, $id);

            if (!ProductGroupHasProductPeer::doCount($c))
            {
                $product_group_has_product = new ProductGroupHasProduct();
                $product_group_has_product->setProductGroupId($related_id);
                $product_group_has_product->setProductId($id);
                $product_group_has_product->save();
            }
        }

        $this->redirect($this->getRequest()->getReferer());
    }


    public function executeProductRemoveGroup()
    {
        $ids = $this->getRequestParameter('product[selected]', array($this->getRequestParameter('id')));
        $related_id = $this->getRequestParameter('forward_parameters[product_group_id]');

        foreach ($ids as $id)
        {
            $c = new Criteria();
            $c->add(ProductGroupHasProductPeer::PRODUCT_GROUP_ID, $related_id);
            $c->add(ProductGroupHasProductPeer::PRODUCT_ID, $id);
            ProductGroupHasProductPeer::doDelete($c);
        }

        $this->redirect($this->getRequest()->getReferer());
    }

    public function addProductFiltersCriteria($c)
    {
        parent::addProductFiltersCriteria($c);

        if (isset($this->filters['list_assigned']) && $this->filters['list_assigned'] !== '')
        {
            $c->addJoin(ProductPeer::ID, sprintf("%s AND %s = %d", ProductGroupHasProductPeer::PRODUCT_ID, ProductGroupHasProductPeer::PRODUCT_GROUP_ID, $this->forward_parameters['product_group_id']), Criteria::LEFT_JOIN);
            
            if ($this->filters['list_assigned'])
            {
                $c->add(ProductGroupHasProductPeer::ID, null, Criteria::ISNOTNULL);
            }
            else
            {
                $c->add(ProductGroupHasProductPeer::ID, null, Criteria::ISNULL);
            }
        }
    }
    
  protected function saveConfig() 
  {      
    parent::saveConfig();
    stFastCacheManager::clearCache();
  }
  
    
    
}
