<?php
/** 
 * SOTESHOP/stReview 
 * 
 * Ten plik należy do aplikacji stReview opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stReview
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: actions.class.php 1153 2009-10-07 08:24:35Z pawel $
 */

/** 
 * stReview actions
 *
 * @author Paweł Byszewski <pawel.byszewski@sote.pl>, Krzysztof Bebło <krzysztof.beblo@sote.pl>  
 *
 * @package     stReview
 * @subpackage  actions
 */
class stReviewActions extends autostReviewActions
{
    /** 
     * Filtr po kolumnie klient
     * Szukanie po imieniu i nazwisku, ale również po mail'u jeśli zawarta jest '@' w wyszukiwaniu
     *
     * @param      Criteria    $c
     */
    protected function addFiltersCriteria($c)
    {
        parent::addFiltersCriteria($c);
        if (isset($this->filters['filter_client']) && !empty($this->filters['filter_client']))
        {
            if (strpos($this->filters['filter_client'], '@') !== false)
            {
                $c->add(sfGuardUserPeer::USERNAME, '%' . $this->filters['filter_client'] . '%', Criteria::LIKE);
            }
            else
            {
                $client = explode(" ", $this->filters['filter_client']);

                $c->addJoin(UserDataPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID);
               
                $c->add(UserDataPeer::IS_BILLING, true);

                $c->add(UserDataPeer::NAME, '%' . $client[0] . '%', Criteria::LIKE);

                if (isset($client[1]) && !empty($client[1]))
                {
                    $c->add(UserDataPeer::SURNAME, '%' . $client[1] . '%', Criteria::LIKE);
                }
            }

        }
    }

    /** 
     * Filtr po kolumnie wyświetlania recenzji
     *
     * @param      Criteria    $criteria
     * @param        string      $status
     * @return   bool
     */
    protected function filterCriteriaByActive($criteria, $status)
    {
        if (!$status)
        {
            $criterion = $criteria->getNewCriterion(ReviewPeer::ACTIVE, false);
            $criterion->addOr($criteria->getNewCriterion(ReviewPeer::AGREEMENT, false));
            $criteria->add($criterion);
        }
        else
        {
            $criteria->add(ReviewPeer::ACTIVE, true);
            $criteria->add(ReviewPeer::AGREEMENT, true);
        }

        return true;
    }
}