<?php
/**
 * SOTESHOP/stUser 
 * 
 * Ten plik należy do aplikacji stUser opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stUser
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: actions.class.php 617 2009-04-09 13:02:31Z michal $
 * @author      Marcin Butlak <marcin.butlak@sote.pl>
 */

/**
 * Klasa stUserActions
 *
 * @package     stUser
 * @subpackage  actions
 */
class stUserActions extends autostUserActions
{
    public function executeUserDataDeliveryCreate()
    {
        $this->getRequest()->setParameter('create', true);

        return parent::executeUserDataDeliveryCreate();
    }

    public function executeUserDataBillingCreate()
    {
        $this->getRequest()->setParameter('create', true);

        return parent::executeUserDataBillingCreate();
    }

    public function executeList()
    {
        parent::executeList();
        $this->pager->getCriteria()->addJoin(sfGuardUserPeer::ID, sfGuardUserGroupPeer::USER_ID);
        $this->pager->getCriteria()->addJoin(sfGuardUserGroupPeer::GROUP_ID, sfGuardGroupPermissionPeer::GROUP_ID);
        $this->pager->getCriteria()->addJoin(sfGuardPermissionPeer::ID, sfGuardGroupPermissionPeer::PERMISSION_ID);
        $this->pager->getCriteria()->add(sfGuardPermissionPeer::NAME, 'user');
        $this->pager->init();
    }

    public function executeUserDataBillingList()
    {
        parent::executeUserDataBillingList();
        $this->pager->getCriteria()->add(UserDataPeer::IS_BILLING, true);
        $this->pager->getCriteria()->add(UserDataPeer::SF_GUARD_USER_ID, $this->forward_parameters['user_id']);
        $this->pager->init();
    }

    public function executeUserDataDeliveryList()
    {
        parent::executeUserDataDeliveryList();
        $this->pager->getCriteria()->add(UserDataPeer::IS_BILLING, false);
        $this->pager->getCriteria()->add(UserDataPeer::SF_GUARD_USER_ID, $this->forward_parameters['user_id']);
        $this->pager->init();
    }

    protected function getUserDataBillingUserDataOrCreate($id = 'id')
    {
        $c = new Criteria();
        $c->add(UserDataPeer::SF_GUARD_USER_ID, $this->getRequestParameter('user_id'));
        $c->add(UserDataPeer::IS_DEFAULT, 1);
        $c->add(UserDataPeer::IS_BILLING, 1);

        if ($this->hasRequestParameter('create'))
        {
            $this->user_data = new UserData();

            $this->user_data->setSfGuardUserId($this->getRequestParameter('user_id'));
            $this->user_data->setIsBilling(1);
            $this->user_data->setIsDefault(!UserDataPeer::doCount($c));
            $this->user_data->setCountriesId(36);
        }
        elseif ($this->hasRequestParameter('user_id') && !$this->hasRequestParameter($id))
        {
            if ($userDataBillingDefault = UserDataPeer::doSelectOne($c))
            {
                $this->user_data = $userDataBillingDefault;
            }
            else
            {
                $this->user_data = new UserData();

                $this->user_data->setSfGuardUserId($this->getRequestParameter('user_id'));
                $this->user_data->setIsBilling(1);
                $this->user_data->setIsDefault(1);
                $this->user_data->setCountriesId(36);
            }
        }
        else
        {
            parent::getUserDataBillingUserDataOrCreate($id);
        }

        return $this->user_data;
    }

    protected function getUserDataDeliveryUserDataOrCreate($id = 'id')
    {
        $c = new Criteria();
        $c->add(UserDataPeer::SF_GUARD_USER_ID, $this->getRequestParameter('user_id'));
        $c->add(UserDataPeer::IS_DEFAULT, 1);
        $c->add(UserDataPeer::IS_BILLING, 0);

        if ($this->hasRequestParameter('create'))
        {
            $this->user_data = new UserData();

            $this->user_data->setSfGuardUserId($this->getRequestParameter('user_id'));
            $this->user_data->setIsBilling(0);
            $this->user_data->setIsDefault(!UserDataPeer::doCount($c));
            $this->user_data->setCountriesId(36);
        }
        elseif ($this->hasRequestParameter('user_id') && !$this->hasRequestParameter($id))
        {
            if ($userDataDeliveryDefault = UserDataPeer::doSelectOne($c))
            {
                $this->user_data = $userDataDeliveryDefault;
            }
            else
            {
                $this->user_data = new UserData();

                $this->user_data->setSfGuardUserId($this->getRequestParameter('user_id'));
                $this->user_data->setIsBilling(0);
                $this->user_data->setIsDefault(1);
                $this->user_data->setCountriesId(36);
            }
        }
        else
        {
            parent::getUserDataDeliveryUserDataOrCreate($id);
        }

        return $this->user_data;
    }

    public function handleErrorEdit()
    {
        $this->preExecute();
        $this->processEditForwardParameters();
        $this->forward_parameters = $this->getUser()->getAttributeHolder()->getAll('sf_admin/autoStUser/forward_parameters');
        $this->sf_guard_user = $this->getsfGuardUserOrCreate();
        $this->updatesfGuardUserFromRequest();

        $this->labels = $this->getLabels();

        return sfView::SUCCESS;
    }

    

    /**
     * Przeciążenie zapisu sfGuardUser
     *
     * @param   sfGuardUser $sf_guard_user
     */
    protected function savesfGuardUser($sf_guard_user)
    {

         $c = new Criteria();
         $c->add(MailDescriptionPeer::SYSTEM_NAME, "admin_confirm_user");
         $mail_description = MailDescriptionPeer::doSelectOne($c);
         $mail_description_active = $mail_description->getIsActive();


        if (!$sf_guard_user->getId())
        {
            $sf_guard_user->addGroupByName('user');
            $sf_guard_user->setHashCode(md5(microtime()));

            if($sf_guard_user->getIsAdminConfirm()==1 && $mail_description_active == 1)
            {
               $this->mailWithNewUserToUser($sf_guard_user);
            }
        }

        if ($sf_guard_user->getId())
        {
            $c = new Criteria();
            $c->add(sfGuardUserPeer::ID, $sf_guard_user->getId());
            $user = sfGuardUserPeer::doSelectOne($c);
            $isAdminConfirm = $user->getIsAdminConfirm();
        }


        if ($sf_guard_user->getIsAdminConfirm()==1 && $isAdminConfirm == 0 && $mail_description_active == 1)
        {
            $this->mailWithNewUserToUser($sf_guard_user);
        }

        parent::savesfGuardUser($sf_guard_user);
    }

    /**
     * Wysyła mail z zamówieniem do administratora
     */
    function mailWithNewUserToUser($user)
    {
        
        $mailHtmlHead = stMailer::getHtmlMailDescription("header");

        $mailHtmlFoot = stMailer::getHtmlMailDescription("footer");

        $mailHtmlContent = stMailer::getHtmlMailDescription("admin_confirm_user");

        $sendAdminConfirmHtmlMailMessage = stMailTemplate::render('sendAdminConfirmHtml', array(
        'user' => $user,
        'head' => $mailHtmlHead,
        'foot' => $mailHtmlFoot,
        'content' => $mailHtmlContent,
        
        ));

        $mailPlainHead = stMailer::getPlainMailDescription("header");

        $mailPlainFoot = stMailer::getPlainMailDescription("footer");

        $mailPlainContent = stMailer::getPlainMailDescription("admin_confirm_user");

        $sendAdminConfirmPlainMailMessage = stMailTemplate::render('sendAdminConfirmPlain', array(
        'user' => $user,
        'head' => $mailPlainHead,
        'foot' => $mailPlainFoot,
        'content' => $mailPlainContent,
        
        ));


        $mail = stMailer::getInstance();
        return $mail->setSubject($this->getRequest()->getHost().' - '.__('Twoje konto w sklepie zostało zweryfikowane.'))->setHtmlMessage($sendAdminConfirmHtmlMailMessage)->setPlainMessage($sendAdminConfirmPlainMailMessage)->setTo($user->getUsername())->sendToClient();

    }

    protected function saveUserDataBillingUserData($user_data)
    {
        $user_data->setSfGuardUserId($this->forward_parameters['user_id']);
        $user_data->setIsBilling(1);

        $this->getDispatcher()->notify(new sfEvent($this, 'autoStUserActions.preSaveUserDataBilling', array('modelInstance' => $user_data)));
        $user_data->save();

        if ($user_data->getIsDefault() == 1)
        {
            $this->setDefaultUserData($user_data->getId(), 1, $user_data->getSfGuardUserId());
        }

        $this->getDispatcher()->notify(new sfEvent($this, 'autoStUserActions.preSaveUserDataBilling', array('modelInstance' => $user_data)));
    }

    protected function saveUserDataDeliveryUserData($user_data)
    {
        $user_data->setSfGuardUserId($this->forward_parameters['user_id']);
        $user_data->setIsBilling(0);

        $this->getDispatcher()->notify(new sfEvent($this, 'autoStUserActions.preSaveUserDataDelivery', array('modelInstance' => $user_data)));
        $user_data->save();

        if ($user_data->getIsDefault() == 1)
        {
            $this->setDefaultUserData($user_data->getId(), 0, $user_data->getSfGuardUserId());
        }

        $this->getDispatcher()->notify(new sfEvent($this, 'autoStUserActions.preSaveUserDataDelivery', array('modelInstance' => $user_data)));
    }

    /**
     */
    public function setDefaultUserData($userDataId, $isBilling, $user_id)
    {
        $con = Propel::getConnection();
        $c1 = new Criteria();
        $c1->add(UserDataPeer::SF_GUARD_USER_ID, $user_id);

        if ($isBilling == 1)
        {
            $c1->add(UserDataPeer::IS_BILLING, 1);
        }
        else
        {
            $c1->add(UserDataPeer::IS_BILLING, 0);
        }

        $c1->add(UserDataPeer::IS_DEFAULT, 1);

        $c2 = new Criteria();
        $c2->add(UserDataPeer::IS_DEFAULT, 0);

        BasePeer::doUpdate($c1, $c2, $con);

        $c = new Criteria();
        $c->add(UserDataPeer::SF_GUARD_USER_ID, $user_id);
        $c->add(UserDataPeer::ID, $userDataId);

        $userData = UserDataPeer::doSelectOne($c);
        $userData->setIsDefault(1);
        $userData->save();
    }

    public function executeUpdateConfirm()
    {
        $user_id = $this->getRequestParameter('id');

        $c = new Criteria();
        $c->add(sfGuardUserPeer::ID, $user_id);
        $user = sfGuardUserPeer::doSelectOne($c);

        $user->setIsConfirm(1);
        $user->save();



        return $this->redirect('stUser/edit?id='.$user->getId());

    }

    public function executeUpdateAdminConfirm()
    {
        $user_id = $this->getRequestParameter('id');

        $c = new Criteria();
        $c->add(sfGuardUserPeer::ID, $user_id);
        $user = sfGuardUserPeer::doSelectOne($c);

        $user->setIsAdminConfirm(1);
        $user->save();

        return $this->redirect('stUser/edit?id='.$user->getId());

    }


    protected function addFiltersCriteria($c)
    {
        parent::addFiltersCriteria($c);

        if (isset($this->filters['filter_full_name']) && !empty($this->filters['filter_full_name']))
        {
            $c->addJoin(UserDataPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID);

            $c->add(UserDataPeer::IS_BILLING, 1);

            $c->add(UserDataPeer::FULL_NAME, $this->filters['filter_full_name']);
           
        }

        if (isset($this->filters['filter_company']) && !empty($this->filters['filter_company']))
        {
            $c->addJoin(UserDataPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID);

            $c->add(UserDataPeer::IS_BILLING, 1);

            $c->add(UserDataPeer::COMPANY, $this->filters['filter_company']);
        }

    }

    public function executeRegisterUserWidget()
    {

    }

  public function validateEdit()
   {
      $ok = true;

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         if (!$this->getRequest()->getParameter('id'))
         {
            $i18n = $this->getContext()->getI18N();

            if (!$this->getRequestParameter('sf_guard_user[password]'))
            {
               $this->getRequest()->setError('sf_guard_user{password}', $i18n->__('Proszę podać hasło.'));
               $ok = false;
            }

            if (!$this->getRequestParameter('sf_guard_user[password_bis]'))
            {
               $this->getRequest()->setError('sf_guard_user{password_bis}', $i18n->__('Proszę podać hasło.'));
               $ok = false;
            }
         }
      }

      return $ok;
   }
    
}