<?php
/** 
 * SOTESHOP/stUser 
 * 
 * Ten plik należy do aplikacji stUser opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stUser
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: components.class.php 617 2009-04-09 13:02:31Z michal $
 * @author      Marcin Butlak <marcin.butlak@sote.pl>
 */

/** 
 * Klasa stUserComponents
 *
 * @package     stUser
 * @subpackage  actions
 */
class stUserComponents extends autostUserComponents 
{
    public function executeClientUsername()
    {
        $c = new Criteria();
        $c->add(sfGuardUserPeer::ID, $this->forward_parameters['user_id']);
        $sf_guard_user = sfGuardUserPeer::doSelectOne($c);
        
        $this->username = $sf_guard_user->getUsername();
    } 

    public function executeFullName()
    {
        $c = new Criteria();
        $c->add(UserDataPeer::SF_GUARD_USER_ID, $this->sf_guard_user->getId());
        $c->add(UserDataPeer::IS_DEFAULT , 1);
        $c->add(UserDataPeer::IS_BILLING , 1);
        if ($userDataBillingDefault = UserDataPeer::doSelectOne($c))
        {   
            $this->full_name = $userDataBillingDefault->getFullName();
        }
        else 
        {
            $this->full_name = "-";
        }
        $this->id = $this->sf_guard_user->getId();
    }
    

    public function executeCompany()
    {
        $c = new Criteria();
        $c->add(UserDataPeer::SF_GUARD_USER_ID, $this->sf_guard_user->getId());
        $c->add(UserDataPeer::IS_DEFAULT , 1);
        $c->add(UserDataPeer::IS_BILLING , 1);
        if ($userDataBillingDefault = UserDataPeer::doSelectOne($c))
        {
            $this->company = $userDataBillingDefault->getCompany();
        }
        else
        {
            $this->company = "-";
        }
        $this->id = $this->sf_guard_user->getId();
    }
    
    public function executePassword()
    {
        
    }
    
    public function executePasswordBis()
    {
        
    } 

    public function executeIsDefault()
    {
        
    }
    
    public function executeUserInfo()
    {          
        $this->user_data_billing = $this->getUserDataBillingDefault($this->getRequestParameter('id'));
        $this->user_data_delivery = $this->getUserDataDeliveryDefault($this->getRequestParameter('id'));
        $this->id = $this->getRequestParameter('id');
    }
    
    public function getUserDataBillingDefault($user_id)
    {
        $c = new Criteria();
        $c->add(UserDataPeer::SF_GUARD_USER_ID, $user_id);
        $c->add(UserDataPeer::IS_DEFAULT , 1);
        $c->add(UserDataPeer::IS_BILLING , 1);
        if ($userDataBillingDefault = UserDataPeer::doSelectOne($c))
        {
            $this->user_data = $userDataBillingDefault;
        }
        else 
        {
            $this->user_data = new UserData();
            
            $this->user_data->setSfGuardUserId($user_id);
            $this->user_data->setIsBilling(1);
            $this->user_data->setIsDefault(1);
            $this->user_data->setCountriesId(36);
        }

        $userDataBillingDefault = $this->user_data;
        return $userDataBillingDefault;
    }

    public function getUserDataDeliveryDefault($user_id)
    {
        $c = new Criteria();
        $c->add(UserDataPeer::SF_GUARD_USER_ID, $user_id);
        $c->add(UserDataPeer::IS_DEFAULT , 1);
        $c->add(UserDataPeer::IS_BILLING , 0);
        if ($userDataDeliveryDefault = UserDataPeer::doSelectOne($c))
        {
            $this->user_data = $userDataDeliveryDefault;
        }
        else 
        {
            $this->user_data = new UserData();
            
            $this->user_data->setSfGuardUserId($user_id);
            $this->user_data->setIsBilling(0);
            $this->user_data->setIsDefault(1);
            $this->user_data->setCountriesId(36);
        }

        $userDataDeliveryDefault = $this->user_data;
        return $userDataDeliveryDefault;
    }
    
    public function executeUserConfirm()
    {                     
        $this->confirm = $this->sf_guard_user->getIsConfirm();
        $this->id = $this->sf_guard_user->getId();
    }

    public function executeUserAdminConfirm()
    {
        $this->admin_confirm = $this->sf_guard_user->getIsAdminConfirm();
        $this->id = $this->sf_guard_user->getId();
    }

    public function executeUserOrder()
    {                     
        $this->username = $this->sf_guard_user->getUsername();
    }

    public function executeRegisterUserWidget()
    {
       $backendMainConfig = stConfig::getInstance($this->getContext(), 'stBackendMain');

       if($this->getRequestParameter('date_type'))
       {
           $date_type = $this->getRequestParameter('date_type');
           $backendMainConfig->set('date_type', $date_type);
           $backendMainConfig->save();
       }
       else
       {
           $date_type = $backendMainConfig->get('date_type');
       }

       if($date_type=="day")
       {
           $from_date = date('Y-m-d H:i:s', time() - 86400);
       }
       elseif($date_type=="week")
       {
           $from_date = date('Y-m-d H:i:s', time() - 604800);

       }elseif($date_type=="month")
       {
           $from_date = date('Y-m-d H:i:s', time() - 2419200);

       }elseif($date_type=="lastlog")
       {
           $c = new Criteria();
           $c->add(sfGuardUserPeer::ID, $this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'));
           $user = sfGuardUserPeer::doSelectOne($c);

           $from_date = $this->getUser()->getLastLogin();
       }
           $to_date = date('Y-m-d H:i:s');

        $this->date_type = $date_type;
        $this->from_date = $from_date;
        $this->to_date = $to_date;

        //klienci

        $c = new Criteria();
        $criterion = $c->getNewCriterion(SfGuardUserPeer::CREATED_AT , $from_date, Criteria::GREATER_EQUAL );
        $criterion->addAnd($c->getNewCriterion(SfGuardUserPeer::CREATED_AT , $to_date, Criteria::LESS_EQUAL ));
        $c->add($criterion);
        $c->addDescendingOrderByColumn(SfGuardUserPeer::CREATED_AT);
        $c->addJoin(sfGuardUserPeer::ID, sfGuardUserGroupPeer::USER_ID);
        $c->addJoin(sfGuardUserGroupPeer::GROUP_ID, sfGuardGroupPermissionPeer::GROUP_ID);
        $c->addJoin(sfGuardPermissionPeer::ID, sfGuardGroupPermissionPeer::PERMISSION_ID);
        $c->add(sfGuardPermissionPeer::NAME, 'user');
        $c->setLimit(100);

        $users = SfGuardUserPeer::doSelect($c);

        if(SfGuardUserPeer::doSelect($c))
        {

        $i=0;
        foreach ($users as $user)
        {
            $c = new Criteria();
            $c->add(UserDataPeer::SF_GUARD_USER_ID, $user->getId());
            $c->add(UserDataPeer::IS_DEFAULT, 1);
            $c->add(UserDataPeer::IS_BILLING, 1);
            $userDataBilling = UserDataPeer::doSelectOne($c);

            $userInfo[$i]['username'] = $user->getUsername();
            $userInfo[$i]['id'] = $user->getId();

            if($userDataBilling)
            {
                $userInfo[$i]['fullname'] = $userDataBilling->getFullName();
                $userInfo[$i]['company'] = $userDataBilling->getCompany();
            }

            $userInfo[$i]['created_at']= $user->getCreatedAt();

            $i++;
        }

        $this->userInfo = $userInfo;
        $this->userQuantity = count($users);
        }
        else
        {
        $this->userInfo = "";
        $this->userQuantity = 0;
        }
    }
}