<?php
/**
 * SOTESHOP/stBasket
 *
 * Ten plik należy do aplikacji stBasket opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stBasket
 * @subpackage  helpers
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stBasketHelper.php 8867 2010-10-21 14:03:01Z michal $
 */

use_helper('stProductImage', 'stCurrency');

/**
 * Zwraca HTML zawierający listę produktów w postaci zdjęć
 *
 * @param      stBasket    $basket
 * @return       string      HTML
 */
function st_basket_order_product_list(stBasket $basket, $header = '')
{
    $content = '';

    $basket_products = $basket->getSessionItems();

    if ($basket_products)
    {
        foreach ($basket_products as $basket_product)
        {
            $basket_product->productValidate();
            $content .= content_tag('li', st_product_image_tag($basket_product, 'icon'));
        }

        $content = content_tag('ul', $content) . content_tag('p', __('Kwota:') . content_tag('strong', st_basket_total_amount($basket, true)));

        return content_tag('p', $header) . content_tag('div', $content, 'class=st_basket-list-order-product');
    }
    else
    {
        return $header;
    }
}

/**
 * Zwraca js dla pokazywania przycisków +/- danego produktu w koszyku
 *
 * @param   BasketProduct $product          Product koszyka
 * @return       string      js
 */
function st_basket_js_num_buttons_show($product)
{
    $product_id = $product->getItemId();

    $js = "$('st_basket-product-num-button-plus-$product_id').setStyle({visibility: 'visible'});";
    $js .= "$('st_basket-product-num-button-minus-$product_id').setStyle({visibility: 'visible'})";

    return $js;
}

/**
 * Zwraca js dla ukrywania przycisków +/- danego produktu w koszyku
 *
 * @param   BasketProduct $product          Product koszyka
 * @return       string      js
 */
function st_basket_js_num_buttons_hide($product)
{
    $product_id = $product->getItemId();

    $js = "$('st_basket-product-num-button-plus-$product_id').setStyle({visibility: 'hidden'});";
    $js .= "$('st_basket-product-num-button-minus-$product_id').setStyle({visibility: 'hidden'})";

    return $js;
}

/**
 * Zwraca sformatowaną całkowitą kwotę koszyka
 *
 * @param stBasket $basket Koszyk
 * @param bool $with_tax Uwzględnij VAT
 * @return float Całkowita kwota koszyka
 */
function st_basket_total_amount(stBasket $basket, $with_tax = false)
{
    return st_currency_format($basket->getSessionTotalAmount($with_tax, true));
}

?>