<?php

/**
 * SOTESHOP/stSMartyPlugin
 *
 * Ten plik należy do aplikacji stSmartyPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stSmartyPlugin
 * @subpackage  lib
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stSmarty.class.php 14787 2011-08-25 10:55:07Z marcin $
 * @author      Marek Jakubowicz <marek.jakubowicz@sote.pl>
 */

/**
 * Obsługa dodatkowych template'ów Smarty w Symfony.
 * @package stSmartyPlugin
 */
class stSmarty extends Smarty
{
   public static function clearCache()
   {
      $files = glob(sfConfig::get('sf_root_cache_dir').DIRECTORY_SEPARATOR.'smarty_c'.DIRECTORY_SEPARATOR.'*');     
      
      foreach ($files as $file)
      {
         unlink($file);
      }
   }

   /**
    * Instancja obiektu stTheme
    *
    * @var stTheme
    */
   protected $theme = null;

   /**
    * Zwraca instancje obiektu stTheme
    *
    * @return stTheme
    */
   public function getTheme()
   {
      return $this->theme;
   }

   /**
    * Konstruktor. Buduje konfiguracje Smarty - ogólną oraz dla modułów, pluginów.
    *
    * @param string $moduleName     nazwa modułu
    */
   function __construct($moduleName = '')
   {
      $context = sfContext::getInstance();

      $this->response = $context->getResponse();

      $this->theme = $context->getController()->getTheme();
      $this->template_dir = '';

      $this->moduleName = $moduleName;
      $this->config_dir = sfConfig::get('sf_app_template_dir').DIRECTORY_SEPARATOR."theme".DIRECTORY_SEPARATOR."config";

      $compile_dir = sfConfig::get('sf_root_cache_dir').DIRECTORY_SEPARATOR."smarty_c";

      if (!is_dir($compile_dir))
      {
         mkdir($compile_dir);
      }

      $this->compile_dir = $compile_dir;

      if (!empty($moduleName))
      {
         $this->config_dir = $this->theme->getTemplateDir($moduleName).DIRECTORY_SEPARATOR.'config';
      }

      $this->register_function("__", "smarty_lang");
      $this->register_function("image", "smarty_image");
      $this->register_function("link", "smarty_link");

      $this->register_function("tooltip", "smarty_tooltip");
      $this->register_function("init_tooltip", "init_tooltip");
      $this->register_function("edit_image_tooltip", "edit_image_tooltip");

      $this->register_function("include_st_component", "include_st_component");
      $this->register_function("include_file", "include_file");
      $this->register_function("include_content", "include_content");
      $this->register_function("include_content", "include_content");
      $this->register_function("st_category_image_tag", "smarty_st_category_image_tag");
      $this->register_block('st_link_to', 'smarty_st_link_to');
      $this->register_function("st_get_component", "smarty_st_get_component");
      $this->register_function("st_get_partial", "smarty_st_get_partial");
      $this->register_function("urlfor", "smarty_urlfor");
      $this->register_function("url_for", "smarty_urlfor");
      $this->register_function('st_socket', 'smarty_st_socket');
      $this->register_function('image_path', 'smarty_image_path');
      $this->register_function('set', array($this, 'smartySet'));
      $this->register_function('stylesheet_tag', array($this, 'smartyStylesheetTag'));
      $this->register_function('use_javascript', array($this, 'smartyUseJavascript'));
      $this->register_function('use_stylesheet', array($this, 'smartyUseStylesheet'));
      $this->register_function('use_less', array($this, 'smartyUseLess'));
      $this->register_postfilter('smarty_assign_filter');
      $this->register_prefilter('smarty_slot_filter');


      parent::Smarty();
   }

   public function smartyStylesheetTag($params, $smarty)
   {
      echo st_theme_stylesheet_tag($params['href']);
   }

   public function smartyUseJavascript($params, $smarty)
   {
      $this->response->addJavascript($params['src'], isset($params['position']) ? $params['position'] : '');
   }

   public function smartyUseStylesheet($params, $smarty)
   {
      $this->theme->addStylesheet($params['src'], isset($params['position']) ? $params['position'] : '');
   }
   
   public function smartyUseLess($params, $smarty)
   {
      $this->theme->addLess($params['src'], isset($params['position']) ? $params['position'] : '');
   }   

   public function smartySet($params, $smarty)
   {
      if (isset($params['meta_title']))
      {
         $this->response->setTitle($params['meta_title']);
      }

      if (isset($params['meta_keywords']))
      {
         $this->response->addMeta('keywords', $params['meta_keywords'], true);
      }

      if (isset($params['meta_description']))
      {
         $this->response->addMeta('description', $params['meta_description'], true);
      }

      if (isset($params['meta_robots']))
      {
         $this->response->addMeta('robotos', $params['meta_robots'], true);
      }

      if (isset($params['layout']))
      {
         $this->theme->setLayoutName($params['layout']);
      }
   }

   public function assignComponent($name, $module, $component, $params = array())
   {
      $this->_tpl_vars['_assigns'][$name] = array('type' => 'component', 'module' => $module, 'component' => $component, 'params' => $params);
   }

   public function assignPartial($name, $module, $component, $params = array())
   {
      $this->_tpl_vars['_assigns'][$name] = array('type' => 'partial', 'module' => $module, 'partial' => $component, 'params' => $params);
   }

   public function assignUrlFor($name, $internal_url, $params = array())
   {
      $this->_tpl_vars['_assigns'][$name] = array('type' => 'url_for', 'internal_url' => $internal_url, 'params' => $params);
   }

   public function assignLinkTo($name, $label, $internal_url, $params = array())
   {
      $this->_tpl_vars['_assigns'][$name] = array('type' => 'link_to', 'label' => $label, 'internal_url' => $internal_url, 'params' => $params);
   }

   public function smartyProcessAssign($name)
   {
      switch ($this->_tpl_vars['_assigns'][$name]['type'])
      {
         case 'component':
            $this->_tpl_vars[$name] = st_get_component($this->_tpl_vars['_assigns'][$name]['module'], $this->_tpl_vars['_assigns'][$name]['component'], $this->_tpl_vars['_assigns'][$name]['params']);
            break;
         case 'partial':
            $this->_tpl_vars[$name] = st_get_partial($this->_tpl_vars['_assigns'][$name]['module'].'/'.$this->_tpl_vars['_assigns'][$name]['partial'], $this->_tpl_vars['_assigns'][$name]['params']);
            break;
         case 'url_for':
            $this->_tpl_vars[$name] = st_url_for($this->_tpl_vars['_assigns'][$name]['internal_url'], $this->_tpl_vars['_assigns'][$name]['is_absolute']);
            break;
         case 'link_to':
            $this->_tpl_vars[$name] = st_link_to($this->_tpl_vars['_assigns'][$name]['label'], $this->_tpl_vars['_assigns'][$name]['internal_url'], $this->_tpl_vars['_assigns'][$name]['params']);
            break;
      }
   }

   /**
    * Zwraca szablon smarty dla danego tematu. Jeśli nie ma plików tematu to zwracane są szablony z tematu 'default'.
    *
    * @param string $resource_name
    * @param string $cache_id
    * @param string $compile_id
    */
   function fetch($resource_name, $cache_id = null, $compile_id = null, $display = false)
   {
      $template_dir = sfConfig::get('sf_app_template_dir').DIRECTORY_SEPARATOR."theme";

      if (is_file($template_dir.DIRECTORY_SEPARATOR.$this->theme->getThemeName().DIRECTORY_SEPARATOR.$resource_name))
      {
         $template_dir .= DIRECTORY_SEPARATOR.$this->theme->getThemeName().DIRECTORY_SEPARATOR.$resource_name;
      }
      elseif (is_file($template_dir.DIRECTORY_SEPARATOR.$this->theme->getDefaultThemeName().DIRECTORY_SEPARATOR.$resource_name))
      {
         $template_dir .= DIRECTORY_SEPARATOR.$this->theme->getDefaultThemeName().DIRECTORY_SEPARATOR.$resource_name;
      }
      elseif (is_file($this->theme->getTemplateDir($this->moduleName).DIRECTORY_SEPARATOR.$this->theme->getThemeName().DIRECTORY_SEPARATOR.$resource_name))
      {
         $template_dir = $this->theme->getTemplateDir($this->moduleName).DIRECTORY_SEPARATOR.$this->theme->getThemeName().DIRECTORY_SEPARATOR.$resource_name;
      }
      elseif (is_file($this->theme->getTemplateDir($this->moduleName).DIRECTORY_SEPARATOR.$this->theme->getdefaultThemeName().DIRECTORY_SEPARATOR.$resource_name))
      {
         $template_dir = $this->theme->getTemplateDir($this->moduleName).DIRECTORY_SEPARATOR.$this->theme->getDefaultThemeName().DIRECTORY_SEPARATOR.$resource_name;
      }
      else
      {
         throw new Exception(__('Brakuje pliku template smarty: '.$resource_name));
      }

      return parent::fetch($template_dir, $cache_id, $compile_id, $display);
   }

   /**
    * assigns values to template variables
    *
    * @param array|string $tpl_var the template variable name(s)
    * @param mixed $value the value to assign
    */
   function fc_assign($tpl_var, $value = null)
   {
      // 2010-11-23 m@sote.pl add $lang
      $context = sfContext::getInstance();
      $sf_user = $context->getUser();
      $lang = $sf_user->getCulture();
      // end

      if (is_array($tpl_var))
      {
         foreach ($tpl_var as $key => $val)
         {
            if ($key != '')
            {
               $this->_tpl_vars[$key] = $val;
            }
         }
      }
      else
      {
         if ($tpl_var != '')
         {
            if (ST_FAST_CACHE_SAVE_MODE == 1)
            {
               $value = stFastCacheCode::code($tpl_var, 'fc_assign', $lang);
            }
            elseif (ST_FAST_CACHE_DEFAULT_MODE == 1)
            {
               stFastCacheCode::save($tpl_var, $value, $lang); // 2010-11-23 m@sote.pl add $lang                       
            }
            else
            {
               // fast cache code, update assign information
               $context = sfContext::getInstance();
               $sf_user = $context->getUser();
               $sf_user->setAttribute($tpl_var, $value);
               // end                      
            }
            $this->_tpl_vars[$tpl_var] = $value;
         }
      }
   }

}

/**
 * Funkcja przypisana do {lang} w Smarty. Wyświetla tekst w odpowiednim języku w szablonach.
 *
 * @param array  $params
 * @param object $smarty
 */
function smarty_lang($params, &$smarty)
{
   if (empty($params['langAgrs']))
      $params['langAgrs'] = array();
   if (empty($params['langCatalogue']))
      $params['langCatalogue'] = 'messages';
   return __($params['text'], $params['langAgrs'], $params['langCatalogue']);
}

function smarty_assign_filter($compiled, &$smarty)
{
   static $already_assigned = array();
   
   $assign_content = array();

   if (preg_match_all('/\$this->_tpl_vars\[\'([^\']+)\'\]/', $compiled, $matches))
   {
      
      foreach ($matches[1] as $assign)
      {
         if (isset($already_assigned[$assign]))
         {
            continue;
         }
         
         $already_assigned[$assign] = true;
         
         $assign_content[] = sprintf('if (isset($this->_tpl_vars[\'_assigns\'][\'%s\']))', $assign);

         $assign_content[] = '{';

         $assign_content[] = sprintf('   $this->smartyProcessAssign(\'%s\');', $assign);

         $assign_content[] = '}';
      }
   }

   return $assign_content ? "<?php\n".implode("\n", $assign_content)."\n?>\n".$compiled : $compiled;
}

function smarty_slot_filter($source, &$smarty)
{
   $theme = stTheme::getInstance(sfContext::getInstance())->getTheme();

   return stSmartySlotFilterPropel::filter($theme, $source);
}

/**
 * Funkcja przypisana do {image} w Smarty. Wyświetla zdjęcie.
 *
 * @param array  $params parametry <image>: 'src' 'alt'
 * @param object $smarty
 */
function smarty_image($params, &$smarty)
{
   return st_theme_image_tag($params['src'], $options = array('alt' => $params['alt']));
}

/**
 * Funkcja przypisania do {link}. Przypisanie otwarcia linku <a ...>.
 * Treść linku jest automatycznie tłumaczona. Funkcja weryfikuje czy dany routing, do którego kieruje link istnieje.
 *
 * @param array  $params
 * @param object $smarty
 */
function smarty_link($params, &$smarty)
{
   if (empty($params['langAgrs']))
      $params['langAgrs'] = array();
   if (empty($params['langCatalogue']))
      $params['langCatalogue'] = 'messages';

   $route = ereg_replace("^@", '', $params['uri']);
   $routing = sfRouting::getInstance();
   $routes = $routing->getRoutes();
   if (isset($routes[$route]))
   {
      return link_to(__($params['text'], $params['langAgrs'], $params['langCatalogue']), $params['uri']);
   }
   else
      return link_to(__($params['text'], $params['langAgrs'], $params['langCatalogue']), $params['uri']);
}

/**
 * Zalacza zawartość o danym id kontenera
 *
 * @param array $params
 * @param object $smarty
 */
function include_content($params, &$smarty)
{
   $content = $smarty->getTheme()->getLayoutConfig($params['id']);

   if (is_array($content['display']))
   {
      if (isset($content['hide']))
      {
         $hide = array_flip($content['hide']);
      }

      foreach ($content['display'] as $name)
      {
         if (isset($hide[$name]))
            continue;

         $component = explode('.', $name);

         if (!isset($component[1]))
         {
            $tmp = explode('-', $component[0]);
            // if (ST_FAST_CACHE_SAVE_MODE)
            // {
            // } else
            // {
            echo st_get_partial($tmp[0], is_array($content['params'][$name]) ? $content['params'][$name] : array());
            // }
         }
         else
         {
            $tmp = explode('-', $component[1]);
            // if (ST_FAST_CACHE_SAVE_MODE)
            // {
            // } else 
            // {
            echo st_get_component($component[0], $tmp[0], is_array($content['params'][$name]) ? $content['params'][$name] : array());
            // }
         }
      }
   }
}

/**
 * Zalacza plik o danym id
 *
 * @param array $params
 * @param object $smarty
 */
function include_file($params, &$smarty)
{
   $smarty->display($params['id'].'.html');
}

/**
 * Zwraca tooltip
 *
 * @param array $params
 * @param object $smarty
 * @return HTML
 * @todo przeniesc do stTooltip
 */
function smarty_tooltip($params, &$smarty)
{
   if (isset($params['keyword']) && isset($params['type']) && isset($params['width']))
   {
      return get_tooltip($params['keyword'], $params['type'], $params['width']);
   }
   elseif (isset($params['keyword']) && isset($params['type']))
   {
      return get_tooltip($params['keyword'], $params['type']);
   }
   elseif (isset($params['keyword']))
   {
      return get_tooltip($params['keyword']);
   }
   else
   {
      return '';
   }
}

/**
 * Zwraca tooltip
 *
 * @param array $params
 * @param object $smarty
 * @return HTML
 * @todo przeniesc do stTooltip
 */
function edit_image_tooltip($params, &$smarty)
{
   return get_tooltip('', '4', '');
}

/**
 * @todo Przeniesc do stTooltip
 */
function init_tooltip($params, &$smarty)
{
   include_tooltip();
   return;
}

/**
 * Załacza komponent
 *
 * @param array $params
 * @param object $smarty
 * @todo dodac obsluge logger'a
 */
function include_st_component($params, &$smarty)
{
   if (!empty($params['params']))
   {
      $params2 = array('params' => $params['params']);
   }
   else
      $params2=array();
   echo st_get_component($params['module'], $params['component'], $params2);
}

function smarty_st_category_image_tag($params, $smarty)
{
   return st_category_image_tag($params['category'], $params['image_type']);
}

function smarty_st_link_to($params, $content, &$smarty, &$repeat)
{
   use_helper('stUrl');

   if (isset($params['uri']))
   {
      $uri = $params['uri'];
      unset($params['uri']);
   }

   return st_link_to($content, $uri, $params);
}

function smarty_st_get_component($params, $smarty)
{
   if (isset($params['params']))
   {
      $parameters = _parse_attributes($params['params']);
   }

   return st_get_component($params['module'], $params['component'], $parameters);
}

function smarty_st_get_partial($params, $smarty)
{
   if (isset($params['params']))
   {
      $parameters = _parse_attributes($params['params']);
   }

   return st_get_partial($params['partial'], $parameters);
}

function smarty_urlfor($params)
{
   return url_for($params['internal']);
}

function smarty_st_socket($params, $smarty)
{
   if ($params['type'] == 'component')
      return stSocketView::openComponents($params['name']);
   elseif ($params['type'] == 'partial')
      return stSocketView::openPartials($params['name']);
}

function smarty_image_path($params)
{
   return _st_get_image_path($params['image']);
}