<?php
class stSmartySlotFilter
{
   protected $parser = null;
   
   protected $data = null;
      
   public function __construct(stSmartySlotParser $parser)
   {
      $this->parser = $parser;
   }

   public function execute()
   {
      $this->data = $this->parser->getSource();
      
      $this->parser->parse(array($this, 'callback'));

      return $this->data;
   }

   public function callback($slot, $components, $replace)
   {      
      $c = stEventDispatcher::getInstance()->filter(new sfEvent($this, 'smarty.slot.prepend', array('slot' => $slot['name'])), array())->getReturnValue();
     
      $c = array_merge($c, $this->filterComponents($components));
      
      $c = stEventDispatcher::getInstance()->filter(new sfEvent($this, 'smarty.slot.append', array('slot' => $slot['name'])), $c)->getReturnValue();
      
      $this->replace($replace, $c);
   }
   
   protected function replace($replace, $components = array())
   {
      $this->data = str_replace($replace, $components ? "{php}\n".implode("\n", $components)."\n{/php}" : '', $this->data);
   }
   
   protected function filterComponents($components = array())
   {
      $content = array();

      foreach ($components as $component)
      {
         if (!isset($component['attr']['name']))
         {
            throw new sfException('Smarty slot.'.$component['type'].': parameter "name" is mandatory');
         }
         
         switch ($component['type'])
         {
            case 'partial':
               $content[] = $this->filterPartial($component['attr']['name'], $component['attr']['parameters']);
               break;
            case 'component':
               list($module, $name) = explode('/', $component['attr']['name']);
               $content[] = $this->filterComponent($module, $name, $component['attr']['parameters']);
               break;
         }
      }

      return $content;
   }
   
   public function createComponent($module, $component, $params = array())
   {
      return $this->filterComponent($module, $component, $params);
   }
   
   public function createPartial($name, $params = array())
   {
      return $this->filterPartial($name, $params);
   }
   
   protected function filterComponent($module, $component, $params = array())
   {
      return sprintf('echo st_get_component(\'%s\', \'%s\', %s);', $module, $component, var_export($params, true));
   }

   protected function filterPartial($name, $params = array())
   {
      return sprintf('echo st_get_partial(\'%s\', %s);', $name, var_export($params, true));
   }

}