<?php

class stSmartySlotFilterPropel extends stSmartySlotFilter
{
   protected $theme = null;
   
   public static function filter(Theme $theme, $source)
   {
      $parser = new stSmartySlotParser($source);

      $compiler = new stSmartySlotFilterPropel($parser, $theme);

      return $compiler->execute();
   }
   
   public function __construct(stSmartySlotParser $parser, Theme $theme)
   {
      parent::__construct($parser);
      
      $this->theme = $theme;
   }

   public function callback($slot, $components, $replace)
   {
      parent::callback($slot, $this->fetchComponents($slot['name'], $components), $replace);
   }

   protected function fetchComponents($slot_name, $default = array())
   {
      $slot = ThemeSlotPeer::doSelectByNameAndThemeId($slot_name, $this->theme->getId());

      if ($slot)
      {
         $components = $slot->getIsActive() ? $slot->getComponents() : array();
      }
      else
      {
         $components = $default;
      }

      return $components;
   }

}
