<?php

class stSmartySlotParser
{

   protected $source = null;

   public function __construct($source = null)
   {
      $this->source = $source;
   }

   public function parse($callback)
   {
      if ($this->source && preg_match_all('/\{slot\s*(.+?)\}(.*?)\{\/slot\}/si', $this->source, $slots))
      {
         foreach ($slots[0] as $i => $replace)
         {
            $slot_attr = $this->parseAttributes($slots[1][$i]);

            if (!isset($slot_attr['name']))
            {
               throw new sfException('Smarty slot: parameter "name" is mandatory');
            }

            $components_attr = $this->parseComponents($slots[2][$i]);

            call_user_func($callback, $slot_attr, $components_attr, $replace);
         }
      }
   }

   public function setSource($source)
   {
      $this->source = $source;
   }

   public function getSource()
   {
      return $this->source;
   }

   protected function parseComponents($source)
   {
      $components_attr = array();

      if (preg_match_all('/\{(partial|component)\s*(.+?)\}/', $source, $content))
      {
         foreach ($content[1] as $j => $type)
         {
            $attr = $this->parseAttributes($content[2][$j]);

            if (!isset($attr['parameters']))
            {
               $attr['parameters'] = array();
            }
            else
            {
               $attr['parameters'] = $this->parseParameters($attr['parameters']);
            }

            $components_attr[] = array('type' => $type, 'attr' => $attr);
         }
      }
      
      return $components_attr;
   }

   protected function parseAttributes($content)
   {
      $attr = array();

      if (preg_match_all('/\s*([^=]+)="([^"]+)"\s*/', $content, $tmp))
      {
         foreach ($tmp[1] as $i => $name)
         {
            $attr[trim($name)] = trim($tmp[2][$i]);
         }
      }

      return $attr;
   }

   protected function parseParameters($content)
   {
      $params = array();

      if (preg_match_all('/\s*([^:]+):\s+([^,]+),?\s*/', $content, $tmp))
      {
         foreach ($tmp[1] as $i => $name)
         {
            $params[trim($name)] = trim($tmp[2][$i]);
         }
      }

      return $params;
   }

}
